/*
 * Decompiled with CFR 0.152.
 */
package parachute.client;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;
import parachute.client.ModelParachute;
import parachute.common.EntityParachute;
import parachute.common.Parachute;

public class RenderParachute
extends Render {
    protected static int colorIndex;
    protected static Random rand;
    protected static ModelBase modelParachute;
    protected static boolean randomColor;
    protected static String clothColor;

    public RenderParachute() {
        this.field_76989_e = 0.0f;
        colorIndex = Parachute.instance.getChuteColor();
        randomColor = colorIndex == -1;
        rand = new Random(System.currentTimeMillis());
        if (randomColor) {
            clothColor = "/textures/blocks/cloth_" + rand.nextInt(16) + ".png";
        }
        modelParachute = new ModelParachute();
    }

    public void renderParachute(EntityParachute entityparachute, double x, double y, double z, float rotation, float center) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glRotatef((float)(180.0f - rotation), (float)0.0f, (float)1.0f, (float)0.0f);
        float time = (float)entityparachute.getTimeSinceHit() - center;
        float damage = (float)entityparachute.getDamageTaken() - center;
        if (damage < 0.0f) {
            damage = 0.0f;
        }
        if (time > 0.0f) {
            GL11.glRotatef((float)(MathHelper.func_76126_a((float)time) * time * damage / 20.0f * (float)entityparachute.getForwardDirection()), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        this.func_76985_a(clothColor);
        modelParachute.func_78088_a((Entity)entityparachute, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        if (entityparachute.field_70153_n != null) {
            EntityPlayer rider = (EntityPlayer)entityparachute.field_70153_n;
            this.renderCords(rider, center);
        }
        GL11.glPopMatrix();
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float rotation, float center) {
        this.renderParachute((EntityParachute)entity, x, y, z, rotation, center);
    }

    public void renderCords(EntityPlayer rider, float center) {
        float x = -5.0f;
        float y = 2.0f;
        if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
            y = 1.25f;
        }
        float z = 0.0f;
        float b = rider.func_70013_c(center);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glScalef((float)0.0625f, (float)-1.0f, (float)0.0625f);
        GL11.glBegin((int)1);
        GL11.glColor3f((float)(b * 0.5f), (float)(b * 0.5f), (float)(b * 0.65f));
        GL11.glVertex3f((float)-8.0f, (float)0.25f, (float)-23.5f);
        GL11.glVertex3f((float)x, (float)y, (float)z);
        GL11.glVertex3f((float)8.0f, (float)0.25f, (float)-23.5f);
        GL11.glVertex3f((float)x, (float)y, (float)z);
        GL11.glVertex3f((float)-8.0f, (float)0.0f, (float)-8.0f);
        GL11.glVertex3f((float)x, (float)y, (float)z);
        GL11.glVertex3f((float)8.0f, (float)0.0f, (float)-8.0f);
        GL11.glVertex3f((float)x, (float)y, (float)z);
        GL11.glColor3f((float)(b * 0.65f), (float)(b * 0.5f), (float)(b * 0.5f));
        GL11.glVertex3f((float)-8.0f, (float)0.25f, (float)23.5f);
        GL11.glVertex3f((float)x, (float)y, (float)z);
        GL11.glVertex3f((float)8.0f, (float)0.25f, (float)23.5f);
        GL11.glVertex3f((float)x, (float)y, (float)z);
        GL11.glVertex3f((float)-8.0f, (float)0.0f, (float)8.0f);
        GL11.glVertex3f((float)x, (float)y, (float)z);
        GL11.glVertex3f((float)8.0f, (float)0.0f, (float)8.0f);
        GL11.glVertex3f((float)x, (float)y, (float)z);
        GL11.glEnd();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
    }

    public static void setParachuteColor(int index) {
        colorIndex = index;
        if (index == -1) {
            clothColor = "/textures/blocks/cloth_" + rand.nextInt(16) + ".png";
            randomColor = true;
        } else {
            clothColor = "/textures/blocks/cloth_" + index + ".png";
            randomColor = false;
        }
    }

    public static void randomParachuteColor() {
        RenderParachute.setParachuteColor(-1);
    }

    public static boolean isColorRandom() {
        return randomColor;
    }
}

