/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator.fml;

import bspkrs.fml.util.Config;
import bspkrs.fml.util.bspkrsCoreProxy;
import bspkrs.treecapitator.TCLog;
import bspkrs.treecapitator.TreeBlockBreaker;
import bspkrs.treecapitator.TreeCapitator;
import bspkrs.treecapitator.fml.ClientPacketHandler;
import bspkrs.treecapitator.fml.CommonProxy;
import bspkrs.treecapitator.fml.ConnectionHandler;
import bspkrs.treecapitator.fml.IDResolverMapping;
import bspkrs.treecapitator.fml.IDResolverMappingList;
import bspkrs.treecapitator.fml.PlayerHandler;
import bspkrs.treecapitator.fml.ServerPacketHandler;
import bspkrs.treecapitator.fml.TreeCapitatorServer;
import bspkrs.util.BlockID;
import bspkrs.util.CommonUtils;
import bspkrs.util.Coord;
import bspkrs.util.ModVersionChecker;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.network.NetworkMod;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import net.minecraftforge.common.ConfigCategory;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.MinecraftForge;
import sharose.mods.idresolver.IDResolverBasic;

@Mod(name="TreeCapitator", modid="TreeCapitator", version="Forge 1.5.1.r01", dependencies="required-after:mod_bspkrsCore", useMetadata=true)
@NetworkMod(clientSideRequired=false, serverSideRequired=false, clientPacketHandlerSpec=@NetworkMod.SidedPacketHandler(channels={"TreeCapitator"}, packetHandler=ClientPacketHandler.class), serverPacketHandlerSpec=@NetworkMod.SidedPacketHandler(channels={"TreeCapitator"}, packetHandler=ServerPacketHandler.class), connectionHandler=ConnectionHandler.class)
public class TreeCapitatorMod
extends DummyModContainer {
    public static ModVersionChecker versionChecker;
    private final String versionURL = "http://bspk.rs/Minecraft/1.5.1/treeCapitatorForge.version";
    private final String mcfTopic = "http://www.minecraftforum.net/topic/1009577-";
    public static final String TREE_BLOCK_CTGY = "2_tree_definitions";
    public static final String THIRD_PARTY_CFG_CTGY = "1_third_party_configs";
    public static final String BLOCK_CTGY = "block_settings";
    public static final String ITEM_CTGY = "item_settings";
    public static final String LEAF_CTGY = "leaf_and_vine_settings";
    public static final String MISC_CTGY = "miscellaneous_settings";
    public static final String ID_RES_CTGY = "id_resolver_settings";
    public static final String GENERAL = "general";
    public static boolean isCoreModLoaded;
    @Mod.Metadata(value="TreeCapitator")
    public static ModMetadata metadata;
    public Configuration config;
    private static String idResolverModIDDesc;
    private static String idResolverModID;
    private static String idResolverConfigPathDesc;
    private static String idResolverConfigPath;
    @SidedProxy(clientSide="bspkrs.treecapitator.fml.ClientProxy", serverSide="bspkrs.treecapitator.fml.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="TreeCapitator")
    public static TreeCapitatorMod instance;
    private static Loader loader;

    public TreeCapitatorMod() {
        loader = Loader.instance();
        new bspkrsCoreProxy();
    }

    @Mod.PreInit
    public void preInit(FMLPreInitializationEvent event) {
        TreeCapitator.init(true);
        metadata = event.getModMetadata();
        File file = event.getSuggestedConfigurationFile();
        Configuration config = new Configuration(file);
        config.load();
        TreeCapitator.onlyDestroyUpwards = Config.getBoolean((Configuration)config, (String)"onlyDestroyUpwards", (String)MISC_CTGY, (boolean)TreeCapitator.onlyDestroyUpwards, (String)"Setting this to false will allow the chopping to move downward as well as upward (and blocks below the one you break will be chopped)");
        TreeCapitator.disableInCreative = Config.getBoolean((Configuration)config, (String)"disableInCreative", (String)MISC_CTGY, (boolean)TreeCapitator.disableInCreative, (String)"Flag to disable tree chopping in Creative mode");
        TreeCapitator.disableCreativeDrops = Config.getBoolean((Configuration)config, (String)"disableCreativeDrops", (String)MISC_CTGY, (boolean)TreeCapitator.disableCreativeDrops, (String)"Flag to disable drops in Creative mode");
        TreeCapitator.sneakAction = Config.getString((Configuration)config, (String)"sneakAction", (String)MISC_CTGY, (String)TreeCapitator.sneakAction, (String)"Set sneakAction = \"disable\" to disable tree chopping while sneaking,\nset sneakAction = \"enable\" to only enable tree chopping while sneaking,\nset sneakAction = \"none\" to have tree chopping enabled regardless of sneaking.");
        TreeCapitator.maxBreakDistance = Config.getInt((Configuration)config, (String)"maxBreakDistance", (String)MISC_CTGY, (int)TreeCapitator.maxBreakDistance, (int)-1, (int)100, (String)"The maximum horizontal distance that the log breaking effect will travel (use -1 for no limit).");
        TreeCapitator.allowSmartTreeDetection = Config.getBoolean((Configuration)config, (String)"allowSmartTreeDetection", (String)MISC_CTGY, (boolean)TreeCapitator.allowSmartTreeDetection, (String)"Set to false to disable TreeCapitator Smart Tree Detection.\nSmart Tree Detection counts the number of leaf blocks that are adjacent to the\ntop-most connected log block at the x, z location of a log you've broken. If\nthere are at least minLeavesToID leaf blocks within maxLeafIDDist blocks then\nTreeCapitator considers it a tree and allows chopping.\nWARNING: Disabling Smart Tree Detection will remove the only safeguard against\naccidentally destroying a log structure.  Make sure you know what you're doing!");
        TreeCapitator.axeIDList = Config.getString((Configuration)config, (String)"axeIDList", (String)ITEM_CTGY, (String)TreeCapitator.axeIDList, (String)"IDs of items that can chop down trees. Use ',' to split item id from metadata and ';' to split items.");
        TreeCapitator.shearIDList = Config.getString((Configuration)config, (String)"shearIDList", (String)ITEM_CTGY, (String)TreeCapitator.shearIDList, (String)"IDs of items that when placed in the hotbar will allow leaves to be sheared when shearLeaves is true.\nUse ',' to split item id from metadata and ';' to split items.");
        TreeCapitator.needItem = Config.getBoolean((Configuration)config, (String)"needItem", (String)ITEM_CTGY, (boolean)TreeCapitator.needItem, (String)"Whether you need an item from the axeIDList to chop down a tree. Disabling will let you chop trees with any item.");
        TreeCapitator.allowItemDamage = Config.getBoolean((Configuration)config, (String)"allowItemDamage", (String)ITEM_CTGY, (boolean)TreeCapitator.allowItemDamage, (String)"Enable to cause item damage based on number of blocks destroyed");
        TreeCapitator.allowMoreBlocksThanDamage = Config.getBoolean((Configuration)config, (String)"allowMoreBlocksThanDamage", (String)ITEM_CTGY, (boolean)TreeCapitator.allowMoreBlocksThanDamage, (String)"Enable to allow chopping down the entire tree even if your item does not have enough damage remaining to cover the number of blocks.");
        TreeCapitator.damageMultiplier = Config.getFloat((Configuration)config, (String)"damageMultiplier", (String)ITEM_CTGY, (float)TreeCapitator.damageMultiplier, (float)0.1f, (float)50.0f, (String)"Axes and shears will take damage this many times for each log broken.\nRemaining damage is rounded and applied to tools when a tree is finished.");
        TreeCapitator.useIncreasingItemDamage = Config.getBoolean((Configuration)config, (String)"useIncreasingItemDamage", (String)ITEM_CTGY, (boolean)TreeCapitator.useIncreasingItemDamage, (String)"Set to true to have the per-block item damage amount increase after every increaseDamageEveryXBlocks blocks are broken.");
        TreeCapitator.increaseDamageEveryXBlocks = Config.getInt((Configuration)config, (String)"increaseDamageEveryXBlocks", (String)ITEM_CTGY, (int)TreeCapitator.increaseDamageEveryXBlocks, (int)1, (int)500, (String)"When useIncreasingItemDamage=true the damage applied per block broken will increase each time this many blocks are broken in a tree.");
        TreeCapitator.damageIncreaseAmount = Config.getFloat((Configuration)config, (String)"damageIncreaseAmount", (String)ITEM_CTGY, (float)TreeCapitator.damageIncreaseAmount, (float)0.1f, (float)100.0f, (String)"When useIncreasingItemDamage=true the damage applied per block broken will increase by this amount every increaseDamageEveryXBlocks blocks broken in a tree.");
        TreeCapitator.destroyLeaves = Config.getBoolean((Configuration)config, (String)"destroyLeaves", (String)LEAF_CTGY, (boolean)TreeCapitator.destroyLeaves, (String)"Enabling this will make leaves be destroyed when trees are chopped.");
        TreeCapitator.requireLeafDecayCheck = Config.getBoolean((Configuration)config, (String)"requireLeafDecayCheck", (String)LEAF_CTGY, (boolean)TreeCapitator.requireLeafDecayCheck, (String)"When true TreeCapitator will only instantly decay leaves that have actually been marked for decay.\nSet to false if you want leaves to be destroyed regardless of their decay status (hint: or for \"leaf\" blocks that are not really leaves).");
        TreeCapitator.shearLeaves = Config.getBoolean((Configuration)config, (String)"shearLeaves", (String)LEAF_CTGY, (boolean)TreeCapitator.shearLeaves, (String)"Enabling this will cause destroyed leaves to be sheared when a shearing item is in the hotbar (ignored if destroyLeaves is false).");
        TreeCapitator.shearVines = Config.getBoolean((Configuration)config, (String)"shearVines", (String)LEAF_CTGY, (boolean)TreeCapitator.shearVines, (String)"Enabling this will shear /some/ of the vines on a tree when a shearing item is in the hotbar (ignored if destroyLeaves is false).");
        TreeCapitator.logHardnessNormal = Config.getFloat((Configuration)config, (String)"logHardnessNormal", (String)BLOCK_CTGY, (float)TreeCapitator.logHardnessNormal, (float)0.0f, (float)100.0f, (String)"The hardness of logs for when you are using items that won't chop down the trees.");
        TreeCapitator.logHardnessModified = Config.getFloat((Configuration)config, (String)"logHardnessModified", (String)BLOCK_CTGY, (float)TreeCapitator.logHardnessModified, (float)0.0f, (float)100.0f, (String)"The hardness of logs for when you are using items that can chop down trees.");
        if (config.hasCategory(GENERAL)) {
            TreeCapitator.onlyDestroyUpwards = Config.getBoolean((Configuration)config, (String)"onlyDestroyUpwards", (String)GENERAL, (boolean)TreeCapitator.onlyDestroyUpwards, (String)"Setting this to false will allow the chopping to move downward as well as upward (and blocks below the one you break will be chopped)");
            Config.setFromOldCtgy((Configuration)config, (String)"onlyDestroyUpwards", (String)GENERAL, (String)MISC_CTGY);
            TreeCapitator.disableInCreative = Config.getBoolean((Configuration)config, (String)"disableInCreative", (String)GENERAL, (boolean)TreeCapitator.disableInCreative, (String)"Flag to disable tree chopping in Creative mode");
            Config.setFromOldCtgy((Configuration)config, (String)"disableInCreative", (String)GENERAL, (String)MISC_CTGY);
            TreeCapitator.disableCreativeDrops = Config.getBoolean((Configuration)config, (String)"disableCreativeDrops", (String)GENERAL, (boolean)TreeCapitator.disableCreativeDrops, (String)"Flag to disable drops in Creative mode");
            Config.setFromOldCtgy((Configuration)config, (String)"disableCreativeDrops", (String)GENERAL, (String)MISC_CTGY);
            TreeCapitator.sneakAction = Config.getString((Configuration)config, (String)"sneakAction", (String)GENERAL, (String)TreeCapitator.sneakAction, (String)"Set sneakAction = \"disable\" to disable tree chopping while sneaking,\nset sneakAction = \"enable\" to only enable tree chopping while sneaking,\nset sneakAction = \"none\" to have tree chopping enabled regardless of sneaking.");
            Config.setFromOldCtgy((Configuration)config, (String)"sneakAction", (String)GENERAL, (String)MISC_CTGY);
            TreeCapitator.maxBreakDistance = Config.getInt((Configuration)config, (String)"maxBreakDistance", (String)GENERAL, (int)TreeCapitator.maxBreakDistance, (int)-1, (int)100, (String)"The maximum horizontal distance that the log breaking effect will travel (use -1 for no limit).");
            Config.setFromOldCtgy((Configuration)config, (String)"maxBreakDistance", (String)GENERAL, (String)MISC_CTGY);
            TreeCapitator.axeIDList = Config.getString((Configuration)config, (String)"axeIDList", (String)GENERAL, (String)TreeCapitator.axeIDList, (String)"IDs of items that can chop down trees. Use ',' to split item id from metadata and ';' to split items.");
            Config.setFromOldCtgy((Configuration)config, (String)"axeIDList", (String)GENERAL, (String)ITEM_CTGY);
            TreeCapitator.shearIDList = Config.getString((Configuration)config, (String)"shearIDList", (String)GENERAL, (String)TreeCapitator.shearIDList, (String)"IDs of items that when placed in the hotbar will allow leaves to be sheared when shearLeaves is true.\nUse ',' to split item id from metadata and ';' to split items.");
            Config.setFromOldCtgy((Configuration)config, (String)"shearIDList", (String)GENERAL, (String)ITEM_CTGY);
            TreeCapitator.needItem = Config.getBoolean((Configuration)config, (String)"needItem", (String)GENERAL, (boolean)TreeCapitator.needItem, (String)"Whether you need an item from the axeIDList to chop down a tree. Disabling will let you chop trees with any item.");
            Config.setFromOldCtgy((Configuration)config, (String)"needItem", (String)GENERAL, (String)ITEM_CTGY);
            TreeCapitator.allowItemDamage = Config.getBoolean((Configuration)config, (String)"allowItemDamage", (String)GENERAL, (boolean)TreeCapitator.allowItemDamage, (String)"Enable to cause item damage based on number of blocks destroyed");
            Config.setFromOldCtgy((Configuration)config, (String)"allowItemDamage", (String)GENERAL, (String)ITEM_CTGY);
            TreeCapitator.allowMoreBlocksThanDamage = Config.getBoolean((Configuration)config, (String)"allowMoreBlocksThanDamage", (String)GENERAL, (boolean)TreeCapitator.allowMoreBlocksThanDamage, (String)"Enable to allow chopping down the entire tree even if your item does not have enough damage remaining to cover the number of blocks.");
            Config.setFromOldCtgy((Configuration)config, (String)"allowMoreBlocksThanDamage", (String)GENERAL, (String)ITEM_CTGY);
            TreeCapitator.destroyLeaves = Config.getBoolean((Configuration)config, (String)"destroyLeaves", (String)GENERAL, (boolean)TreeCapitator.destroyLeaves, (String)"Enabling this will make leaves be destroyed when trees are chopped.");
            Config.setFromOldCtgy((Configuration)config, (String)"destroyLeaves", (String)GENERAL, (String)LEAF_CTGY);
            TreeCapitator.shearLeaves = Config.getBoolean((Configuration)config, (String)"shearLeaves", (String)GENERAL, (boolean)TreeCapitator.shearLeaves, (String)"Enabling this will cause destroyed leaves to be sheared when a shearing item is in the hotbar (ignored if destroyLeaves is false).");
            Config.setFromOldCtgy((Configuration)config, (String)"shearLeaves", (String)GENERAL, (String)LEAF_CTGY);
            TreeCapitator.shearVines = Config.getBoolean((Configuration)config, (String)"shearVines", (String)GENERAL, (boolean)TreeCapitator.shearVines, (String)"Enabling this will shear /some/ of the vines on a tree when a shearing item is in the hotbar (ignored if destroyLeaves is false).");
            Config.setFromOldCtgy((Configuration)config, (String)"shearVines", (String)GENERAL, (String)LEAF_CTGY);
            TreeCapitator.logHardnessNormal = Config.getFloat((Configuration)config, (String)"logHardnessNormal", (String)GENERAL, (float)TreeCapitator.logHardnessNormal, (float)0.0f, (float)100.0f, (String)"The hardness of logs for when you are using items that won't chop down the trees.");
            Config.setFromOldCtgy((Configuration)config, (String)"logHardnessNormal", (String)GENERAL, (String)BLOCK_CTGY);
            TreeCapitator.logHardnessModified = Config.getFloat((Configuration)config, (String)"logHardnessModified", (String)GENERAL, (float)TreeCapitator.logHardnessModified, (float)0.0f, (float)100.0f, (String)"The hardness of logs for when you are using items that can chop down trees.");
            Config.setFromOldCtgy((Configuration)config, (String)"logHardnessModified", (String)GENERAL, (String)BLOCK_CTGY);
            Config.renameCtgy((Configuration)config, (String)GENERAL, (String)"z_converted_general");
            config.addCustomCategoryComment("z_converted_general", "Your old config settings have been migrated to their new homes.  Except for logIDList.  It's not convertible. :p");
        }
        TreeCapitator.allowDebugOutput = Config.getBoolean((Configuration)config, (String)"allowDebugOutput", (String)MISC_CTGY, (boolean)TreeCapitator.allowDebugOutput, (String)"Set to true if you want TreeCapitator to tell you what kind of block you have clicked when sneaking, false to disable.");
        TreeCapitator.allowDebugLogging = Config.getBoolean((Configuration)config, (String)"allowDebugLogging", (String)MISC_CTGY, (boolean)TreeCapitator.allowDebugLogging, (String)"Set to true if you want TreeCapitator to log info about what it's doing, false to disable");
        TreeCapitator.maxLeafIDDist = Config.getInt((Configuration)config, (String)"maxLeafIDDist", (String)MISC_CTGY, (int)TreeCapitator.maxLeafIDDist, (int)1, (int)8, (String)"If a tree's top log is not close enough to leaf blocks, the tree will not be chopped.\nIncreasing this value will search further.  I would try to keep it below 3.");
        TreeCapitator.minLeavesToID = Config.getInt((Configuration)config, (String)"minLeavesToID", (String)MISC_CTGY, (int)TreeCapitator.minLeavesToID, (int)0, (int)8, (String)"The minimum number of leaves within maxLeafIDDist of the top log block required to identify a tree.");
        TreeCapitator.allowGetRemoteTreeConfig = Config.getBoolean((Configuration)config, (String)"allowGetRemoteTreeConfig", (String)BLOCK_CTGY, (boolean)TreeCapitator.allowGetRemoteTreeConfig, (String)"Incomplete - do not use");
        TreeCapitator.remoteTreeConfigURL = Config.getString((Configuration)config, (String)"remoteTreeConfigURL", (String)BLOCK_CTGY, (String)TreeCapitator.remoteTreeConfigURL, (String)"Incomplete - do not use");
        TreeCapitator.remoteBlockIDConfig = TreeCapitator.getRemoteConfig();
        TreeCapitator.useRemoteTreeConfig = Config.getBoolean((Configuration)config, (String)"useRemoteTreeConfig", (String)BLOCK_CTGY, (boolean)TreeCapitator.useRemoteTreeConfig, (String)"Incomplete - do not use");
        TreeCapitator.useStrictBlockPairing = Config.getBoolean((Configuration)config, (String)"useStrictBlockPairing", (String)BLOCK_CTGY, (boolean)TreeCapitator.useStrictBlockPairing, (String)"Set to true if you want only the leaf blocks listed with each log in blockIDList\nto break when that log type is chopped.  When set to false it will break\nany leaf type within range of the tree, not just the type for that tree.");
        idResolverModID = Config.getString((Configuration)config, (String)"idResolverModID", (String)ID_RES_CTGY, (String)idResolverModID, (String)idResolverModIDDesc);
        config.addCustomCategoryComment(ID_RES_CTGY, "If you are not using ID Resolver, you can safely ignore this section.\nIf you ARE using ID Resolver and your log file does not show any warnings\npertaining to ID Resolver, you can still ignore this section. In fact, the\nonly reason you should mess with this section if ShaRose decides to change\nthe Mod ID for ID Resolver.");
        if (config.hasCategory("2_block_id")) {
            Config.renameCtgy((Configuration)config, (String)"2_block_id", (String)TREE_BLOCK_CTGY);
        }
        if (!config.hasCategory(TREE_BLOCK_CTGY)) {
            for (String key : TreeCapitator.configBlockList.keySet()) {
                HashMap entry = (HashMap)TreeCapitator.configBlockList.get(key);
                for (String blockType : entry.keySet()) {
                    config.get("2_tree_definitions." + key, blockType, (String)entry.get(blockType));
                }
            }
            TCLog.info("Default block config loaded.", new Object[0]);
        } else {
            TreeCapitator.configBlockList = new HashMap();
            for (String ctgy : config.getCategoryNames()) {
                if (ctgy.indexOf("2_tree_definitions.") == -1) continue;
                HashMap<String, String> blocks = new HashMap<String, String>();
                if (!config.getCategory(ctgy).containsKey("logs")) continue;
                blocks.put("logs", config.getCategory(ctgy).get("logs").getString());
                if (config.getCategory(ctgy).containsKey("leaves")) {
                    blocks.put("leaves", config.getCategory(ctgy).get("leaves").getString());
                }
                TreeCapitator.configBlockList.put(ctgy, blocks);
            }
            TCLog.info("File block config loaded.", new Object[0]);
        }
        config.addCustomCategoryComment(TREE_BLOCK_CTGY, "Add the log and leaf block IDs for all trees you want to be able to chop down.\nEach section below represents a type of tree.  Each list may contain block IDs\nand/or third-party config replacement tags. You can change it to be more or\nless granular as long as all sections follow the basic structure.  Do not use\nspaces or periods in your section names.  Otherwise you can call them anything\nyou like.\n\nEACH LOG ID MAY ONLY APPEAR IN EXACTLY ONE SECTION.\n\nNOTE: Some mod trees use vanilla log blocks as well as custom blocks.  If a tree\ncontains more than 1 type of log, all logs must be included in the same section.\nExamples of this are the default entries for vanilla_ebxl_oaks and vanilla_ebxl_spruces.\n\nSimple Example (all logs and leaves are grouped in one section, no metadata is specified):\n    trees {\n        S:leaves=18; <Forestry.leaves>; <ExtrabiomesXL.autumnleaves.id>; <ExtrabiomesXL.greenleaves.id>\n        S:logs=17; <Forestry.log1>; <Forestry.log2>; <Forestry.log3>; <Forestry.log4>; <ExtrabiomesXL.customlog.id>; <ExtrabiomesXL.quarterlog0.id>; <ExtrabiomesXL.quarterlog1.id>; <ExtrabiomesXL.quarterlog2.id>;<ExtrabiomesXL.quarterlog3.id>\n    }\n\nAdvanced Example (each mod tree has its own section, metadata is included):\n    vanilla_ebxl_oaks {\n        S:leaves=18,0\n        S:logs=17,0; 17,4; 17,8; <ExtrabiomesXL.quarterlog0.id>,2; <ExtrabiomesXL.quarterlog1.id>,2; <ExtrabiomesXL.quarterlog2.id>,2;<ExtrabiomesXL.quarterlog3.id>,2;\n    }\n\n    birches {\n        S:leaves=18,2\n        S:logs=17,2; 17,6; 17,10\n    }\n\n    vanilla_ebxl_spruces {\n        S:leaves=18,1; <ExtrabiomesXL.autumnleaves.id>\n        S:logs=17,1; 17,5; 17,9\n    }\n\n    jungle_trees {\n        S:leaves=18,3\n        S:logs=17,3; 17,7; 17,11\n    }\n\n    ic2_rubber {\n        S:leaves=<IC2.blockRubLeaves>\n        S:logs=<IC2.blockRubWood>\n    }\n\n    ebxl_acacia {\n        S:leaves=<ExtrabiomesXL.greenleaves.id>,2\n        S:logs=<ExtrabiomesXL.customlog.id>,1\n    }\n\n    ebxl_firs {\n        S:leaves=<ExtrabiomesXL.greenleaves.id>,0\n        S:logs=<ExtrabiomesXL.customlog.id>,0; <ExtrabiomesXL.quarterlog0.id>,1; <ExtrabiomesXL.quarterlog1.id>,1; <ExtrabiomesXL.quarterlog2.id>,1; <ExtrabiomesXL.quarterlog3.id>,1\n    }\n\n    ebxl_redwoods {\n        S:leaves=<ExtrabiomesXL.greenleaves.id>,1\n        S:logs=<ExtrabiomesXL.quarterlog0.id>,0; <ExtrabiomesXL.quarterlog1.id>,0; <ExtrabiomesXL.quarterlog2.id>,0; <ExtrabiomesXL.quarterlog3.id>,0\n    }");
        if (!config.hasCategory(THIRD_PARTY_CFG_CTGY)) {
            for (String key : TreeCapitator.thirdPartyConfig.keySet()) {
                HashMap tpconfig = (HashMap)TreeCapitator.thirdPartyConfig.get(key);
                for (String entry : tpconfig.keySet()) {
                    config.get("1_third_party_configs." + key, entry, (String)tpconfig.get(entry));
                }
            }
        } else {
            TreeCapitator.thirdPartyConfig = new HashMap();
            for (String ctgy : config.getCategoryNames()) {
                if (ctgy.indexOf("1_third_party_configs.") == -1) continue;
                HashMap<String, String> entries = new HashMap<String, String>();
                ConfigCategory currentCtgy = config.getCategory(ctgy);
                if (currentCtgy.containsKey("modName")) {
                    Config.renameProperty((Configuration)config, (String)ctgy, (String)"modName", (String)"modID");
                }
                if (!currentCtgy.containsKey("modID")) continue;
                for (String tpCfgEntry : currentCtgy.keySet()) {
                    entries.put(tpCfgEntry, currentCtgy.get(tpCfgEntry).getString());
                }
                if (entries.containsKey("itemValues") && !entries.containsKey("useShiftedItemID")) {
                    entries.put("useShiftedItemID", "true");
                }
                TreeCapitator.thirdPartyConfig.put(ctgy, entries);
            }
        }
        TreeCapitator.localBlockIDList = TreeCapitator.getStringFromConfigBlockList();
        config.get(BLOCK_CTGY, "localTreeConfig", "", "Automatically generated:").set(TreeCapitator.localBlockIDList);
        config.addCustomCategoryComment(THIRD_PARTY_CFG_CTGY, "Third-Party config entries tell TreeCapitator how to find the block IDs from\nother mods' config files.  These values are case-sensitive!\n\nFormat:\n    <section_name> {\n        S:modID=<modID from mcmod.info>\n        S:configPath=<path to config file relative to .minecraft/config/>\n        S:blockValues=<block config section>:<config property name>; <mod config section>:<config property name>\n        S:itemValues=<item config section>:<property name>; <item config section>:<property name>\n        B:useShiftedItemID=<whether or not to use the +256 shifted item ID> (true/false)\n    }\n\nExample:\n    extrabiomesxl {\n        S:modID=ExtrabiomesXL\n        S:configPath=extrabiomes/extrabiomes.cfg\n        S:blockValues=block:customlog.id; block:quarterlog0.id; block:quarterlog1.id; block:quarterlog2.id; block:quarterlog3.id; block:autumnleaves.id; block:greenleaves.id\n        S:itemValues=items.world:axeRuby.id; items.world:axeGreenSapphire.id; items.world:axeSapphire.id\n        B:useShiftedItemID=true\n    }\n\nOnce your third-party config entries are setup, you can use replacement\ntags in your tree, axe, and shears ID configs.  Replacement tags are structured like this:\n<ModName.ConfigPropName>");
        config.save();
        if (bspkrsCoreProxy.instance.allowUpdateCheck) {
            versionChecker = new ModVersionChecker(TreeCapitatorMod.metadata.name, TreeCapitatorMod.metadata.version, "http://bspk.rs/Minecraft/1.5.1/treeCapitatorForge.version", "http://www.minecraftforum.net/topic/1009577-", TCLog.INSTANCE.getLogger());
            versionChecker.checkVersionWithLoggingBySubStringAsFloat(TreeCapitatorMod.metadata.version.length() - 1, TreeCapitatorMod.metadata.version.length());
        }
    }

    @Mod.Init
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new PlayerHandler());
        proxy.onLoad();
    }

    @Mod.IMCCallback
    public void processIMCMessages(FMLInterModComms.IMCEvent event) {
    }

    @Mod.PostInit
    public void postInit(FMLPostInitializationEvent event) {
        TreeCapitatorMod.getReplacementTagListFromThirdPartyConfigs();
        TreeCapitator.localBlockIDList = TreeCapitator.replaceThirdPartyBlockTags(TreeCapitator.localBlockIDList);
        TreeCapitator.axeIDList = TreeCapitator.replaceThirdPartyBlockTags(TreeCapitator.axeIDList);
        TreeCapitator.shearIDList = TreeCapitator.replaceThirdPartyBlockTags(TreeCapitator.shearIDList);
    }

    @Mod.ServerStarted
    public void serverStarted(FMLServerStartedEvent event) {
        new TreeCapitatorServer();
        TreeCapitator.parseConfigBlockList(TreeCapitator.localBlockIDList);
    }

    public void onBlockHarvested(aab world, int x, int y, int z, apa block, int metadata, sq entityPlayer) {
        Coord blockPos;
        BlockID blockID;
        if (proxy.isEnabled() && TreeCapitator.isLogBlock(blockID = new BlockID(block, metadata)) && !TreeCapitator.blocksBeingChopped.contains(blockPos = new Coord(x, y, z))) {
            proxy.debugString("BlockID " + blockID + " is a log.");
            if (TreeBlockBreaker.isBreakingPossible(world, entityPlayer)) {
                TreeCapitator.blocksBeingChopped.add(blockPos);
                blockID = (BlockID)TreeCapitator.logIDList.get(TreeCapitator.logIDList.indexOf(blockID));
                TreeBlockBreaker breaker = TreeCapitator.useStrictBlockPairing ? new TreeBlockBreaker(entityPlayer, (ArrayList)TreeCapitator.logToLogListMap.get(blockID), (ArrayList)TreeCapitator.logToLeafListMap.get(blockID)) : new TreeBlockBreaker(entityPlayer, TreeCapitator.logIDList, TreeCapitator.leafIDList);
                breaker.onBlockHarvested(world, x, y, z, metadata, entityPlayer);
                TreeCapitator.blocksBeingChopped.remove(blockPos);
            }
        }
    }

    public static boolean isItemInWorldManagerReplaced(jc player) {
        return !player.c.getClass().getSimpleName().equals(jd.class.getSimpleName());
    }

    public static void getReplacementTagListFromThirdPartyConfigs() {
        TCLog.info("Getting Block ID Lists from 3rd party mod configs...", new Object[0]);
        IDResolverMappingList idrMappings = new IDResolverMappingList();
        if (Loader.isModLoaded((String)idResolverModID)) {
            TCLog.info("ID Resolver has been detected.  Processing ID config...", new Object[0]);
            Properties idrKnownIDs = null;
            try {
                idrKnownIDs = (Properties)ObfuscationReflectionHelper.getPrivateValue(IDResolverBasic.class, null, (String[])new String[]{"knownIDs"});
            }
            catch (Throwable e) {
                TreeCapitator.debugString("Error getting knownIDs from ID Resolver: %s", e.getMessage());
                e.printStackTrace();
            }
            if (idrKnownIDs != null) {
                for (String key : idrKnownIDs.stringPropertyNames()) {
                    String value = idrKnownIDs.getProperty(key);
                    try {
                        if (!key.startsWith("ItemID.") && !key.startsWith("BlockID.")) continue;
                        IDResolverMapping mapping = new IDResolverMapping(key + "=" + value);
                        if (mapping.oldID != 0 && mapping.newID != 0 && !mapping.isStaticMapping()) {
                            idrMappings.add(mapping);
                            TreeCapitator.debugString("Adding entry: %s", key + "=" + value);
                            continue;
                        }
                        TreeCapitator.debugString("Ignoring entry: %s", key + "=" + value);
                    }
                    catch (Throwable e) {
                        TCLog.severe("Exception caught for line: %s", key + "=" + value);
                    }
                }
            }
        } else {
            TCLog.info("ID Resolver (Mod ID \"%s\") is not loaded.", idResolverModID);
        }
        TreeCapitator.tagMap = new HashMap();
        for (String key : TreeCapitator.thirdPartyConfig.keySet()) {
            TreeCapitator.debugString("Processing key " + key, new Object[0]);
            HashMap tpCfgKey = (HashMap)TreeCapitator.thirdPartyConfig.get(key);
            if (Loader.isModLoaded((String)((String)tpCfgKey.get("modID")))) {
                File file = new File(loader.getConfigDir(), ((String)tpCfgKey.get("configPath")).trim());
                if (file.exists()) {
                    Configuration thirdPartyConfig = new Configuration(file);
                    String idrClassName = ((ModContainer)loader.getIndexedModList().get(tpCfgKey.get("modID"))).getMod().getClass().getName();
                    thirdPartyConfig.load();
                    boolean useShiftedIndex = true;
                    if (tpCfgKey.containsKey("useShiftedItemID")) {
                        useShiftedIndex = Boolean.valueOf((String)tpCfgKey.get("useShiftedItemID"));
                    }
                    for (String prop : tpCfgKey.keySet()) {
                        if (prop.equals("modID") || prop.equals("configPath") || prop.equals("useShiftedItemID")) continue;
                        TreeCapitator.debugString("Getting tags from %s...", prop);
                        for (String configID : ((String)tpCfgKey.get(prop)).trim().split(";")) {
                            String[] subString = configID.trim().split(":");
                            String configValue = thirdPartyConfig.get(subString[0].trim(), subString[1].trim(), 0).getString();
                            String tagID = "<" + (String)tpCfgKey.get("modID") + "." + subString[1].trim() + ">";
                            if (!TreeCapitator.tagMap.containsKey(tagID)) {
                                IDResolverMapping mapping = idrMappings.getMappingForModAndOldID(idrClassName, CommonUtils.parseInt((String)configValue));
                                if (mapping != null) {
                                    configValue = String.valueOf(mapping.newID);
                                }
                                if (prop.equals("itemValues") && useShiftedIndex) {
                                    configValue = String.valueOf(CommonUtils.parseInt((String)configValue, (int)-256) + 256);
                                }
                                if (configValue.equals("0")) continue;
                                TreeCapitator.tagMap.put(tagID, configValue);
                                TreeCapitator.debugString("Third Party Config Tag " + tagID + " will map to " + configValue, new Object[0]);
                                continue;
                            }
                            TCLog.warning("Duplicate Third Party Config Tag detected: " + tagID + " is already mapped to " + (String)TreeCapitator.tagMap.get(tagID), new Object[0]);
                        }
                    }
                    continue;
                }
                TCLog.warning("Mod config file %s does not exist when processing config key %s.", tpCfgKey.get("configPath"), key);
                continue;
            }
            TreeCapitator.debugString("Mod " + (String)tpCfgKey.get("modID") + " is not loaded.", new Object[0]);
        }
    }

    static {
        isCoreModLoaded = false;
        idResolverModIDDesc = "The mod ID value for ID Resolver.";
        idResolverModID = "IDResolver";
        idResolverConfigPathDesc = "The path to the ID Resolver known IDs config file reletive to .minecraft/config/.";
        idResolverConfigPath = "IDResolverknownIDs.properties";
    }
}

