/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab.flag;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.DimensionManager;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.flag.FlagBase;
import universalelectricity.prefab.flag.FlagWorld;

public class ModFlag
extends FlagBase {
    private final List flagWorlds = new ArrayList();

    public ModFlag(bq nbt) {
        this.readFromNBT(nbt);
    }

    @Override
    public void readFromNBT(bq nbt) {
        for (bq dimensionCompound : nbt.c()) {
            try {
                int dimensionID = Integer.parseInt(dimensionCompound.e().replace("dim_", ""));
                in world = DimensionManager.getWorld((int)dimensionID);
                FlagWorld flagWorld = new FlagWorld((yc)world);
                flagWorld.readFromNBT(dimensionCompound);
                this.flagWorlds.add(flagWorld);
            }
            catch (Exception e) {
                System.out.println("Mod Flag: Failed to read dimension data: " + dimensionCompound.e());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void writeToNBT(bq nbt) {
        for (FlagWorld worldData : this.flagWorlds) {
            try {
                nbt.a("dim_" + worldData.world.u.h, (cd)worldData.getNBT());
            }
            catch (Exception e) {
                System.out.println("Mod Flag: Failed to save world flag data: " + worldData.world);
                e.printStackTrace();
            }
        }
    }

    public FlagWorld getFlagWorld(yc world) {
        FlagWorld worldData = null;
        for (FlagWorld data : this.flagWorlds) {
            if (data.world.u.h != world.u.h) continue;
            worldData = data;
            break;
        }
        if (worldData == null) {
            worldData = new FlagWorld(world);
            this.flagWorlds.add(worldData);
        }
        return worldData;
    }

    public boolean containsValue(yc world, String flagName, String checkValue, Vector3 position) {
        return this.getFlagWorld(world).containsValue(flagName, checkValue, position);
    }

    public List getFlagWorlds() {
        return this.flagWorlds;
    }
}

