/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.vector;

import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.electricity.ElectricityConnections;
import universalelectricity.core.vector.Vector2;

public class Vector3
extends Vector2
implements Cloneable {
    public double z;

    public Vector3() {
        this(0, 0, 0);
    }

    public Vector3(int x, int y2, int z) {
        this.x = x;
        this.y = y2;
        this.z = z;
    }

    public Vector3(double x, double y2, double z) {
        this.x = x;
        this.y = y2;
        this.z = z;
    }

    public Vector3(lq par1) {
        this.x = par1.t;
        this.y = par1.u;
        this.z = par1.v;
    }

    public Vector3(any par1) {
        this.x = par1.l;
        this.y = par1.m;
        this.z = par1.n;
    }

    public Vector3(aoj par1) {
        this.x = par1.c;
        this.y = par1.d;
        this.z = par1.e;
    }

    public Vector3(aoh par1) {
        this.x = par1.b;
        this.y = par1.c;
        this.z = par1.d;
    }

    public Vector3(s par1) {
        this.x = par1.a;
        this.y = par1.b;
        this.z = par1.c;
    }

    @Override
    public int intX() {
        return (int)Math.floor(this.x);
    }

    @Override
    public int intY() {
        return (int)Math.floor(this.y);
    }

    public int intZ() {
        return (int)Math.floor(this.z);
    }

    public boolean isEquals(Vector3 vector) {
        return this.x == vector.x && this.y == vector.y && this.z == vector.z;
    }

    @Override
    public Vector3 clone() {
        return new Vector3(this.x, this.y, this.z);
    }

    public int getBlockID(ym world) {
        return world.a(this.intX(), this.intY(), this.intZ());
    }

    public int getBlockMetadata(ym world) {
        return world.h(this.intX(), this.intY(), this.intZ());
    }

    public any getTileEntity(ym world) {
        return world.q(this.intX(), this.intY(), this.intZ());
    }

    public void setBlock(yc world, int id, int metadata) {
        world.c(this.intX(), this.intY(), this.intZ(), id, metadata);
    }

    public void setBlock(yc world, int id) {
        world.b(this.intX(), this.intY(), this.intZ(), id);
    }

    public void setBlockWithNotify(yc world, int id, int metadata) {
        world.d(this.intX(), this.intY(), this.intZ(), id, metadata);
    }

    public void setBlockWithNotify(yc world, int id) {
        world.e(this.intX(), this.intY(), this.intZ(), id);
    }

    public Vector2 toVector2() {
        return new Vector2(this.x, this.z);
    }

    public aoj toVec3() {
        return aoj.a((double)this.x, (double)this.y, (double)this.z);
    }

    public boolean isEqual(Vector3 vector3) {
        return this.x == vector3.x && this.y == vector3.y && this.z == vector3.z;
    }

    public static double distance(Vector3 par1, Vector3 par2) {
        double var2 = par1.x - par2.x;
        double var4 = par1.y - par2.y;
        double var6 = par1.z - par2.z;
        return ke.a((double)(var2 * var2 + var4 * var4 + var6 * var6));
    }

    public double distanceTo(Vector3 vector3) {
        double var2 = vector3.x - this.x;
        double var4 = vector3.y - this.y;
        double var6 = vector3.z - this.z;
        return ke.a((double)(var2 * var2 + var4 * var4 + var6 * var6));
    }

    public static Vector3 subtract(Vector3 par1, Vector3 par2) {
        return new Vector3(par1.x - par2.x, par1.y - par2.y, par1.z - par2.z);
    }

    public static Vector3 add(Vector3 par1, Vector3 par2) {
        return new Vector3(par1.x + par2.x, par1.y + par2.y, par1.z + par2.z);
    }

    public static Vector3 add(Vector3 par1, double par2) {
        return new Vector3(par1.x + par2, par1.y + par2, par1.z + par2);
    }

    public void add(Vector3 par1) {
        this.x += par1.x;
        this.y += par1.y;
        this.z += par1.z;
    }

    @Override
    public void add(double par1) {
        this.x += par1;
        this.y += par1;
        this.z += par1;
    }

    public void subtract(Vector3 amount) {
        this.x -= amount.x;
        this.y -= amount.y;
        this.z -= amount.z;
    }

    public void multiply(double amount) {
        this.x *= amount;
        this.y *= amount;
        this.z *= amount;
    }

    public void multiply(Vector3 vec) {
        this.x *= vec.x;
        this.y *= vec.y;
        this.z *= vec.z;
    }

    public static Vector3 multiply(Vector3 vec1, Vector3 vec2) {
        return new Vector3(vec1.x * vec2.x, vec1.y * vec2.y, vec1.z * vec2.z);
    }

    public static Vector3 multiply(Vector3 vec1, double vec2) {
        return new Vector3(vec1.x * vec2, vec1.y * vec2, vec1.z * vec2);
    }

    public static Vector3 readFromNBT(String prefix, bq par1NBTTagCompound) {
        Vector3 tempVector = new Vector3();
        tempVector.x = par1NBTTagCompound.h(prefix + "X");
        tempVector.y = par1NBTTagCompound.h(prefix + "Y");
        tempVector.z = par1NBTTagCompound.h(prefix + "Z");
        return tempVector;
    }

    public void writeToNBT(String prefix, bq par1NBTTagCompound) {
        par1NBTTagCompound.a(prefix + "X", this.x);
        par1NBTTagCompound.a(prefix + "Y", this.y);
        par1NBTTagCompound.a(prefix + "Z", this.z);
    }

    @Override
    public Vector3 round() {
        return new Vector3(Math.round(this.x), Math.round(this.y), Math.round(this.z));
    }

    @Override
    public Vector3 floor() {
        return new Vector3(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
    }

    public List getEntitiesWithin(yc worldObj, Class par1Class) {
        return worldObj.a(par1Class, aoe.a((double)this.intX(), (double)this.intY(), (double)this.intZ(), (double)(this.intX() + 1), (double)(this.intY() + 1), (double)(this.intZ() + 1)));
    }

    public void modifyPositionFromSide(ForgeDirection side, double amount) {
        switch (side.ordinal()) {
            case 0: {
                this.y -= amount;
                break;
            }
            case 1: {
                this.y += amount;
                break;
            }
            case 2: {
                this.z -= amount;
                break;
            }
            case 3: {
                this.z += amount;
                break;
            }
            case 4: {
                this.x -= amount;
                break;
            }
            case 5: {
                this.x += amount;
            }
        }
    }

    public void modifyPositionFromSide(ForgeDirection side) {
        this.modifyPositionFromSide(side, 1.0);
    }

    public static any getTileEntityFromSide(yc world, Vector3 position, ForgeDirection side) {
        position.modifyPositionFromSide(side);
        return world.q(position.intX(), position.intY(), position.intZ());
    }

    public static any getConnectorFromSide(yc world, Vector3 position, ForgeDirection side) {
        any tileEntity = Vector3.getTileEntityFromSide(world, position, side);
        if (ElectricityConnections.isConnector(tileEntity) && ElectricityConnections.canConnect(tileEntity, Vector3.getOrientationFromSide(side, ForgeDirection.NORTH))) {
            return tileEntity;
        }
        return null;
    }

    public static ForgeDirection getOrientationFromSide(ForgeDirection front, ForgeDirection side) {
        switch (front.ordinal()) {
            case 0: {
                switch (side.ordinal()) {
                    case 0: {
                        return ForgeDirection.getOrientation((int)3);
                    }
                    case 1: {
                        return ForgeDirection.getOrientation((int)2);
                    }
                    case 2: {
                        return ForgeDirection.getOrientation((int)1);
                    }
                    case 3: {
                        return ForgeDirection.getOrientation((int)0);
                    }
                    case 4: {
                        return ForgeDirection.getOrientation((int)5);
                    }
                    case 5: {
                        return ForgeDirection.getOrientation((int)4);
                    }
                }
            }
            case 1: {
                switch (side.ordinal()) {
                    case 0: {
                        return ForgeDirection.getOrientation((int)4);
                    }
                    case 1: {
                        return ForgeDirection.getOrientation((int)5);
                    }
                    case 2: {
                        return ForgeDirection.getOrientation((int)0);
                    }
                    case 3: {
                        return ForgeDirection.getOrientation((int)1);
                    }
                    case 4: {
                        return ForgeDirection.getOrientation((int)2);
                    }
                    case 5: {
                        return ForgeDirection.getOrientation((int)3);
                    }
                }
            }
            case 2: {
                switch (side.ordinal()) {
                    case 0: {
                        return ForgeDirection.getOrientation((int)0);
                    }
                    case 1: {
                        return ForgeDirection.getOrientation((int)1);
                    }
                    case 2: {
                        return ForgeDirection.getOrientation((int)3);
                    }
                    case 3: {
                        return ForgeDirection.getOrientation((int)2);
                    }
                    case 4: {
                        return ForgeDirection.getOrientation((int)5);
                    }
                    case 5: {
                        return ForgeDirection.getOrientation((int)4);
                    }
                }
            }
            case 3: {
                return side;
            }
            case 4: {
                switch (side.ordinal()) {
                    case 0: {
                        return ForgeDirection.getOrientation((int)0);
                    }
                    case 1: {
                        return ForgeDirection.getOrientation((int)1);
                    }
                    case 2: {
                        return ForgeDirection.getOrientation((int)5);
                    }
                    case 3: {
                        return ForgeDirection.getOrientation((int)4);
                    }
                    case 4: {
                        return ForgeDirection.getOrientation((int)3);
                    }
                    case 5: {
                        return ForgeDirection.getOrientation((int)2);
                    }
                }
            }
            case 5: {
                switch (side.ordinal()) {
                    case 0: {
                        return ForgeDirection.getOrientation((int)0);
                    }
                    case 1: {
                        return ForgeDirection.getOrientation((int)1);
                    }
                    case 2: {
                        return ForgeDirection.getOrientation((int)4);
                    }
                    case 3: {
                        return ForgeDirection.getOrientation((int)5);
                    }
                    case 4: {
                        return ForgeDirection.getOrientation((int)2);
                    }
                    case 5: {
                        return ForgeDirection.getOrientation((int)3);
                    }
                }
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    @Override
    public String toString() {
        return "Vector3 [" + this.x + "," + this.y + "," + this.z + "]";
    }
}

