/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.research;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import thaumcraft.api.ObjectTags;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.research.ResearchList;

public class ResearchItem {
    public final String key;
    public String name;
    public String popupText;
    public String longText;
    public final ObjectTags tags;
    public ResearchItem[] parents = null;
    public ResearchItem[] parentsHidden = null;
    public ResearchItem[] siblings = null;
    public final int displayColumn;
    public final int displayRow;
    public final ur itemStack;
    public final int iconIndex;
    private boolean isSpecial;
    private boolean isStub;
    private boolean isAlternate;
    private boolean isHidden;
    private boolean isLost;
    private boolean isAutoUnlock;

    public ResearchItem(String par1, ObjectTags tags, int par3, int par4, int icon) {
        this(par1, tags, par3, par4, null, icon);
    }

    public ResearchItem(String par1, ObjectTags tags, int par3, int par4, ur par5Item) {
        this(par1, tags, par3, par4, par5Item, -1);
    }

    public ResearchItem(String par1, ObjectTags tags, int par3, int par4, up par5Item) {
        this(par1, tags, par3, par4, new ur(par5Item), -1);
    }

    public ResearchItem(String par1, ObjectTags tags, int par3, int par4, amq par5Block) {
        this(par1, tags, par3, par4, new ur(par5Block), -1);
    }

    public ResearchItem(String par1, ObjectTags tags, int par3, int par4, ur par5ItemStack, int icon) {
        this.key = par1;
        this.tags = tags;
        this.name = "";
        this.longText = "";
        this.popupText = "";
        Element el = ThaumcraftApi.researchDoc.getElementById(this.key);
        if (el != null) {
            NodeList children = el.getChildNodes();
            for (int a = 0; a < children.getLength(); ++a) {
                if (children.item(a).getNodeName().equals("name")) {
                    this.name = children.item(a).getTextContent();
                    continue;
                }
                if (children.item(a).getNodeName().equals("longText")) {
                    this.longText = children.item(a).getTextContent();
                    continue;
                }
                if (!children.item(a).getNodeName().equals("popupText")) continue;
                this.popupText = children.item(a).getTextContent();
            }
        }
        this.itemStack = par5ItemStack;
        this.iconIndex = icon;
        this.displayColumn = par3;
        this.displayRow = par4;
        if (par3 < ResearchList.minDisplayColumn) {
            ResearchList.minDisplayColumn = par3;
        }
        if (par4 < ResearchList.minDisplayRow) {
            ResearchList.minDisplayRow = par4;
        }
        if (par3 > ResearchList.maxDisplayColumn) {
            ResearchList.maxDisplayColumn = par3;
        }
        if (par4 > ResearchList.maxDisplayRow) {
            ResearchList.maxDisplayRow = par4;
        }
    }

    public ResearchItem setSpecial() {
        this.isSpecial = true;
        return this;
    }

    public ResearchItem setStub() {
        this.isStub = true;
        return this;
    }

    public ResearchItem setAlternate() {
        this.isAlternate = true;
        return this;
    }

    public ResearchItem setHidden() {
        this.isHidden = true;
        return this;
    }

    public ResearchItem setLost() {
        this.isLost = true;
        return this;
    }

    public ResearchItem setParents(ResearchItem ... par) {
        this.parents = par;
        return this;
    }

    public ResearchItem setParentsHidden(ResearchItem ... par) {
        this.parentsHidden = par;
        return this;
    }

    public ResearchItem setSiblings(ResearchItem ... sib) {
        this.siblings = sib;
        return this;
    }

    public ResearchItem registerResearchItem() {
        ResearchList.research.put(this.key, this);
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public String getName() {
        return this.name;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean getSpecial() {
        return this.isSpecial;
    }

    public boolean getStub() {
        return this.isStub;
    }

    public boolean getAlternate() {
        return this.isAlternate;
    }

    public boolean getHidden() {
        return this.isHidden;
    }

    public boolean getLost() {
        return this.isLost;
    }

    public boolean getAutoUnlock() {
        return this.isAutoUnlock;
    }

    public ResearchItem setAutoUnlock() {
        this.isAutoUnlock = true;
        return this;
    }
}

