/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import thaumcraft.api.EnumTag;
import thaumcraft.api.ThaumcraftApiHelper;

public class ObjectTags
implements Serializable {
    public Map tags = new HashMap();

    public ObjectTags(int id, int meta) {
        ObjectTags temp = ThaumcraftApiHelper.getObjectTags(new ur(id, 1, meta));
        for (EnumTag tag : temp.getAspects()) {
            this.add(tag, temp.getAmount(tag));
        }
    }

    public ObjectTags() {
    }

    public int size() {
        return this.tags.size();
    }

    public EnumTag[] getAspects() {
        EnumTag[] q = new EnumTag[1];
        return this.tags.keySet().toArray(q);
    }

    public EnumTag[] getAspectsSorted() {
        EnumTag[] out = this.tags.keySet().toArray(new EnumTag[1]);
        boolean change = false;
        block0: do {
            change = false;
            for (int a = 0; a < out.length - 1; ++a) {
                EnumTag e1 = out[a];
                EnumTag e2 = out[a + 1];
                if (e1 == null || e2 == null || e1.name.compareTo(e2.name) <= 0) continue;
                out[a] = e2;
                out[a + 1] = e1;
                change = true;
                continue block0;
            }
        } while (change);
        return out;
    }

    public int getAmount(EnumTag key) {
        return this.tags.get((Object)key) == null ? 0 : (Integer)this.tags.get((Object)key);
    }

    public boolean reduceAmount(EnumTag key, int amount) {
        if (this.getAmount(key) >= amount) {
            int am = this.getAmount(key) - amount;
            if (am <= 0) {
                this.tags.remove((Object)key);
            } else {
                this.tags.put(key, am);
            }
            return true;
        }
        return false;
    }

    public ObjectTags remove(EnumTag key, int amount) {
        if (this.getAmount(key) >= amount) {
            int am = this.getAmount(key) - amount;
            if (am <= 0) {
                this.tags.remove((Object)key);
            } else {
                this.tags.put(key, am);
            }
        } else if (this.getAmount(key) == 0) {
            this.tags.put(key, -amount);
        }
        return this;
    }

    public ObjectTags add(EnumTag aspect, int amount) {
        if (this.tags.containsKey((Object)aspect)) {
            int oldamount = (Integer)this.tags.get((Object)aspect);
            amount += oldamount;
        }
        this.tags.put(aspect, amount);
        return this;
    }

    public ObjectTags merge(EnumTag aspect, int amount) {
        int oldamount;
        if (this.tags.containsKey((Object)aspect) && amount < (oldamount = ((Integer)this.tags.get((Object)aspect)).intValue())) {
            amount = oldamount;
        }
        this.tags.put(aspect, amount);
        return this;
    }
}

