/*
 * Decompiled with CFR 0.152.
 */
package mekanism.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.Map;
import java.util.Set;
import mekanism.api.InfusionInput;
import mekanism.api.InfusionOutput;
import mekanism.api.InfusionType;
import mekanism.client.GuiMetallurgicInfuser;
import mekanism.common.Mekanism;
import mekanism.common.MekanismUtils;
import mekanism.common.RecipeHandler;
import mekanism.generators.common.MekanismGenerators;
import org.lwjgl.opengl.GL11;

public class MetallurgicInfuserRecipeHandler
extends TemplateRecipeHandler {
    int ticksPassed;

    public String getRecipeName() {
        return "Metallurgic Infuser";
    }

    public String getOverlayIdentifier() {
        return "infuser";
    }

    public String getGuiTexture() {
        return "/resources/mekanism/gui/GuiMetallurgicInfuser.png";
    }

    public Class getGuiClass() {
        return GuiMetallurgicInfuser.class;
    }

    public String getRecipeId() {
        return "mekanism.infuser";
    }

    public int getInfuseX(InfusionType type) {
        switch (type) {
            case COAL: {
                return 4;
            }
            case TIN: {
                return 0;
            }
            case DIAMOND: {
                return 4;
            }
            case BIO: {
                return 8;
            }
        }
        return 0;
    }

    public int getInfuseY(InfusionType type) {
        switch (type) {
            case COAL: {
                return 0;
            }
            case TIN: {
                return 52;
            }
            case DIAMOND: {
                return 52;
            }
            case BIO: {
                return 0;
            }
        }
        return 0;
    }

    public InfusionType getFromFuel(ur itemStack) {
        if (MekanismUtils.getInfuseObject(itemStack) != null) {
            return MekanismUtils.getInfuseObject((ur)itemStack).type;
        }
        return null;
    }

    public ur getInfuseStack(InfusionType type) {
        switch (type) {
            case COAL: {
                return new ur(Mekanism.CompressedCarbon);
            }
            case TIN: {
                return new ur(Mekanism.Dust, 1, 7);
            }
            case DIAMOND: {
                return new ur(Mekanism.Dust, 1, 4);
            }
            case BIO: {
                try {
                    return new ur(MekanismGenerators.BioFuel);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public Set getRecipes() {
        return RecipeHandler.Recipe.METALLURGIC_INFUSER.get().entrySet();
    }

    public void drawBackground(GuiContainerManager guimanager, int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guimanager.bindTextureByName(this.getGuiTexture());
        guimanager.drawTexturedModalRect(0, 0, 5, 15, 166, 56);
    }

    public void drawExtras(GuiContainerManager guimanager, int i) {
        float f = this.ticksPassed >= 40 ? (float)((this.ticksPassed - 40) % 20) / 20.0f : 0.0f;
        this.drawProgressBar(guimanager, 67, 32, 202, 104, 32, 8, f, 0);
        float f2 = f = this.ticksPassed >= 20 && this.ticksPassed < 40 ? (float)((this.ticksPassed - 20) % 20) / 20.0f : 1.0f;
        if (this.ticksPassed < 20) {
            f = 0.0f;
        }
        int infuseX = 202 + this.getInfuseX(this.getFromFuel(((PositionedStack)this.getOtherStacks((int)i).get((int)0)).item));
        int infuseY = this.getInfuseY(this.getFromFuel(((PositionedStack)this.getOtherStacks((int)i).get((int)0)).item));
        this.drawProgressBar(guimanager, 2, 2, infuseX, infuseY, 4, 52, f, 3);
        f = this.ticksPassed <= 20 ? (float)this.ticksPassed / 20.0f : 1.0f;
        this.drawProgressBar(guimanager, 160, 2, 202, 0, 4, 52, f, 3);
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticksPassed;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(67, 32, 32, 8), this.getRecipeId(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry irecipe : this.getRecipes()) {
                this.arecipes.add(new CachedIORecipe(irecipe, this.getInfuseStack(((InfusionInput)irecipe.getKey()).infusionType)));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public int recipiesPerPage() {
        return 2;
    }

    public void loadCraftingRecipes(ur result) {
        for (Map.Entry irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ur)((InfusionOutput)irecipe.getValue()).resource, (ur)result)) continue;
            this.arecipes.add(new CachedIORecipe(irecipe, this.getInfuseStack(((InfusionInput)irecipe.getKey()).infusionType)));
        }
    }

    public void loadUsageRecipes(ur ingredient) {
        for (Map.Entry irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ur)((InfusionInput)irecipe.getKey()).inputSlot, (ur)ingredient)) continue;
            this.arecipes.add(new CachedIORecipe(irecipe, this.getInfuseStack(((InfusionInput)irecipe.getKey()).infusionType)));
        }
    }

    public class CachedIORecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public PositionedStack inputStack;
        public PositionedStack outputStack;
        public PositionedStack infuseStack;

        public PositionedStack getIngredient() {
            return this.inputStack;
        }

        public PositionedStack getResult() {
            return this.outputStack;
        }

        public PositionedStack getOtherStack() {
            return this.infuseStack;
        }

        public CachedIORecipe(ur input, ur output, ur infuse) {
            super((TemplateRecipeHandler)MetallurgicInfuserRecipeHandler.this);
            this.inputStack = new PositionedStack((Object)input, 46, 28);
            this.outputStack = new PositionedStack((Object)output, 104, 28);
            this.infuseStack = new PositionedStack((Object)infuse, 12, 20);
        }

        public CachedIORecipe(Map.Entry recipe, ur infuse) {
            this(((InfusionInput)recipe.getKey()).inputSlot, ((InfusionOutput)recipe.getValue()).resource, infuse);
        }
    }
}

