/*
 * Decompiled with CFR 0.152.
 */
package mekanism.nei;

import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.forge.GuiContainerManager;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.Map;
import java.util.Set;
import org.lwjgl.opengl.GL11;

public abstract class AdvancedMachineRecipeHandler
extends TemplateRecipeHandler {
    int ticksPassed;

    public abstract String getRecipeId();

    public abstract ur getFuelStack();

    public abstract Set getRecipes();

    public void drawBackground(GuiContainerManager guimanager, int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guimanager.bindTextureByName(this.getGuiTexture());
        guimanager.drawTexturedModalRect(12, 0, 28, 5, 144, 68);
    }

    public void drawExtras(GuiContainerManager guimanager, int i) {
        float f = this.ticksPassed >= 40 ? (float)((this.ticksPassed - 40) % 20) / 20.0f : 0.0f;
        this.drawProgressBar(guimanager, 63, 34, 202, 0, 24, 7, f, 0);
        float f2 = f = this.ticksPassed >= 20 && this.ticksPassed < 40 ? (float)((this.ticksPassed - 20) % 20) / 20.0f : 1.0f;
        if (this.ticksPassed < 20) {
            f = 0.0f;
        }
        this.drawProgressBar(guimanager, 45, 32, 202, 7, 5, 12, f, 3);
        f = this.ticksPassed <= 20 ? (float)this.ticksPassed / 20.0f : 1.0f;
        this.drawProgressBar(guimanager, 149, 12, 202, 19, 4, 52, f, 3);
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticksPassed;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(63, 34, 24, 7), this.getRecipeId(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry irecipe : this.getRecipes()) {
                this.arecipes.add(new CachedIORecipe(irecipe, this.getFuelStack()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ur result) {
        for (Map.Entry irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ur)((ur)irecipe.getValue()), (ur)result)) continue;
            this.arecipes.add(new CachedIORecipe(irecipe, this.getFuelStack()));
        }
    }

    public void loadUsageRecipes(ur ingredient) {
        for (Map.Entry irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ur)((ur)irecipe.getKey()), (ur)ingredient)) continue;
            this.arecipes.add(new CachedIORecipe(irecipe, this.getFuelStack()));
        }
    }

    public class CachedIORecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public PositionedStack inputStack;
        public PositionedStack outputStack;
        public PositionedStack fuelStack;

        public PositionedStack getIngredient() {
            return this.inputStack;
        }

        public PositionedStack getResult() {
            return this.outputStack;
        }

        public PositionedStack getOtherStack() {
            return this.fuelStack;
        }

        public CachedIORecipe(ur input, ur output, ur fuel) {
            super((TemplateRecipeHandler)AdvancedMachineRecipeHandler.this);
            this.inputStack = new PositionedStack((Object)input, 40, 12);
            this.outputStack = new PositionedStack((Object)output, 100, 30);
            this.fuelStack = new PositionedStack((Object)fuel, 40, 48);
        }

        public CachedIORecipe(Map.Entry recipe, ur fuel) {
            this((ur)recipe.getKey(), (ur)recipe.getValue(), fuel);
        }
    }
}

