/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import com.google.common.io.ByteArrayDataInput;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import ic2.api.Direction;
import ic2.api.ElectricItem;
import ic2.api.IElectricItem;
import ic2.api.energy.tile.IEnergySink;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.Teleporter;
import mekanism.common.TileEntityElectricBlock;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.electricity.ElectricityConnections;
import universalelectricity.core.implement.IConductor;
import universalelectricity.core.implement.IItemElectric;
import universalelectricity.core.implement.IJouleStorage;
import universalelectricity.core.implement.IVoltage;
import universalelectricity.core.vector.Vector3;

public class TileEntityTeleporter
extends TileEntityElectricBlock
implements IEnergySink,
IJouleStorage,
IVoltage,
IPeripheral {
    public Teleporter.Code code;
    public String status = (Object)((Object)EnumColor.DARK_RED) + "Not ready.";

    public TileEntityTeleporter() {
        super("Teleporter", 1.0E7);
        this.inventory = new ur[1];
        this.code = new Teleporter.Code(0, 0, 0, 0);
        ElectricityConnections.registerConnector(this, EnumSet.allOf(ForgeDirection.class));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.k.I) {
            if (Mekanism.teleporters.containsKey(this.code)) {
                if (!((ArrayList)Mekanism.teleporters.get(this.code)).contains(Teleporter.Coords.get(this)) && this.hasFrame()) {
                    ((ArrayList)Mekanism.teleporters.get(this.code)).add(Teleporter.Coords.get(this));
                } else if (((ArrayList)Mekanism.teleporters.get(this.code)).contains(Teleporter.Coords.get(this)) && !this.hasFrame()) {
                    ((ArrayList)Mekanism.teleporters.get(this.code)).remove(Teleporter.Coords.get(this));
                }
            } else if (this.hasFrame()) {
                ArrayList<Teleporter.Coords> newCoords = new ArrayList<Teleporter.Coords>();
                newCoords.add(Teleporter.Coords.get(this));
                Mekanism.teleporters.put(this.code, newCoords);
            }
            switch (this.canTeleport()) {
                case 1: {
                    this.status = (Object)((Object)EnumColor.DARK_GREEN) + "Ready.";
                    break;
                }
                case 2: {
                    this.status = (Object)((Object)EnumColor.DARK_RED) + "No frame.";
                    break;
                }
                case 3: {
                    this.status = (Object)((Object)EnumColor.DARK_RED) + "No link found.";
                    break;
                }
                case 4: {
                    this.status = (Object)((Object)EnumColor.DARK_RED) + "Links > 2.";
                    break;
                }
                case 5: {
                    this.status = (Object)((Object)EnumColor.DARK_RED) + "Needs energy.";
                    break;
                }
                case 6: {
                    this.status = (Object)((Object)EnumColor.DARK_GREEN) + "Idle.";
                }
            }
        }
        if (this.powerProvider != null) {
            int received = (int)(this.powerProvider.useEnergy(0.0f, (float)((this.MAX_ELECTRICITY - this.electricityStored) * Mekanism.TO_BC), true) * 10.0f);
            this.setJoules(this.electricityStored + (double)received, new Object[0]);
        }
        if (!this.k.I) {
            for (ForgeDirection direction : ForgeDirection.values()) {
                any tileEntity = Vector3.getTileEntityFromSide(this.k, new Vector3(this), direction);
                if (tileEntity == null || !(tileEntity instanceof IConductor)) continue;
                if (this.electricityStored < this.MAX_ELECTRICITY) {
                    double electricityNeeded = this.MAX_ELECTRICITY - this.electricityStored;
                    ((IConductor)tileEntity).getNetwork().startRequesting(this, electricityNeeded, electricityNeeded >= this.getVoltage(new Object[0]) ? this.getVoltage(new Object[0]) : electricityNeeded);
                    this.setJoules(this.electricityStored + ((IConductor)tileEntity).getNetwork().consumeElectricity(this).getWatts(), new Object[0]);
                    continue;
                }
                if (!(this.electricityStored >= this.MAX_ELECTRICITY)) continue;
                ((IConductor)tileEntity).getNetwork().stopRequesting(this);
            }
        }
        if (this.inventory[0] != null) {
            if (this.electricityStored < this.MAX_ELECTRICITY) {
                IElectricItem item;
                if (this.inventory[0].b() instanceof IItemElectric) {
                    IItemElectric electricItem = (IItemElectric)this.inventory[0].b();
                    if (electricItem.canProduceElectricity()) {
                        double joulesNeeded = this.MAX_ELECTRICITY - this.electricityStored;
                        double joulesReceived = electricItem.onUse(Math.min(electricItem.getMaxJoules(this.inventory[0]) * 0.005, joulesNeeded), this.inventory[0]);
                        this.setJoules(this.electricityStored + joulesReceived, new Object[0]);
                    }
                } else if (this.inventory[0].b() instanceof IElectricItem && (item = (IElectricItem)this.inventory[0].b()).canProvideEnergy()) {
                    double gain = (double)ElectricItem.discharge(this.inventory[0], (int)((this.MAX_ELECTRICITY - this.electricityStored) * Mekanism.TO_IC2), 3, false, false) * Mekanism.FROM_IC2;
                    this.setJoules(this.electricityStored + gain, new Object[0]);
                }
            }
            if (this.inventory[0].c == up.aC.cj && this.electricityStored + 1000.0 <= this.MAX_ELECTRICITY) {
                this.setJoules(this.electricityStored + 1000.0, new Object[0]);
                --this.inventory[0].a;
                if (this.inventory[0].a <= 0) {
                    this.inventory[0] = null;
                }
            }
        }
    }

    public byte canTeleport() {
        if (!this.hasFrame()) {
            return 2;
        }
        if (!Mekanism.teleporters.containsKey(this.code) || ((ArrayList)Mekanism.teleporters.get(this.code)).isEmpty()) {
            return 3;
        }
        if (((ArrayList)Mekanism.teleporters.get(this.code)).size() > 2) {
            return 4;
        }
        if (((ArrayList)Mekanism.teleporters.get(this.code)).size() == 2) {
            List entitiesInPortal = this.k.a(qx.class, aoe.a((double)(this.l - 1), (double)this.m, (double)(this.n - 1), (double)(this.l + 1), (double)(this.m + 3), (double)(this.n + 1)));
            Teleporter.Coords closestCoords = null;
            for (Teleporter.Coords coords : (ArrayList)Mekanism.teleporters.get(this.code)) {
                if (coords.equals(Teleporter.Coords.get(this))) continue;
                closestCoords = coords;
                break;
            }
            int electricityNeeded = 0;
            for (qx entity : entitiesInPortal) {
                electricityNeeded += this.calculateEnergyCost((lq)entity, closestCoords);
            }
            if (entitiesInPortal.size() == 0) {
                return 6;
            }
            if (this.electricityStored < (double)electricityNeeded) {
                return 5;
            }
            return 1;
        }
        return 3;
    }

    public void teleport() {
        if (this.k.I) {
            return;
        }
        List entitiesInPortal = this.k.a(qx.class, aoe.a((double)(this.l - 1), (double)this.m, (double)(this.n - 1), (double)(this.l + 1), (double)(this.m + 3), (double)(this.n + 1)));
        Teleporter.Coords closestCoords = null;
        for (Teleporter.Coords coords : (ArrayList)Mekanism.teleporters.get(this.code)) {
            if (coords.equals(Teleporter.Coords.get(this))) continue;
            closestCoords = coords;
            break;
        }
        for (qx entity : entitiesInPortal) {
            this.setJoules(this.electricityStored - (double)this.calculateEnergyCost((lq)entity, closestCoords), new Object[0]);
            this.k.a((lq)((iq)entity), "mob.endermen.portal", 1.0f, 1.0f);
            if (entity.p.u.h != closestCoords.dimensionId) {
                entity.b(closestCoords.dimensionId);
            }
            ((iq)entity).a.a((double)closestCoords.xCoord + 0.5, (double)closestCoords.yCoord, (double)closestCoords.zCoord + 0.5, entity.z, entity.A);
            for (Teleporter.Coords coords : (ArrayList)Mekanism.teleporters.get(this.code)) {
                PacketHandler.sendPortalFX(coords.xCoord, coords.yCoord, coords.zCoord, coords.dimensionId);
            }
        }
    }

    @Override
    public void w_() {
        super.w_();
        if (!this.k.I && Mekanism.teleporters.containsKey(this.code)) {
            if (((ArrayList)Mekanism.teleporters.get(this.code)).contains(Teleporter.Coords.get(this))) {
                ((ArrayList)Mekanism.teleporters.get(this.code)).remove(Teleporter.Coords.get(this));
            }
            if (((ArrayList)Mekanism.teleporters.get(this.code)).isEmpty()) {
                Mekanism.teleporters.remove(this.code);
            }
        }
    }

    public int calculateEnergyCost(lq entity, Teleporter.Coords coords) {
        int energyCost = 1000;
        if (entity.p.u.h != coords.dimensionId) {
            energyCost += 10000;
        }
        int distance = (int)entity.f((double)coords.xCoord, (double)coords.yCoord, (double)coords.zCoord);
        System.out.println(distance);
        return energyCost += distance;
    }

    public boolean hasFrame() {
        if (this.isFrame(this.l - 1, this.m, this.n) && this.isFrame(this.l + 1, this.m, this.n) && this.isFrame(this.l - 1, this.m + 1, this.n) && this.isFrame(this.l + 1, this.m + 1, this.n) && this.isFrame(this.l - 1, this.m + 2, this.n) && this.isFrame(this.l + 1, this.m + 2, this.n) && this.isFrame(this.l - 1, this.m + 3, this.n) && this.isFrame(this.l + 1, this.m + 3, this.n) && this.isFrame(this.l, this.m + 3, this.n)) {
            return true;
        }
        return this.isFrame(this.l, this.m, this.n - 1) && this.isFrame(this.l, this.m, this.n + 1) && this.isFrame(this.l, this.m + 1, this.n - 1) && this.isFrame(this.l, this.m + 1, this.n + 1) && this.isFrame(this.l, this.m + 2, this.n - 1) && this.isFrame(this.l, this.m + 2, this.n + 1) && this.isFrame(this.l, this.m + 3, this.n - 1) && this.isFrame(this.l, this.m + 3, this.n + 1) && this.isFrame(this.l, this.m + 3, this.n);
    }

    public boolean isFrame(int x, int y2, int z) {
        return this.k.a(x, y2, z) == Mekanism.basicBlockID && this.k.h(x, y2, z) == 8;
    }

    public int getScaledEnergyLevel(int i) {
        return (int)(this.electricityStored * (double)i / this.MAX_ELECTRICITY);
    }

    @Override
    public void a(bq nbtTags) {
        super.a(nbtTags);
        this.code.digitOne = nbtTags.e("digitOne");
        this.code.digitTwo = nbtTags.e("digitTwo");
        this.code.digitThree = nbtTags.e("digitThree");
        this.code.digitFour = nbtTags.e("digitFour");
    }

    @Override
    public void b(bq nbtTags) {
        super.b(nbtTags);
        nbtTags.a("digitOne", this.code.digitOne);
        nbtTags.a("digitTwo", this.code.digitTwo);
        nbtTags.a("digitThree", this.code.digitThree);
        nbtTags.a("digitFour", this.code.digitFour);
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        if (!this.k.I) {
            int type;
            if (Mekanism.teleporters.containsKey(this.code)) {
                if (((ArrayList)Mekanism.teleporters.get(this.code)).contains(Teleporter.Coords.get(this))) {
                    ((ArrayList)Mekanism.teleporters.get(this.code)).remove(Teleporter.Coords.get(this));
                }
                if (((ArrayList)Mekanism.teleporters.get(this.code)).isEmpty()) {
                    Mekanism.teleporters.remove(this.code);
                }
            }
            if ((type = dataStream.readInt()) == 0) {
                this.code.digitOne = dataStream.readInt();
            } else if (type == 1) {
                this.code.digitTwo = dataStream.readInt();
            } else if (type == 2) {
                this.code.digitThree = dataStream.readInt();
            } else if (type == 3) {
                this.code.digitFour = dataStream.readInt();
            }
            return;
        }
        super.handlePacketData(dataStream);
        this.status = dataStream.readUTF().trim();
        this.code.digitOne = dataStream.readInt();
        this.code.digitTwo = dataStream.readInt();
        this.code.digitThree = dataStream.readInt();
        this.code.digitFour = dataStream.readInt();
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.status);
        data.add(this.code.digitOne);
        data.add(this.code.digitTwo);
        data.add(this.code.digitThree);
        data.add(this.code.digitFour);
        return data;
    }

    @Override
    public boolean acceptsEnergyFrom(any emitter, Direction direction) {
        return true;
    }

    @Override
    public String getType() {
        return this.b();
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"getStored", "canTeleport", "getMaxEnergy", "getEnergyNeeded", "teleport", "set"};
    }

    @Override
    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        block0 : switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.canTeleport()};
            }
            case 2: {
                return new Object[]{this.MAX_ELECTRICITY};
            }
            case 3: {
                return new Object[]{this.MAX_ELECTRICITY - this.electricityStored};
            }
            case 4: {
                this.teleport();
                return new Object[]{"Attempted to teleport."};
            }
            case 5: {
                if (!(arguments[0] instanceof Integer) || !(arguments[1] instanceof Integer)) {
                    return new Object[]{"Invalid parameters."};
                }
                int digit = (Integer)arguments[0];
                int newDigit = (Integer)arguments[1];
                switch (digit) {
                    case 0: {
                        this.code.digitOne = newDigit;
                        break block0;
                    }
                    case 1: {
                        this.code.digitTwo = newDigit;
                        break block0;
                    }
                    case 2: {
                        this.code.digitThree = newDigit;
                        break block0;
                    }
                    case 3: {
                        this.code.digitFour = newDigit;
                        break block0;
                    }
                }
                return new Object[]{"No digit found."};
            }
        }
        System.err.println("[Mekanism] Attempted to call unknown method with computer ID " + computer.getID());
        return new Object[]{"Unknown command."};
    }

    @Override
    public boolean canAttachToSide(int side) {
        return true;
    }

    @Override
    public void attach(IComputerAccess computer) {
    }

    @Override
    public void detach(IComputerAccess computer) {
    }

    @Override
    public double getVoltage(Object ... data) {
        return 120.0;
    }

    @Override
    public double getJoules(Object ... data) {
        return this.electricityStored;
    }

    @Override
    public void setJoules(double joules, Object ... data) {
        this.electricityStored = Math.max(Math.min(joules, this.getMaxJoules(new Object[0])), 0.0);
    }

    @Override
    public double getMaxJoules(Object ... data) {
        return this.MAX_ELECTRICITY;
    }

    @Override
    public int demandsEnergy() {
        return (int)((this.MAX_ELECTRICITY - this.electricityStored) * Mekanism.TO_IC2);
    }

    @Override
    public int injectEnergy(Direction directionFrom, int amount) {
        double givenEnergy = (double)amount * Mekanism.FROM_IC2;
        double rejects = 0.0;
        double neededEnergy = this.MAX_ELECTRICITY - this.electricityStored;
        if (givenEnergy < neededEnergy) {
            this.electricityStored += givenEnergy;
        } else if (givenEnergy > neededEnergy) {
            this.electricityStored += neededEnergy;
            rejects = givenEnergy - neededEnergy;
        }
        return (int)(rejects * Mekanism.TO_IC2);
    }

    @Override
    public int getMaxSafeInput() {
        return 2048;
    }
}

