/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import ic2.api.Direction;
import ic2.api.ElectricItem;
import ic2.api.IElectricItem;
import ic2.api.energy.tile.IEnergySink;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.IActiveState;
import mekanism.api.IConfigurable;
import mekanism.api.IUpgradeManagement;
import mekanism.api.SideData;
import mekanism.api.Tier;
import mekanism.client.Sound;
import mekanism.common.Mekanism;
import mekanism.common.MekanismUtils;
import mekanism.common.PacketHandler;
import mekanism.common.TileEntityElectricBlock;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.electricity.ElectricityConnections;
import universalelectricity.core.implement.IConductor;
import universalelectricity.core.implement.IItemElectric;
import universalelectricity.core.implement.IJouleStorage;
import universalelectricity.core.implement.IVoltage;
import universalelectricity.core.vector.Vector3;

public class TileEntitySmeltingFactory
extends TileEntityElectricBlock
implements IEnergySink,
IJouleStorage,
IVoltage,
IPeripheral,
IActiveState,
IConfigurable,
IUpgradeManagement {
    public Tier.SmeltingFactoryTier tier;
    public byte[] sideConfig;
    public ArrayList sideOutputs = new ArrayList();
    @SideOnly(value=Side.CLIENT)
    public Sound audio;
    public int[] progress;
    public int TICKS_REQUIRED = 200;
    public int ENERGY_PER_TICK = 10;
    public int speedMultiplier;
    public int energyMultiplier;
    public int UPGRADE_TICKS_REQUIRED = 40;
    public int upgradeTicks;
    public boolean prevActive;
    public boolean isActive;

    public TileEntitySmeltingFactory() {
        this(Tier.SmeltingFactoryTier.BASIC);
        this.sideOutputs.add(new SideData(EnumColor.GREY, 0, 0));
        this.sideOutputs.add(new SideData(EnumColor.ORANGE, 0, 1));
        this.sideOutputs.add(new SideData(EnumColor.DARK_GREEN, 1, 1));
        this.sideOutputs.add(new SideData(EnumColor.DARK_RED, 2, 3));
        this.sideOutputs.add(new SideData(EnumColor.DARK_BLUE, 5, 3));
        this.sideConfig = new byte[]{4, 3, 0, 0, 2, 1};
    }

    public TileEntitySmeltingFactory(Tier.SmeltingFactoryTier type) {
        super(type.name + " Smelting Factory", type.processes * 2000);
        ElectricityConnections.registerConnector(this, EnumSet.allOf(ForgeDirection.class));
        this.tier = type;
        this.inventory = new ur[2 + type.processes * 2];
        this.progress = new int[type.processes];
        this.isActive = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void onUpdate() {
        void var2_12;
        block46: {
            super.onUpdate();
            if (this.k.I) {
                try {
                    if (Mekanism.audioHandler == null) break block46;
                    List list = Mekanism.audioHandler.sounds;
                    synchronized (list) {
                        this.handleSound();
                    }
                }
                catch (NoSuchMethodError e) {
                    // empty catch block
                }
            }
        }
        if (this.powerProvider != null) {
            int received = (int)((double)this.powerProvider.useEnergy(0.0f, (float)((MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored) * Mekanism.TO_BC), true) * Mekanism.FROM_BC);
            this.setJoules(this.electricityStored + (double)received, new Object[0]);
        }
        boolean testActive = false;
        if (!this.k.I) {
            for (ForgeDirection direction : ForgeDirection.values()) {
                any tileEntity = Vector3.getTileEntityFromSide(this.k, new Vector3(this), direction);
                if (tileEntity == null || !(tileEntity instanceof IConductor)) continue;
                if (this.electricityStored < MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY)) {
                    double electricityNeeded = MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored;
                    ((IConductor)tileEntity).getNetwork().startRequesting(this, electricityNeeded, electricityNeeded >= this.getVoltage(new Object[0]) ? this.getVoltage(new Object[0]) : electricityNeeded);
                    this.setJoules(this.electricityStored + ((IConductor)tileEntity).getNetwork().consumeElectricity(this).getWatts(), new Object[0]);
                    continue;
                }
                if (!(this.electricityStored >= MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY))) continue;
                ((IConductor)tileEntity).getNetwork().stopRequesting(this);
            }
        }
        for (int i : this.progress) {
            if (i <= 0) continue;
            testActive = true;
        }
        if (this.inventory[1] != null) {
            if (this.electricityStored < MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY)) {
                IElectricItem iElectricItem;
                if (this.inventory[1].b() instanceof IItemElectric) {
                    IItemElectric iItemElectric = (IItemElectric)this.inventory[1].b();
                    if (iItemElectric.canProduceElectricity()) {
                        double joulesNeeded = MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored;
                        double joulesReceived = iItemElectric.onUse(Math.min(iItemElectric.getMaxJoules(this.inventory[1]) * 0.005, joulesNeeded), this.inventory[1]);
                        this.setJoules(this.electricityStored + joulesReceived, new Object[0]);
                    }
                } else if (this.inventory[1].b() instanceof IElectricItem && (iElectricItem = (IElectricItem)this.inventory[1].b()).canProvideEnergy()) {
                    double gain = (double)ElectricItem.discharge(this.inventory[1], (int)((this.MAX_ELECTRICITY - this.electricityStored) * Mekanism.TO_IC2), 3, false, false) * Mekanism.FROM_IC2;
                    this.setJoules(this.electricityStored + gain, new Object[0]);
                }
            }
            if (this.inventory[1].c == up.aC.cj && this.electricityStored + 1000.0 <= MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY)) {
                this.setJoules(this.electricityStored + 1000.0, new Object[0]);
                --this.inventory[1].a;
                if (this.inventory[1].a <= 0) {
                    this.inventory[1] = null;
                }
            }
        }
        if (this.inventory[0] != null) {
            if (this.inventory[0].a(new ur(Mekanism.EnergyUpgrade)) && this.energyMultiplier < 8) {
                if (this.upgradeTicks < this.UPGRADE_TICKS_REQUIRED) {
                    ++this.upgradeTicks;
                } else if (this.upgradeTicks == this.UPGRADE_TICKS_REQUIRED) {
                    this.upgradeTicks = 0;
                    ++this.energyMultiplier;
                    --this.inventory[0].a;
                    if (this.inventory[0].a == 0) {
                        this.inventory[0] = null;
                    }
                }
            } else if (this.inventory[0].a(new ur(Mekanism.SpeedUpgrade)) && this.speedMultiplier < 8) {
                if (this.upgradeTicks < this.UPGRADE_TICKS_REQUIRED) {
                    ++this.upgradeTicks;
                } else if (this.upgradeTicks == this.UPGRADE_TICKS_REQUIRED) {
                    this.upgradeTicks = 0;
                    ++this.speedMultiplier;
                    --this.inventory[0].a;
                    if (this.inventory[0].a == 0) {
                        this.inventory[0] = null;
                    }
                }
            } else {
                this.upgradeTicks = 0;
            }
        } else {
            this.upgradeTicks = 0;
        }
        boolean bl = false;
        while (var2_12 < this.tier.processes) {
            if (this.canOperate(this.getInputSlot((int)var2_12), this.getOutputSlot((int)var2_12)) && this.progress[var2_12] + 1 < MekanismUtils.getTicks(this.speedMultiplier)) {
                void v0 = var2_12;
                this.progress[v0] = this.progress[v0] + 1;
                this.electricityStored -= (double)this.ENERGY_PER_TICK;
            } else if (this.canOperate(this.getInputSlot((int)var2_12), this.getOutputSlot((int)var2_12)) && this.progress[var2_12] + 1 >= MekanismUtils.getTicks(this.speedMultiplier)) {
                if (!this.k.I) {
                    this.operate(this.getInputSlot((int)var2_12), this.getOutputSlot((int)var2_12));
                }
                this.progress[var2_12] = 0;
                this.electricityStored -= (double)this.ENERGY_PER_TICK;
            }
            if (!this.canOperate(this.getInputSlot((int)var2_12), this.getOutputSlot((int)var2_12))) {
                this.progress[var2_12] = 0;
            }
            ++var2_12;
        }
        if (!this.k.I) {
            boolean bl2;
            boolean bl3 = false;
            boolean hasOperation = false;
            for (int i = 0; i < this.tier.processes; ++i) {
                if (!this.canOperate(this.getInputSlot(i), this.getOutputSlot(i))) continue;
                hasOperation = true;
            }
            for (int i : this.progress) {
                if (i <= 0) continue;
                bl2 = true;
            }
            if (testActive != bl2) {
                if (bl2) {
                    this.setActive(true);
                } else if (!hasOperation) {
                    this.setActive(false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public void handleSound() {
        if (Mekanism.audioHandler != null) {
            List list = Mekanism.audioHandler.sounds;
            synchronized (list) {
                if (this.audio == null && this.k != null && this.k.I) {
                    bev cfr_ignored_0 = FMLClientHandler.instance().getClient().A;
                    if (bev.a != null) {
                        this.audio = Mekanism.audioHandler.getSound("SmeltingFactory.ogg", this.k, this.l, this.m, this.n);
                    }
                }
                if (this.k != null && this.k.I && this.audio != null) {
                    if (!this.audio.isPlaying && this.isActive) {
                        this.audio.play();
                    } else if (this.audio.isPlaying && !this.isActive) {
                        this.audio.stopLoop();
                    }
                }
            }
        }
    }

    @Override
    public void w_() {
        super.w_();
        if (this.k.I && this.audio != null) {
            this.audio.remove();
        }
    }

    public int getScaledProgress(int i, int process) {
        return this.progress[process] * i / MekanismUtils.getTicks(this.speedMultiplier);
    }

    public int getScaledEnergyLevel(int i) {
        return (int)(this.electricityStored * (double)i / MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY));
    }

    public int getScaledUpgradeProgress(int i) {
        return this.upgradeTicks * i / this.UPGRADE_TICKS_REQUIRED;
    }

    public boolean canOperate(int inputSlot, int outputSlot) {
        if (this.inventory[inputSlot] == null) {
            return false;
        }
        if (this.electricityStored < (double)this.ENERGY_PER_TICK) {
            return false;
        }
        ur itemstack = wj.a().getSmeltingResult(this.inventory[inputSlot]);
        if (itemstack == null) {
            return false;
        }
        if (this.inventory[outputSlot] == null) {
            return true;
        }
        if (!this.inventory[outputSlot].a(itemstack)) {
            return false;
        }
        return this.inventory[outputSlot].a + itemstack.a <= this.inventory[outputSlot].d();
    }

    public void operate(int inputSlot, int outputSlot) {
        if (!this.canOperate(inputSlot, outputSlot)) {
            return;
        }
        ur itemstack = wj.a().getSmeltingResult(this.inventory[inputSlot]).l();
        --this.inventory[inputSlot].a;
        if (this.inventory[inputSlot].a <= 0) {
            this.inventory[inputSlot] = null;
        }
        if (this.inventory[outputSlot] == null) {
            this.inventory[outputSlot] = itemstack;
        } else {
            this.inventory[outputSlot].a += itemstack.a;
        }
    }

    @Override
    public int getStartInventorySide(ForgeDirection side) {
        return ((SideData)this.sideOutputs.get((int)this.sideConfig[MekanismUtils.getBaseOrientation((int)side.ordinal(), (int)this.facing)])).slotStart;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection side) {
        return ((SideData)this.sideOutputs.get((int)this.sideConfig[MekanismUtils.getBaseOrientation((int)side.ordinal(), (int)this.facing)])).slotAmount;
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        this.speedMultiplier = dataStream.readInt();
        this.energyMultiplier = dataStream.readInt();
        this.isActive = dataStream.readBoolean();
        for (int i = 0; i < this.tier.processes; ++i) {
            this.progress[i] = dataStream.readInt();
        }
    }

    @Override
    public void a(bq nbtTags) {
        int i;
        super.a(nbtTags);
        this.speedMultiplier = nbtTags.e("speedMultiplier");
        this.energyMultiplier = nbtTags.e("energyMultiplier");
        this.isActive = nbtTags.n("isActive");
        for (i = 0; i < this.tier.processes; ++i) {
            this.progress[i] = nbtTags.e("progress" + i);
        }
        if (nbtTags.b("sideDataStored")) {
            for (i = 0; i < 6; ++i) {
                this.sideConfig[i] = nbtTags.c("config" + i);
            }
        }
    }

    @Override
    public void b(bq nbtTags) {
        int i;
        super.b(nbtTags);
        nbtTags.a("speedMultiplier", this.speedMultiplier);
        nbtTags.a("energyMultiplier", this.energyMultiplier);
        nbtTags.a("isActive", this.isActive);
        for (i = 0; i < this.tier.processes; ++i) {
            nbtTags.a("progress" + i, this.progress[i]);
        }
        nbtTags.a("sideDataStored", true);
        for (i = 0; i < 6; ++i) {
            nbtTags.a("config" + i, this.sideConfig[i]);
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.speedMultiplier);
        data.add(this.energyMultiplier);
        data.add(this.isActive);
        data.add(this.progress);
        return data;
    }

    @Override
    public boolean acceptsEnergyFrom(any emitter, Direction direction) {
        return true;
    }

    public int getInputSlot(int operation) {
        return operation + 2;
    }

    public int getOutputSlot(int operation) {
        return this.tier.processes + 2 + operation;
    }

    @Override
    public String getType() {
        return this.b();
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"getStored", "getProgress", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded"};
    }

    @Override
    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                if (arguments[0] == null) {
                    return new Object[]{"Please provide a target operation."};
                }
                if (!(arguments[0] instanceof Double) && !(arguments[0] instanceof Integer)) {
                    return new Object[]{"Invalid characters."};
                }
                if ((Integer)arguments[0] < 0 || (Integer)arguments[0] > this.progress.length) {
                    return new Object[]{"No such operation found."};
                }
                return new Object[]{this.progress[(Integer)arguments[0]]};
            }
            case 2: {
                return new Object[]{this.facing};
            }
            case 3: {
                if (arguments[0] == null) {
                    return new Object[]{"Please provide a target operation."};
                }
                if (!(arguments[0] instanceof Double) && !(arguments[0] instanceof Integer)) {
                    return new Object[]{"Invalid characters."};
                }
                if ((Integer)arguments[0] < 0 || (Integer)arguments[0] > this.progress.length) {
                    return new Object[]{"No such operation found."};
                }
                return new Object[]{this.canOperate(this.getInputSlot((Integer)arguments[0]), this.getOutputSlot((Integer)arguments[0]))};
            }
            case 4: {
                return new Object[]{MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY)};
            }
            case 5: {
                return new Object[]{MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored};
            }
        }
        System.err.println("[Mekanism] Attempted to call unknown method with computer ID " + computer.getID());
        return new Object[]{"Unknown command."};
    }

    @Override
    public boolean canAttachToSide(int side) {
        return true;
    }

    @Override
    public void attach(IComputerAccess computer) {
    }

    @Override
    public void detach(IComputerAccess computer) {
    }

    @Override
    public double getVoltage(Object ... data) {
        return 120.0;
    }

    @Override
    public double getJoules(Object ... data) {
        return this.electricityStored;
    }

    @Override
    public void setJoules(double joules, Object ... data) {
        this.electricityStored = Math.max(Math.min(joules, this.getMaxJoules(new Object[0])), 0.0);
    }

    @Override
    public double getMaxJoules(Object ... data) {
        return MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY);
    }

    @Override
    public int demandsEnergy() {
        return (int)((MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored) * Mekanism.TO_IC2);
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.prevActive != active) {
            PacketHandler.sendTileEntityPacketToClients(this, 0.0, this.getNetworkedData(new ArrayList()));
        }
        this.prevActive = active;
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public int getMaxSafeInput() {
        return 2048;
    }

    @Override
    public int injectEnergy(Direction direction, int i) {
        double givenEnergy = (double)i * Mekanism.FROM_IC2;
        double rejects = 0.0;
        double neededEnergy = MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored;
        if (givenEnergy < neededEnergy) {
            this.electricityStored += givenEnergy;
        } else if (givenEnergy > neededEnergy) {
            this.electricityStored += neededEnergy;
            rejects = givenEnergy - neededEnergy;
        }
        return (int)(rejects * Mekanism.TO_IC2);
    }

    @Override
    public int powerRequest() {
        return (int)((MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored) * Mekanism.TO_BC);
    }

    @Override
    public ArrayList getSideData() {
        return this.sideOutputs;
    }

    @Override
    public byte[] getConfiguration() {
        return this.sideConfig;
    }

    @Override
    public int getOrientation() {
        return this.facing;
    }

    @Override
    public int getEnergyMultiplier(Object ... data) {
        return this.energyMultiplier;
    }

    @Override
    public void setEnergyMultiplier(int multiplier, Object ... data) {
        this.energyMultiplier = multiplier;
    }

    @Override
    public int getSpeedMultiplier(Object ... data) {
        return this.speedMultiplier;
    }

    @Override
    public void setSpeedMultiplier(int multiplier, Object ... data) {
        this.speedMultiplier = multiplier;
    }
}

