/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import ic2.api.Direction;
import ic2.api.ElectricItem;
import ic2.api.IElectricItem;
import ic2.api.energy.tile.IEnergySink;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import mekanism.api.EnumColor;
import mekanism.api.IActiveState;
import mekanism.api.IConfigurable;
import mekanism.api.IUpgradeManagement;
import mekanism.api.InfuseObject;
import mekanism.api.InfusionInput;
import mekanism.api.InfusionOutput;
import mekanism.api.InfusionType;
import mekanism.api.SideData;
import mekanism.client.Sound;
import mekanism.common.Mekanism;
import mekanism.common.MekanismUtils;
import mekanism.common.PacketHandler;
import mekanism.common.RecipeHandler;
import mekanism.common.TileEntityElectricBlock;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.electricity.ElectricityConnections;
import universalelectricity.core.implement.IConductor;
import universalelectricity.core.implement.IItemElectric;
import universalelectricity.core.implement.IJouleStorage;
import universalelectricity.core.implement.IVoltage;
import universalelectricity.core.vector.Vector3;

public class TileEntityMetallurgicInfuser
extends TileEntityElectricBlock
implements IEnergySink,
IJouleStorage,
IVoltage,
IPeripheral,
IActiveState,
IConfigurable,
IUpgradeManagement {
    @SideOnly(value=Side.CLIENT)
    public Sound audio;
    public byte[] sideConfig;
    public ArrayList sideOutputs = new ArrayList();
    public InfusionType type = InfusionType.NONE;
    public int MAX_INFUSE = 1000;
    public double ENERGY_PER_TICK = 10.0;
    public int TICKS_REQUIRED = 200;
    public int speedMultiplier;
    public int energyMultiplier;
    public int UPGRADE_TICKS_REQUIRED = 40;
    public int upgradeTicks;
    public int infuseStored;
    public int operatingTicks;
    public boolean isActive;
    public boolean prevActive;

    public TileEntityMetallurgicInfuser() {
        super("Metallurgic Infuser", 2000.0);
        this.sideOutputs.add(new SideData(EnumColor.GREY, 0, 0));
        this.sideOutputs.add(new SideData(EnumColor.ORANGE, 0, 1));
        this.sideOutputs.add(new SideData(EnumColor.PURPLE, 1, 1));
        this.sideOutputs.add(new SideData(EnumColor.DARK_RED, 2, 1));
        this.sideOutputs.add(new SideData(EnumColor.DARK_BLUE, 3, 1));
        this.sideOutputs.add(new SideData(EnumColor.DARK_GREEN, 4, 1));
        this.sideConfig = new byte[]{0, 1, 0, 5, 3, 4};
        this.inventory = new ur[5];
        ElectricityConnections.registerConnector(this, EnumSet.allOf(ForgeDirection.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUpdate() {
        boolean testActive;
        block45: {
            super.onUpdate();
            if (this.k.I) {
                try {
                    if (Mekanism.audioHandler == null) break block45;
                    List list = Mekanism.audioHandler.sounds;
                    synchronized (list) {
                        this.handleSound();
                    }
                }
                catch (NoSuchMethodError e) {
                    // empty catch block
                }
            }
        }
        if (this.powerProvider != null) {
            int received = (int)((double)this.powerProvider.useEnergy(0.0f, (float)((MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored) * Mekanism.TO_BC), true) * Mekanism.FROM_BC);
            this.setJoules(this.electricityStored + (double)received, new Object[0]);
        }
        boolean bl = testActive = this.operatingTicks > 0;
        if (!this.k.I) {
            for (ForgeDirection direction : ForgeDirection.values()) {
                any tileEntity = Vector3.getTileEntityFromSide(this.k, new Vector3(this), direction);
                if (tileEntity == null || !(tileEntity instanceof IConductor)) continue;
                if (this.electricityStored < MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY)) {
                    double electricityNeeded = MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored;
                    ((IConductor)tileEntity).getNetwork().startRequesting(this, electricityNeeded, electricityNeeded >= this.getVoltage(new Object[0]) ? this.getVoltage(new Object[0]) : electricityNeeded);
                    this.setJoules(this.electricityStored + ((IConductor)tileEntity).getNetwork().consumeElectricity(this).getWatts(), new Object[0]);
                    continue;
                }
                if (!(this.electricityStored >= MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY))) continue;
                ((IConductor)tileEntity).getNetwork().stopRequesting(this);
            }
        }
        if (this.inventory[4] != null) {
            if (this.electricityStored < MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY)) {
                IElectricItem item;
                if (this.inventory[4].b() instanceof IItemElectric) {
                    IItemElectric electricItem = (IItemElectric)this.inventory[4].b();
                    if (electricItem.canProduceElectricity()) {
                        double joulesNeeded = MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored;
                        double joulesReceived = electricItem.onUse(Math.min(electricItem.getMaxJoules(this.inventory[4]) * 0.005, joulesNeeded), this.inventory[4]);
                        this.setJoules(this.electricityStored + joulesReceived, new Object[0]);
                    }
                } else if (this.inventory[4].b() instanceof IElectricItem && (item = (IElectricItem)this.inventory[4].b()).canProvideEnergy()) {
                    double gain = (double)ElectricItem.discharge(this.inventory[4], (int)((this.MAX_ELECTRICITY - this.electricityStored) * Mekanism.TO_IC2), 3, false, false) * Mekanism.FROM_IC2;
                    this.setJoules(this.electricityStored + gain, new Object[0]);
                }
            }
            if (this.inventory[4].c == up.aC.cj && this.electricityStored + 1000.0 <= MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY)) {
                this.setJoules(this.electricityStored + 1000.0, new Object[0]);
                --this.inventory[4].a;
                if (this.inventory[4].a <= 0) {
                    this.inventory[4] = null;
                }
            }
        }
        if (this.inventory[0] != null) {
            if (this.inventory[0].a(new ur(Mekanism.EnergyUpgrade)) && this.energyMultiplier < 8) {
                if (this.upgradeTicks < this.UPGRADE_TICKS_REQUIRED) {
                    ++this.upgradeTicks;
                } else if (this.upgradeTicks == this.UPGRADE_TICKS_REQUIRED) {
                    this.upgradeTicks = 0;
                    ++this.energyMultiplier;
                    --this.inventory[0].a;
                    if (this.inventory[0].a == 0) {
                        this.inventory[0] = null;
                    }
                }
            } else if (this.inventory[0].a(new ur(Mekanism.SpeedUpgrade)) && this.speedMultiplier < 8) {
                if (this.upgradeTicks < this.UPGRADE_TICKS_REQUIRED) {
                    ++this.upgradeTicks;
                } else if (this.upgradeTicks == this.UPGRADE_TICKS_REQUIRED) {
                    this.upgradeTicks = 0;
                    ++this.speedMultiplier;
                    --this.inventory[0].a;
                    if (this.inventory[0].a == 0) {
                        this.inventory[0] = null;
                    }
                }
            } else {
                this.upgradeTicks = 0;
            }
        } else {
            this.upgradeTicks = 0;
        }
        if (this.inventory[1] != null && MekanismUtils.getInfuseObject(this.inventory[1]) != null) {
            InfuseObject infuse = MekanismUtils.getInfuseObject(this.inventory[1]);
            if ((this.type == InfusionType.NONE || this.type == infuse.type) && this.infuseStored + infuse.stored <= this.MAX_INFUSE) {
                this.infuseStored += infuse.stored;
                this.type = infuse.type;
                --this.inventory[1].a;
                if (this.inventory[1].a <= 0) {
                    this.inventory[1] = null;
                }
            }
        }
        if (this.electricityStored >= this.ENERGY_PER_TICK) {
            if (this.canOperate() && this.operatingTicks + 1 < MekanismUtils.getTicks(this.speedMultiplier)) {
                ++this.operatingTicks;
                this.electricityStored -= this.ENERGY_PER_TICK;
            } else if (this.canOperate() && this.operatingTicks + 1 >= MekanismUtils.getTicks(this.speedMultiplier)) {
                if (!this.k.I) {
                    this.operate();
                }
                this.operatingTicks = 0;
                this.electricityStored -= this.ENERGY_PER_TICK;
            }
        }
        if (!this.canOperate()) {
            this.operatingTicks = 0;
        }
        if (this.infuseStored <= 0) {
            this.infuseStored = 0;
            this.type = InfusionType.NONE;
        }
        if (!this.k.I) {
            if (this.canOperate() && this.electricityStored >= this.ENERGY_PER_TICK) {
                this.setActive(true);
            } else {
                this.setActive(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public void handleSound() {
        if (Mekanism.audioHandler != null) {
            List list = Mekanism.audioHandler.sounds;
            synchronized (list) {
                if (this.audio == null && this.k != null && this.k.I) {
                    bev cfr_ignored_0 = FMLClientHandler.instance().getClient().A;
                    if (bev.a != null) {
                        this.audio = Mekanism.audioHandler.getSound("MetallurgicInfuser.ogg", this.k, this.l, this.m, this.n);
                    }
                }
                if (this.k != null && this.k.I && this.audio != null) {
                    if (!this.audio.isPlaying && this.isActive) {
                        this.audio.play();
                    } else if (this.audio.isPlaying && !this.isActive) {
                        this.audio.stopLoop();
                    }
                }
            }
        }
    }

    public void operate() {
        if (!this.canOperate()) {
            return;
        }
        InfusionOutput output = RecipeHandler.getOutput(InfusionInput.getInfusion(this.type, this.infuseStored, this.inventory[2]), true, (Map)RecipeHandler.Recipe.METALLURGIC_INFUSER.get());
        this.infuseStored -= output.getInfuseRequired();
        if (this.inventory[2].a <= 0) {
            this.inventory[2] = null;
        }
        if (this.inventory[3] == null) {
            this.inventory[3] = output.resource.l();
        } else {
            this.inventory[3].a += output.resource.a;
        }
    }

    public boolean canOperate() {
        if (this.inventory[2] == null) {
            return false;
        }
        InfusionOutput output = RecipeHandler.getOutput(InfusionInput.getInfusion(this.type, this.infuseStored, this.inventory[2]), false, (Map)RecipeHandler.Recipe.METALLURGIC_INFUSER.get());
        if (output == null) {
            return false;
        }
        if (this.infuseStored - output.getInfuseRequired() < 0) {
            return false;
        }
        if (this.inventory[3] == null) {
            return true;
        }
        if (!this.inventory[3].a(output.resource)) {
            return false;
        }
        return this.inventory[3].a + output.resource.a <= this.inventory[3].d();
    }

    public int getScaledInfuseLevel(int i) {
        return this.infuseStored * i / this.MAX_INFUSE;
    }

    public int getScaledEnergyLevel(int i) {
        return (int)(this.electricityStored * (double)i / MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY));
    }

    public int getScaledProgress(int i) {
        return this.operatingTicks * i / MekanismUtils.getTicks(this.speedMultiplier);
    }

    public int getScaledUpgradeProgress(int i) {
        return this.upgradeTicks * i / this.UPGRADE_TICKS_REQUIRED;
    }

    @Override
    public void w_() {
        super.w_();
        if (this.k.I && this.audio != null) {
            this.audio.remove();
        }
    }

    @Override
    public void a(bq nbtTags) {
        super.a(nbtTags);
        this.speedMultiplier = nbtTags.e("speedMultiplier");
        this.energyMultiplier = nbtTags.e("energyMultiplier");
        this.isActive = nbtTags.n("isActive");
        this.operatingTicks = nbtTags.e("operatingTicks");
        this.infuseStored = nbtTags.e("infuseStored");
        this.type = InfusionType.getFromName(nbtTags.i("type"));
        if (nbtTags.b("sideDataStored")) {
            for (int i = 0; i < 6; ++i) {
                this.sideConfig[i] = nbtTags.c("config" + i);
            }
        }
    }

    @Override
    public int getStartInventorySide(ForgeDirection side) {
        return ((SideData)this.sideOutputs.get((int)this.sideConfig[MekanismUtils.getBaseOrientation((int)side.ordinal(), (int)this.facing)])).slotStart;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection side) {
        return ((SideData)this.sideOutputs.get((int)this.sideConfig[MekanismUtils.getBaseOrientation((int)side.ordinal(), (int)this.facing)])).slotAmount;
    }

    @Override
    public void b(bq nbtTags) {
        super.b(nbtTags);
        nbtTags.a("speedMultiplier", this.speedMultiplier);
        nbtTags.a("energyMultiplier", this.energyMultiplier);
        nbtTags.a("isActive", this.isActive);
        nbtTags.a("operatingTicks", this.operatingTicks);
        nbtTags.a("infuseStored", this.infuseStored);
        nbtTags.a("type", this.type.name);
        nbtTags.a("sideDataStored", true);
        for (int i = 0; i < 6; ++i) {
            nbtTags.a("config" + i, this.sideConfig[i]);
        }
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        if (!this.k.I) {
            this.infuseStored = dataStream.readInt();
            return;
        }
        super.handlePacketData(dataStream);
        this.speedMultiplier = dataStream.readInt();
        this.energyMultiplier = dataStream.readInt();
        this.isActive = dataStream.readBoolean();
        this.operatingTicks = dataStream.readInt();
        this.infuseStored = dataStream.readInt();
        this.type = InfusionType.getFromName(dataStream.readUTF());
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.speedMultiplier);
        data.add(this.energyMultiplier);
        data.add(this.isActive);
        data.add(this.operatingTicks);
        data.add(this.infuseStored);
        data.add(this.type.name);
        return data;
    }

    @Override
    public String getType() {
        return this.b();
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"getStored", "getProgress", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded", "getInfuse", "getInfuseNeeded"};
    }

    @Override
    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.operatingTicks};
            }
            case 2: {
                return new Object[]{this.facing};
            }
            case 3: {
                return new Object[]{this.canOperate()};
            }
            case 4: {
                return new Object[]{MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY)};
            }
            case 5: {
                return new Object[]{MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored};
            }
            case 6: {
                return new Object[]{this.infuseStored};
            }
            case 7: {
                return new Object[]{this.MAX_INFUSE - this.infuseStored};
            }
        }
        System.err.println("[Mekanism] Attempted to call unknown method with computer ID " + computer.getID());
        return new Object[]{"Unknown command."};
    }

    @Override
    public boolean canAttachToSide(int side) {
        return true;
    }

    @Override
    public void attach(IComputerAccess computer) {
    }

    @Override
    public void detach(IComputerAccess computer) {
    }

    @Override
    public double getVoltage(Object ... data) {
        return 120.0;
    }

    @Override
    public double getJoules(Object ... data) {
        return this.electricityStored;
    }

    @Override
    public void setJoules(double joules, Object ... data) {
        this.electricityStored = Math.max(Math.min(joules, this.getMaxJoules(new Object[0])), 0.0);
    }

    @Override
    public double getMaxJoules(Object ... data) {
        return MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY);
    }

    @Override
    public int demandsEnergy() {
        return (int)((MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored) * Mekanism.TO_IC2);
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.prevActive != active) {
            PacketHandler.sendTileEntityPacketToClients(this, 0.0, this.getNetworkedData(new ArrayList()));
        }
        this.prevActive = active;
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean acceptsEnergyFrom(any emitter, Direction direction) {
        return true;
    }

    @Override
    public int getMaxSafeInput() {
        return 2048;
    }

    @Override
    public int injectEnergy(Direction direction, int i) {
        double givenEnergy = (double)i * Mekanism.FROM_IC2;
        double rejects = 0.0;
        double neededEnergy = MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored;
        if (givenEnergy < neededEnergy) {
            this.electricityStored += givenEnergy;
        } else if (givenEnergy > neededEnergy) {
            this.electricityStored += neededEnergy;
            rejects = givenEnergy - neededEnergy;
        }
        return (int)(rejects * Mekanism.TO_IC2);
    }

    @Override
    public int powerRequest() {
        return (int)((MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored) * Mekanism.TO_BC);
    }

    @Override
    public ArrayList getSideData() {
        return this.sideOutputs;
    }

    @Override
    public byte[] getConfiguration() {
        return this.sideConfig;
    }

    @Override
    public int getOrientation() {
        return this.facing;
    }

    @Override
    public int getEnergyMultiplier(Object ... data) {
        return this.energyMultiplier;
    }

    @Override
    public void setEnergyMultiplier(int multiplier, Object ... data) {
        this.energyMultiplier = multiplier;
    }

    @Override
    public int getSpeedMultiplier(Object ... data) {
        return this.speedMultiplier;
    }

    @Override
    public void setSpeedMultiplier(int multiplier, Object ... data) {
        this.speedMultiplier = multiplier;
    }
}

