/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import com.google.common.io.ByteArrayDataInput;
import java.util.ArrayList;
import mekanism.api.EnumGas;
import mekanism.api.GasTransmission;
import mekanism.api.IGasAcceptor;
import mekanism.api.IGasStorage;
import mekanism.api.IStorageTank;
import mekanism.api.ITubeConnection;
import mekanism.common.TileEntityContainerBlock;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.vector.Vector3;

public class TileEntityGasTank
extends TileEntityContainerBlock
implements IGasStorage,
IGasAcceptor,
ITubeConnection {
    public EnumGas gasType = EnumGas.NONE;
    public int MAX_GAS = 96000;
    public int gasStored;
    public int output = 16;

    public TileEntityGasTank() {
        super("Gas Tank");
        this.inventory = new ur[2];
    }

    @Override
    public void onUpdate() {
        int rejects;
        int sendingGas;
        IStorageTank item;
        if (this.inventory[0] != null && this.gasStored > 0 && this.inventory[0].b() instanceof IStorageTank && (((IStorageTank)this.inventory[0].b()).getGasType(this.inventory[0]) == this.gasType || ((IStorageTank)this.inventory[0].b()).getGasType(this.inventory[0]) == EnumGas.NONE)) {
            item = (IStorageTank)this.inventory[0].b();
            if (this.gasType == EnumGas.NONE) {
                this.gasType = item.getGasType(this.inventory[0]);
            }
            if (item.canReceiveGas(this.inventory[0], this.gasType)) {
                sendingGas = 0;
                if (item.getRate() <= this.gasStored) {
                    sendingGas = item.getRate();
                } else if (item.getRate() > this.gasStored) {
                    sendingGas = this.gasStored;
                }
                rejects = item.addGas(this.inventory[0], this.gasType, sendingGas);
                this.setGas(this.gasType, this.gasStored - (sendingGas - rejects));
            }
        }
        if (this.inventory[1] != null && this.gasStored < this.MAX_GAS && this.inventory[1].b() instanceof IStorageTank && (((IStorageTank)this.inventory[1].b()).getGasType(this.inventory[1]) == this.gasType || this.gasType == EnumGas.NONE)) {
            item = (IStorageTank)this.inventory[1].b();
            if (this.gasType == EnumGas.NONE) {
                this.gasType = item.getGasType(this.inventory[1]);
            }
            if (item.canProvideGas(this.inventory[1], this.gasType)) {
                int received = 0;
                int gasNeeded = this.MAX_GAS - this.gasStored;
                if (item.getRate() <= gasNeeded) {
                    received = item.removeGas(this.inventory[1], this.gasType, item.getRate());
                } else if (item.getRate() > gasNeeded) {
                    received = item.removeGas(this.inventory[1], this.gasType, gasNeeded);
                }
                this.setGas(this.gasType, this.gasStored + received);
            }
        }
        if (this.gasStored == 0) {
            this.gasType = EnumGas.NONE;
        }
        if (this.gasStored > 0 && !this.k.I) {
            this.setGas(this.gasType, this.gasStored - (Math.min(this.gasStored, this.output) - GasTransmission.emitGasToNetwork(this.gasType, Math.min(this.gasStored, this.output), this, ForgeDirection.getOrientation((int)this.facing))));
            any tileEntity = Vector3.getTileEntityFromSide(this.k, new Vector3(this), ForgeDirection.getOrientation((int)this.facing));
            if (tileEntity instanceof IGasAcceptor && ((IGasAcceptor)tileEntity).canReceiveGas(ForgeDirection.getOrientation((int)this.facing).getOpposite(), this.gasType)) {
                sendingGas = 0;
                if (this.getGas(this.gasType) >= this.output) {
                    sendingGas = this.output;
                } else if (this.getGas(this.gasType) < this.output) {
                    sendingGas = this.getGas(this.gasType);
                }
                rejects = ((IGasAcceptor)tileEntity).transferGasToAcceptor(sendingGas, this.gasType);
                this.setGas(this.gasType, this.getGas(this.gasType) - (sendingGas - rejects));
            }
        }
    }

    @Override
    public int getStartInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.getOrientation((int)1)) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    @Override
    public int getGas(EnumGas type) {
        if (type == this.gasType) {
            return this.gasStored;
        }
        return 0;
    }

    @Override
    public void setGas(EnumGas type, int amount) {
        if (type == this.gasType) {
            this.gasStored = Math.max(Math.min(amount, this.MAX_GAS), 0);
        }
    }

    @Override
    public int transferGasToAcceptor(int amount, EnumGas type) {
        if (type == this.gasType || this.gasType == EnumGas.NONE) {
            if (this.gasType == EnumGas.NONE) {
                this.gasType = type;
            }
            int rejects = 0;
            int neededGas = this.MAX_GAS - this.gasStored;
            if (amount <= neededGas) {
                this.gasStored += amount;
            } else if (amount > neededGas) {
                this.gasStored += neededGas;
                rejects = amount - neededGas;
            }
            return rejects;
        }
        return amount;
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, EnumGas type) {
        return (type == this.gasType || this.gasType == EnumGas.NONE) && side != ForgeDirection.getOrientation((int)this.facing);
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        this.gasStored = dataStream.readInt();
        this.gasType = EnumGas.getFromName(dataStream.readUTF());
    }

    @Override
    public void a(bq nbtTags) {
        super.a(nbtTags);
        this.gasStored = nbtTags.e("gasStored");
        this.gasType = EnumGas.getFromName(nbtTags.i("gasType"));
    }

    @Override
    public void b(bq nbtTags) {
        super.b(nbtTags);
        nbtTags.a("gasStored", this.gasStored);
        nbtTags.a("gasType", this.gasType.name);
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.gasStored);
        data.add(this.gasType.name);
        return data;
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return true;
    }
}

