/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerProvider;
import com.google.common.io.ByteArrayDataInput;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import ic2.api.Direction;
import ic2.api.ElectricItem;
import ic2.api.IElectricItem;
import ic2.api.IEnergyStorage;
import ic2.api.energy.event.EnergyTileSourceEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import java.util.ArrayList;
import java.util.EnumSet;
import mekanism.api.IEnergyCube;
import mekanism.api.Tier;
import mekanism.common.Mekanism;
import mekanism.common.TileEntityElectricBlock;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import universalelectricity.core.electricity.ElectricInfo;
import universalelectricity.core.electricity.ElectricityConnections;
import universalelectricity.core.electricity.ElectricityNetwork;
import universalelectricity.core.implement.IConductor;
import universalelectricity.core.implement.IItemElectric;
import universalelectricity.core.implement.IJouleStorage;
import universalelectricity.core.implement.IVoltage;
import universalelectricity.core.vector.Vector3;

public class TileEntityEnergyCube
extends TileEntityElectricBlock
implements IEnergySink,
IEnergySource,
IEnergyStorage,
IPowerReceptor,
IJouleStorage,
IVoltage,
IPeripheral {
    public Tier.EnergyCubeTier tier = Tier.EnergyCubeTier.BASIC;
    public int output;

    public TileEntityEnergyCube() {
        super("Energy Cube", 0.0);
        ElectricityConnections.registerConnector(this, EnumSet.allOf(ForgeDirection.class));
        this.inventory = new ur[2];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.powerProvider != null) {
            int received = (int)((double)this.powerProvider.useEnergy(0.0f, (float)((this.tier.MAX_ELECTRICITY - this.electricityStored) * Mekanism.TO_BC), true) * Mekanism.FROM_BC);
            this.setJoules(this.electricityStored + (double)received, new Object[0]);
        }
        if (!this.k.I) {
            for (ForgeDirection direction : ForgeDirection.values()) {
                any tileEntity;
                if (direction == ForgeDirection.getOrientation((int)this.facing) || (tileEntity = Vector3.getTileEntityFromSide(this.k, new Vector3(this), direction)) == null || !(tileEntity instanceof IConductor)) continue;
                if (this.electricityStored < this.tier.MAX_ELECTRICITY) {
                    double electricityNeeded = this.tier.MAX_ELECTRICITY - this.electricityStored;
                    ((IConductor)tileEntity).getNetwork().startRequesting(this, electricityNeeded, electricityNeeded >= this.getVoltage(new Object[0]) ? this.getVoltage(new Object[0]) : electricityNeeded);
                    this.setJoules(this.electricityStored + ((IConductor)tileEntity).getNetwork().consumeElectricity(this).getWatts(), new Object[0]);
                    continue;
                }
                if (!(this.electricityStored >= this.tier.MAX_ELECTRICITY)) continue;
                ((IConductor)tileEntity).getNetwork().stopRequesting(this);
            }
        }
        if (this.inventory[0] != null && this.electricityStored > 0.0) {
            if (this.inventory[0].b() instanceof IItemElectric) {
                IItemElectric electricItem = (IItemElectric)this.inventory[0].b();
                if (electricItem.canReceiveElectricity()) {
                    double ampsToGive = Math.min(ElectricInfo.getAmps(Math.min(electricItem.getMaxJoules(this.inventory[0]) * 0.005, this.electricityStored), this.getVoltage(new Object[0])), this.electricityStored);
                    double rejects = electricItem.onReceive(ampsToGive, this.getVoltage(new Object[0]), this.inventory[0]);
                    this.setJoules(this.electricityStored - (ElectricInfo.getJoules(ampsToGive, this.getVoltage(new Object[0]), 1.0) - rejects), new Object[0]);
                }
            } else if (this.inventory[0].b() instanceof IElectricItem) {
                double sent = (double)ElectricItem.charge(this.inventory[0], (int)(this.electricityStored * Mekanism.TO_IC2), 3, false, false) * Mekanism.FROM_IC2;
                this.setJoules(this.electricityStored - sent, new Object[0]);
            }
        }
        if (this.inventory[1] != null && this.electricityStored < this.tier.MAX_ELECTRICITY) {
            if (this.inventory[1].b() instanceof IItemElectric) {
                IItemElectric electricItem = (IItemElectric)this.inventory[1].b();
                if (electricItem.canProduceElectricity()) {
                    double joulesNeeded = this.tier.MAX_ELECTRICITY - this.electricityStored;
                    double joulesReceived = electricItem.onUse(Math.min(electricItem.getMaxJoules(this.inventory[1]) * 0.005, joulesNeeded), this.inventory[1]);
                    this.setJoules(this.electricityStored + joulesReceived, new Object[0]);
                }
            } else if (this.inventory[1].b() instanceof IElectricItem) {
                IElectricItem item = (IElectricItem)this.inventory[1].b();
                if (item.canProvideEnergy()) {
                    double gain = (double)ElectricItem.discharge(this.inventory[1], (int)((this.tier.MAX_ELECTRICITY - this.electricityStored) * Mekanism.TO_IC2), 3, false, false) * Mekanism.FROM_IC2;
                    this.setJoules(this.electricityStored + gain, new Object[0]);
                }
            } else if (this.inventory[1].c == up.aC.cj && this.electricityStored + 1000.0 <= this.tier.MAX_ELECTRICITY) {
                this.setJoules(this.electricityStored + 1000.0, new Object[0]);
                --this.inventory[1].a;
                if (this.inventory[1].a <= 0) {
                    this.inventory[1] = null;
                }
            }
        }
        if (this.electricityStored > 0.0) {
            any tileEntity = Vector3.getTileEntityFromSide(this.k, new Vector3(this), ForgeDirection.getOrientation((int)this.facing));
            if (Mekanism.hooks.IC2Loaded && this.electricityStored >= (double)this.output) {
                EnergyTileSourceEvent event = new EnergyTileSourceEvent(this, this.output);
                MinecraftForge.EVENT_BUS.post((Event)event);
                this.setJoules(this.electricityStored - (double)(this.output - event.amount), new Object[0]);
            }
            if (tileEntity != null && this.isPowerReceptor(tileEntity)) {
                IPowerReceptor receptor = (IPowerReceptor)tileEntity;
                double electricityNeeded = (double)Math.min((float)receptor.powerRequest(), (float)receptor.getPowerProvider().getMaxEnergyStored() - receptor.getPowerProvider().getEnergyStored()) * Mekanism.FROM_BC;
                float transferEnergy = (float)Math.min(this.electricityStored, Math.min(electricityNeeded, (double)this.output));
                receptor.getPowerProvider().receiveEnergy((float)((double)transferEnergy * Mekanism.TO_BC), ForgeDirection.getOrientation((int)this.facing).getOpposite());
                this.setJoules(this.electricityStored - (double)transferEnergy, new Object[0]);
            }
        }
        if (!this.k.I) {
            ForgeDirection outputDirection = ForgeDirection.getOrientation((int)this.facing);
            ArrayList<ElectricityNetwork> inputNetworks = new ArrayList<ElectricityNetwork>();
            for (ForgeDirection direction : ForgeDirection.values()) {
                ElectricityNetwork network;
                if (direction == outputDirection || direction == ForgeDirection.UNKNOWN || (network = ElectricityNetwork.getNetworkFromTileEntity(Vector3.getTileEntityFromSide(this.k, new Vector3(this), direction), direction)) == null) continue;
                inputNetworks.add(network);
            }
            any outputTile = Vector3.getTileEntityFromSide(this.k, new Vector3(this), outputDirection);
            ElectricityNetwork outputNetwork = ElectricityNetwork.getNetworkFromTileEntity(outputTile, outputDirection);
            if (outputNetwork != null && !inputNetworks.contains(outputNetwork)) {
                double outputWatts = Math.min(outputNetwork.getRequest(new any[0]).getWatts(), Math.min(this.getJoules(new Object[0]), 10000.0));
                if (this.getJoules(new Object[0]) > 0.0 && outputWatts > 0.0 && this.getJoules(new Object[0]) - outputWatts >= 0.0) {
                    outputNetwork.startProducing(this, Math.min(outputWatts, this.getJoules(new Object[0])) / this.getVoltage(new Object[0]), this.getVoltage(new Object[0]));
                    this.setJoules(this.electricityStored - outputWatts, new Object[0]);
                } else {
                    outputNetwork.stopProducing(this);
                }
            }
        }
    }

    @Override
    public boolean acceptsEnergyFrom(any emitter, Direction direction) {
        return direction.toForgeDirection() != ForgeDirection.getOrientation((int)this.facing);
    }

    @Override
    public int getStored() {
        return (int)(this.electricityStored * Mekanism.TO_IC2);
    }

    @Override
    public int getCapacity() {
        return (int)(this.tier.MAX_ELECTRICITY * Mekanism.TO_IC2);
    }

    @Override
    public int getOutput() {
        return this.output;
    }

    @Override
    public int demandsEnergy() {
        return (int)((this.tier.MAX_ELECTRICITY - this.electricityStored) * Mekanism.TO_IC2);
    }

    @Override
    public int injectEnergy(Direction direction, int i) {
        double givenEnergy = (double)i * Mekanism.FROM_IC2;
        double rejects = 0.0;
        double neededEnergy = this.tier.MAX_ELECTRICITY - this.electricityStored;
        if (givenEnergy <= neededEnergy) {
            this.electricityStored += givenEnergy;
        } else if (givenEnergy > neededEnergy) {
            this.electricityStored += neededEnergy;
            rejects = givenEnergy - neededEnergy;
        }
        return (int)(rejects * Mekanism.TO_IC2);
    }

    @Override
    public boolean emitsEnergyTo(any receiver, Direction direction) {
        return direction.toForgeDirection() == ForgeDirection.getOrientation((int)this.facing);
    }

    @Override
    public int getMaxEnergyOutput() {
        return this.output;
    }

    @Override
    public double getJoules(Object ... data) {
        return this.electricityStored;
    }

    @Override
    public void setJoules(double joules, Object ... data) {
        this.electricityStored = Math.max(Math.min(joules, this.getMaxJoules(new Object[0])), 0.0);
    }

    @Override
    public double getMaxJoules(Object ... data) {
        return this.tier.MAX_ELECTRICITY;
    }

    @Override
    public int getStartInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.getOrientation((int)1)) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    @Override
    public double getVoltage(Object ... data) {
        return this.tier.VOLTAGE;
    }

    public boolean isPowerReceptor(any tileEntity) {
        if (tileEntity instanceof IPowerReceptor) {
            IPowerReceptor receptor = (IPowerReceptor)tileEntity;
            IPowerProvider provider = receptor.getPowerProvider();
            return provider != null && provider.getClass().getSuperclass().equals(PowerProvider.class);
        }
        return false;
    }

    @Override
    public String getType() {
        return this.b();
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"getStored", "getOutput", "getMaxEnergy", "getEnergyNeeded"};
    }

    @Override
    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.output};
            }
            case 2: {
                return new Object[]{this.tier.MAX_ELECTRICITY};
            }
            case 3: {
                return new Object[]{this.tier.MAX_ELECTRICITY - this.electricityStored};
            }
        }
        System.err.println("[Mekanism] Attempted to call unknown method with computer ID " + computer.getID());
        return null;
    }

    @Override
    public boolean canAttachToSide(int side) {
        return true;
    }

    @Override
    public void attach(IComputerAccess computer) {
    }

    @Override
    public void detach(IComputerAccess computer) {
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        this.tier = Tier.EnergyCubeTier.getFromName(dataStream.readUTF());
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.tier.name);
        return data;
    }

    @Override
    public void a(bq nbtTags) {
        super.a(nbtTags);
        this.tier = Tier.EnergyCubeTier.getFromName(nbtTags.i("tier"));
        this.output = this.tier.OUTPUT;
    }

    @Override
    public void b(bq nbtTags) {
        super.b(nbtTags);
        nbtTags.a("tier", this.tier.name);
    }

    @Override
    public int getMaxSafeInput() {
        return 2048;
    }

    @Override
    public void setStored(int energy) {
        this.setJoules((double)energy * Mekanism.FROM_IC2, new Object[0]);
    }

    @Override
    public int addEnergy(int amount) {
        this.setJoules(this.electricityStored + (double)amount * Mekanism.FROM_IC2, new Object[0]);
        return (int)this.electricityStored;
    }

    @Override
    public boolean isTeleporterCompatible(Direction side) {
        return true;
    }

    @Override
    public int powerRequest() {
        return (int)(this.tier.MAX_ELECTRICITY - this.electricityStored);
    }

    @Override
    public ur getWrenchDrop(qx entityPlayer) {
        ur itemStack = new ur(Mekanism.EnergyCube);
        IEnergyCube energyCube = (IEnergyCube)itemStack.b();
        energyCube.setTier(itemStack, this.tier);
        IItemElectric electricItem = (IItemElectric)itemStack.b();
        electricItem.setJoules(this.electricityStored, itemStack);
        return itemStack;
    }
}

