/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import dan200.computer.api.IComputerAccess;
import ic2.api.ElectricItem;
import ic2.api.IElectricItem;
import mekanism.api.EnumColor;
import mekanism.api.SideData;
import mekanism.common.Mekanism;
import mekanism.common.MekanismUtils;
import mekanism.common.RecipeHandler;
import mekanism.common.TileEntityBasicMachine;
import universalelectricity.core.implement.IItemElectric;

public abstract class TileEntityElectricMachine
extends TileEntityBasicMachine {
    public TileEntityElectricMachine(String soundPath, String name, String path, int perTick, int ticksRequired, int maxEnergy) {
        super(soundPath, name, path, perTick, ticksRequired, maxEnergy);
        this.sideOutputs.add(new SideData(EnumColor.GREY, 0, 0));
        this.sideOutputs.add(new SideData(EnumColor.DARK_RED, 0, 1));
        this.sideOutputs.add(new SideData(EnumColor.DARK_GREEN, 1, 1));
        this.sideOutputs.add(new SideData(EnumColor.DARK_BLUE, 2, 1));
        this.sideOutputs.add(new SideData(EnumColor.ORANGE, 3, 1));
        this.sideConfig = new byte[]{2, 1, 0, 0, 4, 3};
        this.inventory = new ur[4];
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.inventory[1] != null) {
            if (this.electricityStored < MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY)) {
                IElectricItem item;
                if (this.inventory[1].b() instanceof IItemElectric) {
                    IItemElectric electricItem = (IItemElectric)this.inventory[1].b();
                    if (electricItem.canProduceElectricity()) {
                        double joulesNeeded = MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored;
                        double joulesReceived = electricItem.onUse(Math.min(electricItem.getMaxJoules(this.inventory[1]) * 0.005, joulesNeeded), this.inventory[1]);
                        this.setJoules(this.electricityStored + joulesReceived, new Object[0]);
                    }
                } else if (this.inventory[1].b() instanceof IElectricItem && (item = (IElectricItem)this.inventory[1].b()).canProvideEnergy()) {
                    double gain = (double)ElectricItem.discharge(this.inventory[1], (int)((this.MAX_ELECTRICITY - this.electricityStored) * Mekanism.TO_IC2), 3, false, false) * Mekanism.FROM_IC2;
                    this.setJoules(this.electricityStored + gain, new Object[0]);
                }
            }
            if (this.inventory[1].c == up.aC.cj && this.electricityStored + 1000.0 <= MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY)) {
                this.setJoules(this.electricityStored + 1000.0, new Object[0]);
                --this.inventory[1].a;
                if (this.inventory[1].a <= 0) {
                    this.inventory[1] = null;
                }
            }
        }
        if (this.inventory[3] != null) {
            if (this.inventory[3].a(new ur(Mekanism.EnergyUpgrade)) && this.energyMultiplier < 8) {
                if (this.upgradeTicks < this.UPGRADE_TICKS_REQUIRED) {
                    ++this.upgradeTicks;
                } else if (this.upgradeTicks == this.UPGRADE_TICKS_REQUIRED) {
                    this.upgradeTicks = 0;
                    ++this.energyMultiplier;
                    --this.inventory[3].a;
                    if (this.inventory[3].a == 0) {
                        this.inventory[3] = null;
                    }
                }
            } else if (this.inventory[3].a(new ur(Mekanism.SpeedUpgrade)) && this.speedMultiplier < 8) {
                if (this.upgradeTicks < this.UPGRADE_TICKS_REQUIRED) {
                    ++this.upgradeTicks;
                } else if (this.upgradeTicks == this.UPGRADE_TICKS_REQUIRED) {
                    this.upgradeTicks = 0;
                    ++this.speedMultiplier;
                    --this.inventory[3].a;
                    if (this.inventory[3].a == 0) {
                        this.inventory[3] = null;
                    }
                }
            } else {
                this.upgradeTicks = 0;
            }
        } else {
            this.upgradeTicks = 0;
        }
        if (this.electricityStored >= this.ENERGY_PER_TICK) {
            if (this.canOperate() && this.operatingTicks + 1 < MekanismUtils.getTicks(this.speedMultiplier)) {
                ++this.operatingTicks;
                this.electricityStored -= this.ENERGY_PER_TICK;
            } else if (this.canOperate() && this.operatingTicks + 1 >= MekanismUtils.getTicks(this.speedMultiplier)) {
                if (!this.k.I) {
                    this.operate();
                }
                this.operatingTicks = 0;
                this.electricityStored -= this.ENERGY_PER_TICK;
            }
        }
        if (!this.canOperate()) {
            this.operatingTicks = 0;
        }
        if (!this.k.I) {
            if (this.canOperate() && this.electricityStored >= this.ENERGY_PER_TICK) {
                this.setActive(true);
            } else {
                this.setActive(false);
            }
        }
    }

    @Override
    public void operate() {
        ur itemstack = RecipeHandler.getOutput(this.inventory[0], true, this.getRecipes());
        if (this.inventory[0].a <= 0) {
            this.inventory[0] = null;
        }
        if (this.inventory[2] == null) {
            this.inventory[2] = itemstack;
        } else {
            this.inventory[2].a += itemstack.a;
        }
    }

    @Override
    public boolean canOperate() {
        if (this.inventory[0] == null) {
            return false;
        }
        ur itemstack = RecipeHandler.getOutput(this.inventory[0], false, this.getRecipes());
        if (itemstack == null) {
            return false;
        }
        if (this.inventory[2] == null) {
            return true;
        }
        if (!this.inventory[2].a(itemstack)) {
            return false;
        }
        return this.inventory[2].a + itemstack.a <= this.inventory[2].d();
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"getStored", "getProgress", "isActive", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded"};
    }

    @Override
    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.operatingTicks};
            }
            case 2: {
                return new Object[]{this.isActive};
            }
            case 3: {
                return new Object[]{this.facing};
            }
            case 4: {
                return new Object[]{this.canOperate()};
            }
            case 5: {
                return new Object[]{MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY)};
            }
            case 6: {
                return new Object[]{MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored};
            }
        }
        System.err.println("[Mekanism] Attempted to call unknown method with computer ID " + computer.getID());
        return new Object[]{"Unknown command."};
    }
}

