/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import buildcraft.api.power.IPowerProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerFramework;
import com.google.common.io.ByteArrayDataInput;
import ic2.api.IWrenchable;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyTile;
import java.util.ArrayList;
import mekanism.api.ITileNetwork;
import mekanism.common.Mekanism;
import mekanism.common.TileEntityContainerBlock;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public abstract class TileEntityElectricBlock
extends TileEntityContainerBlock
implements IWrenchable,
ISidedInventory,
la,
ITileNetwork,
IPowerReceptor,
IEnergyTile {
    public double electricityStored;
    public double MAX_ELECTRICITY;
    public IPowerProvider powerProvider;

    public TileEntityElectricBlock(String name, double maxEnergy) {
        super(name);
        this.MAX_ELECTRICITY = maxEnergy;
        if (PowerFramework.currentFramework != null) {
            this.powerProvider = PowerFramework.currentFramework.createPowerProvider();
            this.powerProvider.configure(0, 0, 100, 0, (int)(maxEnergy * Mekanism.TO_BC));
        }
    }

    @Override
    public void onUpdate() {
        if (!this.initialized && this.k != null) {
            if (Mekanism.hooks.IC2Loaded) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            }
            this.initialized = true;
        }
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        this.electricityStored = dataStream.readDouble();
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.electricityStored);
        return data;
    }

    public void w_() {
        super.w_();
        if (this.initialized && Mekanism.hooks.IC2Loaded) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
    }

    @Override
    public void a(bq nbtTags) {
        super.a(nbtTags);
        if (PowerFramework.currentFramework != null) {
            PowerFramework.currentFramework.loadPowerProvider(this, nbtTags);
        }
        this.electricityStored = nbtTags.h("electricityStored");
    }

    @Override
    public void b(bq nbtTags) {
        super.b(nbtTags);
        if (PowerFramework.currentFramework != null) {
            PowerFramework.currentFramework.savePowerProvider(this, nbtTags);
        }
        nbtTags.a("electricityStored", this.electricityStored);
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.initialized;
    }

    @Override
    public void setPowerProvider(IPowerProvider provider) {
        this.powerProvider = provider;
    }

    @Override
    public IPowerProvider getPowerProvider() {
        return this.powerProvider;
    }

    @Override
    public int powerRequest() {
        return (int)((this.MAX_ELECTRICITY - this.electricityStored) * Mekanism.TO_BC);
    }

    @Override
    public void doWork() {
    }
}

