/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computer.api.IComputerAccess;
import dan200.computer.api.IPeripheral;
import ic2.api.Direction;
import ic2.api.energy.tile.IEnergySink;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import mekanism.api.IActiveState;
import mekanism.api.IConfigurable;
import mekanism.api.IElectricMachine;
import mekanism.api.IUpgradeManagement;
import mekanism.api.SideData;
import mekanism.client.Sound;
import mekanism.common.Mekanism;
import mekanism.common.MekanismUtils;
import mekanism.common.PacketHandler;
import mekanism.common.TileEntityElectricBlock;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.electricity.ElectricityConnections;
import universalelectricity.core.implement.IConductor;
import universalelectricity.core.implement.IItemElectric;
import universalelectricity.core.implement.IJouleStorage;
import universalelectricity.core.implement.IVoltage;
import universalelectricity.core.vector.Vector3;

public abstract class TileEntityBasicMachine
extends TileEntityElectricBlock
implements IElectricMachine,
IEnergySink,
IJouleStorage,
IVoltage,
IPeripheral,
IActiveState,
IConfigurable,
IUpgradeManagement {
    @SideOnly(value=Side.CLIENT)
    public Sound audio;
    public byte[] sideConfig;
    public ArrayList sideOutputs = new ArrayList();
    public String soundURL;
    public double ENERGY_PER_TICK;
    public int operatingTicks = 0;
    public int TICKS_REQUIRED;
    public int speedMultiplier;
    public int energyMultiplier;
    public int UPGRADE_TICKS_REQUIRED = 40;
    public int upgradeTicks;
    public boolean isActive;
    public boolean prevActive;
    public boolean registered;
    public String guiTexturePath;

    public TileEntityBasicMachine(String soundPath, String name, String path, int perTick, int ticksRequired, int maxEnergy) {
        super(name, maxEnergy);
        ElectricityConnections.registerConnector(this, EnumSet.allOf(ForgeDirection.class));
        this.ENERGY_PER_TICK = perTick;
        this.TICKS_REQUIRED = ticksRequired;
        this.soundURL = soundPath;
        this.guiTexturePath = path;
        this.isActive = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUpdate() {
        block11: {
            super.onUpdate();
            if (this.powerProvider != null) {
                int received = (int)((double)this.powerProvider.useEnergy(0.0f, (float)((MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored) * Mekanism.TO_BC), true) * Mekanism.FROM_BC);
                this.setJoules(this.electricityStored + (double)received, new Object[0]);
            }
            if (!this.registered && this.k != null && !this.k.I) {
                Mekanism.manager.register(this);
                this.registered = true;
            }
            if (!this.k.I) {
                for (ForgeDirection direction : ForgeDirection.values()) {
                    any tileEntity = Vector3.getTileEntityFromSide(this.k, new Vector3(this), direction);
                    if (tileEntity == null || !(tileEntity instanceof IConductor)) continue;
                    if (this.electricityStored < MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY)) {
                        double electricityNeeded = MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored;
                        ((IConductor)tileEntity).getNetwork().startRequesting(this, electricityNeeded, electricityNeeded >= this.getVoltage(new Object[0]) ? this.getVoltage(new Object[0]) : electricityNeeded);
                        this.setJoules(this.electricityStored + ((IConductor)tileEntity).getNetwork().consumeElectricity(this).getWatts(), new Object[0]);
                        continue;
                    }
                    if (!(this.electricityStored >= MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY))) continue;
                    ((IConductor)tileEntity).getNetwork().stopRequesting(this);
                }
            }
            if (this.k.I) {
                try {
                    if (Mekanism.audioHandler == null) break block11;
                    List arr$ = Mekanism.audioHandler.sounds;
                    synchronized (arr$) {
                        this.handleSound();
                    }
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public void handleSound() {
        if (Mekanism.audioHandler != null) {
            List list = Mekanism.audioHandler.sounds;
            synchronized (list) {
                if (this.audio == null && this.k != null && this.k.I) {
                    bev cfr_ignored_0 = FMLClientHandler.instance().getClient().A;
                    if (bev.a != null) {
                        this.audio = Mekanism.audioHandler.getSound(this.soundURL, this.k, this.l, this.m, this.n);
                    }
                }
                if (this.k != null && this.k.I && this.audio != null) {
                    if (!this.audio.isPlaying && this.isActive) {
                        this.audio.play();
                    } else if (this.audio.isPlaying && !this.isActive) {
                        this.audio.stopLoop();
                    }
                }
            }
        }
    }

    @Override
    public void a(bq nbtTags) {
        super.a(nbtTags);
        this.operatingTicks = nbtTags.e("operatingTicks");
        this.isActive = nbtTags.n("isActive");
        this.speedMultiplier = nbtTags.e("speedMultiplier");
        this.energyMultiplier = nbtTags.e("energyMultiplier");
        this.upgradeTicks = nbtTags.e("upgradeTicks");
        if (nbtTags.b("sideDataStored")) {
            for (int i = 0; i < 6; ++i) {
                this.sideConfig[i] = nbtTags.c("config" + i);
            }
        }
    }

    @Override
    public void b(bq nbtTags) {
        super.b(nbtTags);
        nbtTags.a("operatingTicks", this.operatingTicks);
        nbtTags.a("isActive", this.isActive);
        nbtTags.a("speedMultiplier", this.speedMultiplier);
        nbtTags.a("energyMultiplier", this.energyMultiplier);
        nbtTags.a("upgradeTicks", this.upgradeTicks);
        nbtTags.a("sideDataStored", true);
        for (int i = 0; i < 6; ++i) {
            nbtTags.a("config" + i, this.sideConfig[i]);
        }
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        this.operatingTicks = dataStream.readInt();
        this.isActive = dataStream.readBoolean();
        this.speedMultiplier = dataStream.readInt();
        this.energyMultiplier = dataStream.readInt();
        this.upgradeTicks = dataStream.readInt();
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.operatingTicks);
        data.add(this.isActive);
        data.add(this.speedMultiplier);
        data.add(this.energyMultiplier);
        data.add(this.upgradeTicks);
        return data;
    }

    @Override
    public void w_() {
        super.w_();
        if (!this.k.I && this.registered) {
            Mekanism.manager.remove(this);
            this.registered = false;
        }
        if (this.k.I && this.audio != null) {
            this.audio.remove();
        }
    }

    @Override
    public int getMaxSafeInput() {
        return 2048;
    }

    @Override
    public int demandsEnergy() {
        return (int)((MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored) * Mekanism.TO_IC2);
    }

    @Override
    public int injectEnergy(Direction direction, int i) {
        double givenEnergy = (double)i * Mekanism.FROM_IC2;
        double rejects = 0.0;
        double neededEnergy = MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored;
        if (givenEnergy <= neededEnergy) {
            this.electricityStored += givenEnergy;
        } else if (givenEnergy > neededEnergy) {
            this.electricityStored += neededEnergy;
            rejects = givenEnergy - neededEnergy;
        }
        return (int)(rejects * Mekanism.TO_IC2);
    }

    @Override
    public boolean acceptsEnergyFrom(any emitter, Direction direction) {
        return true;
    }

    @Override
    public int getStartInventorySide(ForgeDirection side) {
        return ((SideData)this.sideOutputs.get((int)this.sideConfig[MekanismUtils.getBaseOrientation((int)side.ordinal(), (int)this.facing)])).slotStart;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection side) {
        return ((SideData)this.sideOutputs.get((int)this.sideConfig[MekanismUtils.getBaseOrientation((int)side.ordinal(), (int)this.facing)])).slotAmount;
    }

    public int getScaledEnergyLevel(int i) {
        return (int)(this.electricityStored * (double)i / MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY));
    }

    public int getScaledProgress(int i) {
        return this.operatingTicks * i / MekanismUtils.getTicks(this.speedMultiplier);
    }

    public int getScaledUpgradeProgress(int i) {
        return this.upgradeTicks * i / this.UPGRADE_TICKS_REQUIRED;
    }

    @Override
    public double getMaxJoules(Object ... data) {
        return MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY);
    }

    @Override
    public double getJoules(Object ... data) {
        return this.electricityStored;
    }

    @Override
    public void setJoules(double joules, Object ... data) {
        this.electricityStored = Math.max(Math.min(joules, this.getMaxJoules(new Object[0])), 0.0);
    }

    @Override
    public double getVoltage(Object ... data) {
        return 120.0;
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.prevActive != active) {
            PacketHandler.sendTileEntityPacketToClients(this, 0.0, this.getNetworkedData(new ArrayList()));
        }
        this.prevActive = active;
    }

    @Override
    public String getType() {
        return this.b();
    }

    @Override
    public boolean canAttachToSide(int side) {
        return true;
    }

    @Override
    public boolean canSetFacing(int facing) {
        return facing != 0 && facing != 1;
    }

    @Override
    public void attach(IComputerAccess computer) {
    }

    @Override
    public void detach(IComputerAccess computer) {
    }

    @Override
    public int powerRequest() {
        return (int)((MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored) * Mekanism.TO_BC);
    }

    @Override
    public ArrayList getSideData() {
        return this.sideOutputs;
    }

    @Override
    public byte[] getConfiguration() {
        return this.sideConfig;
    }

    @Override
    public int getOrientation() {
        return this.facing;
    }

    @Override
    public int getEnergyMultiplier(Object ... data) {
        return this.energyMultiplier;
    }

    @Override
    public void setEnergyMultiplier(int multiplier, Object ... data) {
        this.energyMultiplier = multiplier;
    }

    @Override
    public int getSpeedMultiplier(Object ... data) {
        return this.speedMultiplier;
    }

    @Override
    public void setSpeedMultiplier(int multiplier, Object ... data) {
        this.speedMultiplier = multiplier;
    }

    @Override
    public ur getWrenchDrop(qx entityPlayer) {
        ur itemStack = new ur(Mekanism.EnergyCube);
        IItemElectric electricItem = (IItemElectric)itemStack.b();
        electricItem.setJoules(this.electricityStored, itemStack);
        return itemStack;
    }
}

