/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import com.google.common.io.ByteArrayDataInput;
import dan200.computer.api.IComputerAccess;
import ic2.api.ElectricItem;
import ic2.api.IElectricItem;
import java.util.ArrayList;
import mekanism.api.EnumColor;
import mekanism.api.SideData;
import mekanism.common.Mekanism;
import mekanism.common.MekanismUtils;
import mekanism.common.RecipeHandler;
import mekanism.common.TileEntityBasicMachine;
import universalelectricity.core.implement.IItemElectric;

public abstract class TileEntityAdvancedElectricMachine
extends TileEntityBasicMachine {
    public int SECONDARY_ENERGY_PER_TICK;
    public int MAX_SECONDARY_ENERGY;
    public int secondaryEnergyStored = 0;

    public TileEntityAdvancedElectricMachine(String soundPath, String name, String path, int perTick, int secondaryPerTick, int ticksRequired, int maxEnergy, int maxSecondaryEnergy) {
        super(soundPath, name, path, perTick, ticksRequired, maxEnergy);
        this.sideOutputs.add(new SideData(EnumColor.GREY, 0, 0));
        this.sideOutputs.add(new SideData(EnumColor.DARK_RED, 0, 1));
        this.sideOutputs.add(new SideData(EnumColor.PURPLE, 1, 1));
        this.sideOutputs.add(new SideData(EnumColor.DARK_BLUE, 2, 1));
        this.sideOutputs.add(new SideData(EnumColor.DARK_GREEN, 3, 1));
        this.sideOutputs.add(new SideData(EnumColor.ORANGE, 4, 1));
        this.sideConfig = new byte[]{2, 1, 0, 4, 5, 3};
        this.inventory = new ur[5];
        this.SECONDARY_ENERGY_PER_TICK = secondaryPerTick;
        this.MAX_SECONDARY_ENERGY = maxSecondaryEnergy;
    }

    public abstract int getFuelTicks(ur var1);

    @Override
    public void onUpdate() {
        boolean testActive;
        super.onUpdate();
        boolean bl = testActive = this.operatingTicks > 0;
        if (this.inventory[3] != null) {
            if (this.electricityStored < MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY)) {
                IElectricItem item;
                if (this.inventory[3].b() instanceof IItemElectric) {
                    IItemElectric electricItem = (IItemElectric)this.inventory[3].b();
                    if (electricItem.canProduceElectricity()) {
                        double joulesNeeded = MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored;
                        double joulesReceived = electricItem.onUse(Math.min(electricItem.getMaxJoules(this.inventory[3]) * 0.005, joulesNeeded), this.inventory[3]);
                        this.setJoules(this.electricityStored + joulesReceived, new Object[0]);
                    }
                } else if (this.inventory[3].b() instanceof IElectricItem && (item = (IElectricItem)this.inventory[3].b()).canProvideEnergy()) {
                    double gain = (double)ElectricItem.discharge(this.inventory[3], (int)((this.MAX_ELECTRICITY - this.electricityStored) * Mekanism.TO_IC2), 3, false, false) * Mekanism.FROM_IC2;
                    this.setJoules(this.electricityStored + gain, new Object[0]);
                }
            }
            if (this.inventory[3].c == up.aC.cj && this.electricityStored + 1000.0 <= MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY)) {
                this.setJoules(this.electricityStored + 1000.0, new Object[0]);
                --this.inventory[3].a;
                if (this.inventory[3].a <= 0) {
                    this.inventory[3] = null;
                }
            }
        }
        if (this.inventory[4] != null) {
            if (this.inventory[4].a(new ur(Mekanism.EnergyUpgrade)) && this.energyMultiplier < 8) {
                if (this.upgradeTicks < this.UPGRADE_TICKS_REQUIRED) {
                    ++this.upgradeTicks;
                } else if (this.upgradeTicks == this.UPGRADE_TICKS_REQUIRED) {
                    this.upgradeTicks = 0;
                    ++this.energyMultiplier;
                    --this.inventory[4].a;
                    if (this.inventory[4].a == 0) {
                        this.inventory[4] = null;
                    }
                }
            } else if (this.inventory[4].a(new ur(Mekanism.SpeedUpgrade)) && this.speedMultiplier < 8) {
                if (this.upgradeTicks < this.UPGRADE_TICKS_REQUIRED) {
                    ++this.upgradeTicks;
                } else if (this.upgradeTicks == this.UPGRADE_TICKS_REQUIRED) {
                    this.upgradeTicks = 0;
                    ++this.speedMultiplier;
                    --this.inventory[4].a;
                    if (this.inventory[4].a == 0) {
                        this.inventory[4] = null;
                    }
                }
            } else {
                this.upgradeTicks = 0;
            }
        } else {
            this.upgradeTicks = 0;
        }
        this.handleSecondaryFuel();
        if (this.electricityStored >= this.ENERGY_PER_TICK && this.secondaryEnergyStored >= this.SECONDARY_ENERGY_PER_TICK) {
            if (this.canOperate() && this.operatingTicks + 1 < MekanismUtils.getTicks(this.speedMultiplier) && this.secondaryEnergyStored >= this.SECONDARY_ENERGY_PER_TICK) {
                ++this.operatingTicks;
                this.secondaryEnergyStored -= this.SECONDARY_ENERGY_PER_TICK;
                this.electricityStored -= this.ENERGY_PER_TICK;
            } else if (this.operatingTicks + 1 >= MekanismUtils.getTicks(this.speedMultiplier)) {
                if (!this.k.I) {
                    this.operate();
                }
                this.operatingTicks = 0;
                this.secondaryEnergyStored -= this.SECONDARY_ENERGY_PER_TICK;
                this.electricityStored -= this.ENERGY_PER_TICK;
            }
        }
        if (!this.canOperate()) {
            this.operatingTicks = 0;
        }
        if (!this.k.I) {
            if (this.canOperate() && this.electricityStored >= this.ENERGY_PER_TICK && this.secondaryEnergyStored >= this.SECONDARY_ENERGY_PER_TICK) {
                this.setActive(true);
            } else {
                this.setActive(false);
            }
        }
    }

    public void handleSecondaryFuel() {
        if (this.inventory[1] != null) {
            int fuelTicks = this.getFuelTicks(this.inventory[1]);
            int energyNeeded = this.MAX_SECONDARY_ENERGY - this.secondaryEnergyStored;
            if (fuelTicks > 0 && fuelTicks <= energyNeeded) {
                if (fuelTicks <= energyNeeded) {
                    this.setSecondaryEnergy(this.secondaryEnergyStored + fuelTicks);
                } else if (fuelTicks > energyNeeded) {
                    this.setSecondaryEnergy(this.secondaryEnergyStored + energyNeeded);
                }
                --this.inventory[1].a;
                if (this.inventory[1].a == 0) {
                    this.inventory[1] = null;
                }
            }
        }
    }

    @Override
    public void operate() {
        ur itemstack = RecipeHandler.getOutput(this.inventory[0], true, this.getRecipes());
        if (this.inventory[0].a <= 0) {
            this.inventory[0] = null;
        }
        if (this.inventory[2] == null) {
            this.inventory[2] = itemstack;
        } else {
            this.inventory[2].a += itemstack.a;
        }
    }

    @Override
    public boolean canOperate() {
        if (this.inventory[0] == null) {
            return false;
        }
        ur itemstack = RecipeHandler.getOutput(this.inventory[0], false, this.getRecipes());
        if (itemstack == null) {
            return false;
        }
        if (this.inventory[2] == null) {
            return true;
        }
        if (!this.inventory[2].a(itemstack)) {
            return false;
        }
        return this.inventory[2].a + itemstack.a <= this.inventory[2].d();
    }

    @Override
    public void handlePacketData(ByteArrayDataInput dataStream) {
        super.handlePacketData(dataStream);
        this.secondaryEnergyStored = dataStream.readInt();
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.secondaryEnergyStored);
        return data;
    }

    @Override
    public void a(bq nbtTags) {
        super.a(nbtTags);
        this.secondaryEnergyStored = nbtTags.e("secondaryEnergyStored");
    }

    @Override
    public void b(bq nbtTags) {
        super.b(nbtTags);
        nbtTags.a("secondaryEnergyStored", this.secondaryEnergyStored);
    }

    public void setSecondaryEnergy(int energy) {
        this.secondaryEnergyStored = Math.max(Math.min(energy, this.MAX_SECONDARY_ENERGY), 0);
    }

    public int getScaledSecondaryEnergyLevel(int i) {
        return this.secondaryEnergyStored * i / this.MAX_SECONDARY_ENERGY;
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"getStored", "getSecondaryStored", "getProgress", "isActive", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded"};
    }

    @Override
    public Object[] callMethod(IComputerAccess computer, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.electricityStored};
            }
            case 1: {
                return new Object[]{this.secondaryEnergyStored};
            }
            case 2: {
                return new Object[]{this.operatingTicks};
            }
            case 3: {
                return new Object[]{this.isActive};
            }
            case 4: {
                return new Object[]{this.facing};
            }
            case 5: {
                return new Object[]{this.canOperate()};
            }
            case 6: {
                return new Object[]{MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY)};
            }
            case 7: {
                return new Object[]{MekanismUtils.getEnergy(this.energyMultiplier, this.MAX_ELECTRICITY) - this.electricityStored};
            }
        }
        System.err.println("[Mekanism] Attempted to call unknown method with computer ID " + computer.getID());
        return new Object[]{"Unknown command."};
    }
}

