/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import mekanism.api.ITileNetwork;
import mekanism.common.EnumPacketType;
import mekanism.common.EnumWeatherType;
import mekanism.common.ItemPortableTeleporter;
import mekanism.common.Mekanism;
import mekanism.common.MekanismUtils;
import mekanism.common.Teleporter;

public class PacketHandler
implements IPacketHandler {
    public void onPacketData(ce manager, di packet, Player player) {
        block38: {
            ByteArrayDataInput dataStream = ByteStreams.newDataInput((byte[])packet.c);
            qx entityplayer = (qx)player;
            if (packet.a.equals("Mekanism")) {
                try {
                    int packetType = dataStream.readInt();
                    if (packetType == EnumPacketType.TIME.id) {
                        System.out.println("[Mekanism] Received time update packet from " + entityplayer.bR + ".");
                        entityplayer.bS().a(4999, (md)entityplayer);
                        MekanismUtils.setHourForward(entityplayer.p, dataStream.readInt());
                    }
                    if (packetType == EnumPacketType.WEATHER.id) {
                        System.out.println("[Mekanism] Received weather update packet from " + entityplayer.bR + ".");
                        entityplayer.bS().a(4999, (md)entityplayer);
                        int weatherType = dataStream.readInt();
                        if (weatherType == EnumWeatherType.CLEAR.id) {
                            entityplayer.p.K().b(false);
                            entityplayer.p.K().a(false);
                        }
                        if (weatherType == EnumWeatherType.HAZE.id) {
                            entityplayer.p.K().b(true);
                            entityplayer.p.K().a(true);
                        }
                        if (weatherType == EnumWeatherType.RAIN.id) {
                            entityplayer.p.K().b(true);
                        }
                        if (weatherType == EnumWeatherType.STORM.id) {
                            entityplayer.p.K().a(true);
                        }
                    }
                    if (packetType == EnumPacketType.TILE_ENTITY.id) {
                        try {
                            int x = dataStream.readInt();
                            int y2 = dataStream.readInt();
                            int z = dataStream.readInt();
                            yc world = entityplayer.p;
                            any tileEntity = world.q(x, y2, z);
                            if (tileEntity instanceof ITileNetwork) {
                                ((ITileNetwork)tileEntity).handlePacketData(dataStream);
                            }
                        }
                        catch (Exception e) {
                            System.err.println("[Mekanism] Error while handling tile entity packet.");
                            e.printStackTrace();
                        }
                    }
                    if (packetType == EnumPacketType.CONTROL_PANEL.id) {
                        try {
                            String modClass = dataStream.readUTF();
                            String modInstance = dataStream.readUTF();
                            int x = dataStream.readInt();
                            int y3 = dataStream.readInt();
                            int z = dataStream.readInt();
                            int guiId = dataStream.readInt();
                            Class<?> mod = Class.forName(modClass);
                            if (mod == null) {
                                System.err.println("[Mekanism] Incorrectly implemented IAccessibleGui -- ignoring handler packet.");
                                System.err.println(" ~ Unable to locate class '" + modClass + ".'");
                                System.err.println(" ~ GUI Container may not function correctly.");
                                return;
                            }
                            Object instance = mod.getField(modInstance).get(null);
                            if (instance == null) {
                                System.err.println("[Mekanism] Incorrectly implemented IAccessibleGui -- ignoring handler packet.");
                                System.err.println(" ~ Unable to locate instance object '" + modInstance + ".'");
                                System.err.println(" ~ GUI Container may not function correctly.");
                                return;
                            }
                            entityplayer.openGui(instance, guiId, entityplayer.p, x, y3, z);
                        }
                        catch (Exception e) {
                            System.err.println("[Mekanism] Error while handling control panel packet.");
                            e.printStackTrace();
                        }
                    }
                    if (packetType == EnumPacketType.PORTAL_FX.id) {
                        try {
                            Random random = new Random();
                            int x = dataStream.readInt();
                            int y4 = dataStream.readInt();
                            int z = dataStream.readInt();
                            for (int i = 0; i < 50; ++i) {
                                entityplayer.p.a("portal", (double)((float)x + random.nextFloat()), (double)((float)y4 + random.nextFloat()), (double)((float)z + random.nextFloat()), 0.0, 0.0, 0.0);
                                entityplayer.p.a("portal", (double)((float)x + random.nextFloat()), (double)((float)(y4 + 1) + random.nextFloat()), (double)((float)z + random.nextFloat()), 0.0, 0.0, 0.0);
                            }
                        }
                        catch (Exception e) {
                            System.err.println("[Mekanism] Error while handling portal FX packet.");
                            e.printStackTrace();
                        }
                    }
                    if (packetType == EnumPacketType.DIGIT_UPDATE.id) {
                        try {
                            int index = dataStream.readInt();
                            int digit = dataStream.readInt();
                            ur currentStack = entityplayer.bS();
                            if (currentStack != null && currentStack.b() instanceof ItemPortableTeleporter) {
                                ItemPortableTeleporter item = (ItemPortableTeleporter)currentStack.b();
                                item.setDigit(currentStack, index, digit);
                            }
                        }
                        catch (Exception e) {
                            System.err.println("[Mekanism] Error while handling digit update packet.");
                            e.printStackTrace();
                        }
                    }
                    if (packetType == EnumPacketType.STATUS_UPDATE.id) {
                        try {
                            ur currentStack = entityplayer.bS();
                            if (currentStack != null && currentStack.b() instanceof ItemPortableTeleporter) {
                                ItemPortableTeleporter item = (ItemPortableTeleporter)currentStack.b();
                                item.setStatus(currentStack, dataStream.readInt());
                            }
                        }
                        catch (Exception e) {
                            System.err.println("[Mekanism] Error while handling status update packet.");
                            e.printStackTrace();
                        }
                    }
                    if (packetType == EnumPacketType.PORTABLE_TELEPORT.id) {
                        try {
                            ItemPortableTeleporter item;
                            iq entityPlayerMP;
                            ur itemstack;
                            if (entityplayer instanceof iq && (itemstack = (entityPlayerMP = (iq)entityplayer).bS()) != null && itemstack.b() instanceof ItemPortableTeleporter && (item = (ItemPortableTeleporter)itemstack.b()).getStatus(itemstack) == 1) {
                                Teleporter.Coords coords = (Teleporter.Coords)((ArrayList)Mekanism.teleporters.get(new Teleporter.Code(item.getDigit(itemstack, 0), item.getDigit(itemstack, 1), item.getDigit(itemstack, 2), item.getDigit(itemstack, 3)))).get(0);
                                item.onUse(item.calculateEnergyCost((lq)entityPlayerMP, coords), itemstack);
                                if (entityPlayerMP.p.u.h != coords.dimensionId) {
                                    entityPlayerMP.b(coords.dimensionId);
                                }
                                entityPlayerMP.a.a((double)coords.xCoord + 0.5, (double)coords.yCoord, (double)coords.zCoord + 0.5, entityPlayerMP.z, entityPlayerMP.A);
                                entityplayer.p.a((lq)entityplayer, "mob.endermen.portal", 1.0f, 1.0f);
                                PacketHandler.sendPortalFX(coords.xCoord, coords.yCoord, coords.zCoord, coords.dimensionId);
                            }
                        }
                        catch (Exception e) {
                            System.err.println("[Mekanism] Error while handling portable teleport packet.");
                            e.printStackTrace();
                        }
                    }
                    if (packetType != EnumPacketType.DATA_REQUEST.id) break block38;
                    try {
                        int x = dataStream.readInt();
                        int y5 = dataStream.readInt();
                        int z = dataStream.readInt();
                        int id = dataStream.readInt();
                        in world = FMLCommonHandler.instance().getMinecraftServerInstance().a(id);
                        if (world != null && world.q(x, y5, z) instanceof ITileNetwork) {
                            PacketHandler.sendTileEntityPacketToClients(world.q(x, y5, z), 0.0, ((ITileNetwork)world.q(x, y5, z)).getNetworkedData(new ArrayList()));
                        }
                    }
                    catch (Exception e) {
                        System.err.println("[Mekanism] Error while handling data request packet.");
                        e.printStackTrace();
                    }
                }
                catch (Exception e) {
                    System.err.println("[Mekanism] Error while handling packet.");
                    e.printStackTrace();
                }
            }
        }
    }

    public static void sendTileEntityPacketToServer(any sender, ArrayList dataValues) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(bytes);
        try {
            output.writeInt(EnumPacketType.TILE_ENTITY.id);
            output.writeInt(sender.l);
            output.writeInt(sender.m);
            output.writeInt(sender.n);
            for (Object data : dataValues) {
                if (data instanceof Integer) {
                    output.writeInt((Integer)data);
                    continue;
                }
                if (data instanceof Boolean) {
                    output.writeBoolean((Boolean)data);
                    continue;
                }
                if (data instanceof Double) {
                    output.writeDouble((Double)data);
                    continue;
                }
                if (data instanceof Float) {
                    output.writeFloat(((Float)data).floatValue());
                    continue;
                }
                if (data instanceof String) {
                    output.writeUTF((String)data);
                    continue;
                }
                if (data instanceof Byte) {
                    output.writeByte(((Byte)data).byteValue());
                    continue;
                }
                if (!(data instanceof int[])) continue;
                for (int i : (int[])data) {
                    output.writeInt(i);
                }
            }
            di packet = new di();
            packet.a = "Mekanism";
            packet.c = bytes.toByteArray();
            packet.b = packet.c.length;
            PacketDispatcher.sendPacketToServer((ef)packet);
        }
        catch (IOException e) {
            System.err.println("[Mekanism] Error while writing tile entity packet.");
            e.printStackTrace();
        }
    }

    public static void sendTileEntityPacketToClients(any sender, double distance, ArrayList dataValues) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream output = new DataOutputStream(bytes);
        try {
            output.writeInt(EnumPacketType.TILE_ENTITY.id);
            output.writeInt(sender.l);
            output.writeInt(sender.m);
            output.writeInt(sender.n);
            for (Object data : dataValues) {
                if (data instanceof Integer) {
                    output.writeInt((Integer)data);
                    continue;
                }
                if (data instanceof Boolean) {
                    output.writeBoolean((Boolean)data);
                    continue;
                }
                if (data instanceof Double) {
                    output.writeDouble((Double)data);
                    continue;
                }
                if (data instanceof Float) {
                    output.writeFloat(((Float)data).floatValue());
                    continue;
                }
                if (data instanceof String) {
                    output.writeUTF((String)data);
                    continue;
                }
                if (data instanceof Byte) {
                    output.writeByte(((Byte)data).byteValue());
                    continue;
                }
                if (!(data instanceof int[])) continue;
                for (int i : (int[])data) {
                    output.writeInt(i);
                }
            }
            di packet = new di();
            packet.a = "Mekanism";
            packet.c = bytes.toByteArray();
            packet.b = packet.c.length;
            if (distance == 0.0) {
                PacketDispatcher.sendPacketToAllPlayers((ef)packet);
            } else {
                PacketDispatcher.sendPacketToAllAround((double)sender.l, (double)sender.m, (double)sender.n, (double)distance, (int)sender.k.u.h, (ef)packet);
            }
        }
        catch (IOException e) {
            System.err.println("[Mekanism] Error while writing tile entity packet.");
            e.printStackTrace();
        }
    }

    public static void sendGuiRequest(String modClass, String modInstance, int x, int y2, int z, int guiId) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeInt(EnumPacketType.CONTROL_PANEL.id);
            data.writeUTF(modClass);
            data.writeUTF(modInstance);
            data.writeInt(x);
            data.writeInt(y2);
            data.writeInt(z);
            data.writeInt(guiId);
        }
        catch (IOException e) {
            System.out.println("[Mekanism] An error occured while writing packet data.");
            e.printStackTrace();
        }
        di packet = new di();
        packet.a = "Mekanism";
        packet.c = bytes.toByteArray();
        packet.b = packet.c.length;
        PacketDispatcher.sendPacketToServer((ef)packet);
        System.out.println("[Mekanism] Sent control panel packet to server.");
    }

    public static void sendPortalFX(int x, int y2, int z, int id) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeInt(EnumPacketType.PORTAL_FX.id);
            data.writeInt(x);
            data.writeInt(y2);
            data.writeInt(z);
        }
        catch (IOException e) {
            System.out.println("[Mekanism] An error occured while writing packet data.");
            e.printStackTrace();
        }
        di packet = new di();
        packet.a = "Mekanism";
        packet.c = bytes.toByteArray();
        packet.b = packet.c.length;
        PacketDispatcher.sendPacketToAllAround((double)x, (double)y2, (double)z, (double)40.0, (int)id, (ef)packet);
        System.out.println("[Mekanism] Sent portal FX packet to clients.");
    }

    public static void sendDigitUpdate(int index, int digit) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeInt(EnumPacketType.DIGIT_UPDATE.id);
            data.writeInt(index);
            data.writeInt(digit);
        }
        catch (IOException e) {
            System.out.println("[Mekanism] An error occured while writing packet data.");
            e.printStackTrace();
        }
        di packet = new di();
        packet.a = "Mekanism";
        packet.c = bytes.toByteArray();
        packet.b = packet.c.length;
        PacketDispatcher.sendPacketToServer((ef)packet);
    }

    public static void sendStatusUpdate(qx entityplayer, int status) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeInt(EnumPacketType.STATUS_UPDATE.id);
            data.writeInt(status);
        }
        catch (IOException e) {
            System.out.println("[Mekanism] An error occured while writing packet data.");
            e.printStackTrace();
        }
        di packet = new di();
        packet.a = "Mekanism";
        packet.c = bytes.toByteArray();
        packet.b = packet.c.length;
        PacketDispatcher.sendPacketToPlayer((ef)packet, (Player)((Player)entityplayer));
    }

    public static void sendPacketDataInt(EnumPacketType type, int i) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeInt(type.id);
            data.writeInt(i);
        }
        catch (IOException e) {
            System.out.println("[Mekanism] An error occured while writing packet data.");
            e.printStackTrace();
        }
        di packet = new di();
        packet.a = "Mekanism";
        packet.c = bytes.toByteArray();
        packet.b = packet.c.length;
        PacketDispatcher.sendPacketToServer((ef)packet);
        System.out.println("[Mekanism] Sent data int packet '" + type.id + ":" + i + "' to server");
    }

    public static void sendDataRequest(any tileEntity) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeInt(EnumPacketType.DATA_REQUEST.id);
            data.writeInt(tileEntity.l);
            data.writeInt(tileEntity.m);
            data.writeInt(tileEntity.n);
            data.writeInt(tileEntity.k.u.h);
        }
        catch (IOException e) {
            System.out.println("[Mekanism] An error occured while writing packet data.");
            e.printStackTrace();
        }
        di packet = new di();
        packet.a = "Mekanism";
        packet.c = bytes.toByteArray();
        packet.b = packet.c.length;
        PacketDispatcher.sendPacketToServer((ef)packet);
    }
}

