/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.server.FMLServerHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import mekanism.api.EnumColor;
import mekanism.api.IActiveState;
import mekanism.api.IConfigurable;
import mekanism.api.InfuseObject;
import mekanism.api.Tier;
import mekanism.common.ItemBlockEnergyCube;
import mekanism.common.Mekanism;
import mekanism.common.TileEntityBoundingBlock;
import mekanism.common.Version;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public final class MekanismUtils {
    public static void checkForUpdates(qx entityplayer) {
        if (Mekanism.updateNotifications) {
            if (!Mekanism.latestVersionNumber.equals("null")) {
                if (Version.get(Mekanism.latestVersionNumber).comparedState(Mekanism.versionNumber) == 1) {
                    entityplayer.b((Object)((Object)EnumColor.GREY) + "------------- " + (Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism]" + (Object)((Object)EnumColor.GREY) + " -------------");
                    entityplayer.b((Object)((Object)EnumColor.GREY) + " Using outdated version " + (Object)((Object)EnumColor.DARK_GREY) + Mekanism.versionNumber + (Object)((Object)EnumColor.GREY) + " for Minecraft 1.4.6/7.");
                    entityplayer.b((Object)((Object)EnumColor.GREY) + " Consider updating to version " + (Object)((Object)EnumColor.DARK_GREY) + Mekanism.latestVersionNumber);
                    entityplayer.b((Object)((Object)EnumColor.GREY) + " New features: " + (Object)((Object)EnumColor.INDIGO) + Mekanism.recentNews);
                    entityplayer.b((Object)((Object)EnumColor.GREY) + "------------- " + (Object)((Object)EnumColor.DARK_BLUE) + "[=======]" + (Object)((Object)EnumColor.GREY) + " -------------");
                    return;
                }
                if (Version.get(Mekanism.latestVersionNumber).comparedState(Mekanism.versionNumber) == -1) {
                    entityplayer.b((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.GREY) + "Using developer build " + (Object)((Object)EnumColor.DARK_GREY) + Mekanism.versionNumber);
                }
            } else {
                System.out.println("[Mekanism] Minecraft is in offline mode, could not check for updates.");
                return;
            }
        }
    }

    public static String getLatestVersion() {
        String[] text = MekanismUtils.getHTML("http://dl.dropbox.com/u/90411166/Mod%20Versions/Mekanism.txt").split(":");
        if (!(text[0].contains("UTF-8") || text[0].contains("HTML") || text[0].contains("http"))) {
            return text[0];
        }
        return "null";
    }

    public static String getRecentNews() {
        String[] text = MekanismUtils.getHTML("http://dl.dropbox.com/u/90411166/Mod%20Versions/Mekanism.txt").split(":");
        if (!(text.length <= 1 || text[1].contains("UTF-8") || text[1].contains("HTML") || text[1].contains("http"))) {
            return text[1];
        }
        return "null";
    }

    public static String getHTML(String urlToRead) {
        StringBuilder sb = new StringBuilder();
        String result = "";
        try {
            String line;
            URL url = new URL(urlToRead);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = rd.readLine()) != null) {
                result = result + line;
                sb.append(line);
            }
            rd.close();
        }
        catch (Exception e) {
            result = "null";
            System.err.println("[Mekanism] An error occured while connecting to URL '" + urlToRead + ".'");
        }
        return result;
    }

    public static void sendChatMessageToPlayer(String playerUsername, String msg) {
        iq player = FMLServerHandler.instance().getServer().ad().f(playerUsername);
        cu chatPacket = new cu(msg);
        if (player != null) {
            player.a.b((ef)chatPacket);
        }
    }

    public static void sendChatMessageToAllPlayers(String msg) {
        PacketDispatcher.sendPacketToAllPlayers((ef)new cu(msg));
    }

    public static boolean isNotOutdated() {
        return Mekanism.latestVersionNumber.contains("null") || Mekanism.versionNumber.comparedState(Version.get(Mekanism.latestVersionNumber)) != -1;
    }

    public static boolean isOffline() {
        try {
            new URL("http://www.apple.com").openConnection().connect();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void setHourForward(yc world, int paramInt) {
        long l1 = world.G() / 24000L * 24000L;
        long l2 = l1 + 24000L + (long)(paramInt * 1000);
        world.b(l2);
    }

    public static void doFakeEntityExplosion(qx entityplayer) {
        yc world = entityplayer.p;
        world.a("hugeexplosion", entityplayer.t, entityplayer.u, entityplayer.v, 0.0, 0.0, 0.0);
        world.a((lq)entityplayer, "random.explode", 1.0f, 1.0f);
    }

    public static void doFakeBlockExplosion(yc world, int x, int y2, int z) {
        world.a("hugeexplosion", (double)x, (double)y2, (double)z, 0.0, 0.0, 0.0);
        world.a((double)x, (double)y2, (double)z, "random.explode", 1.0f, 1.0f, true);
    }

    public static ur getStackWithSize(ur itemstack, int size) {
        ur newStack = itemstack.l();
        newStack.a = size;
        return newStack;
    }

    public static void addRecipe(ur output, Object[] params) {
        wn.a().b().add(new ShapedOreRecipe(output, params));
    }

    public static ur getEnergyCubeWithTier(Tier.EnergyCubeTier tier) {
        ur itemstack = ((ItemBlockEnergyCube)new ur(Mekanism.EnergyCube).b()).getUnchargedItem(tier);
        return itemstack;
    }

    public static boolean isActive(ym world, int x, int y2, int z) {
        any tileEntity = world.q(x, y2, z);
        if (tileEntity != null && tileEntity instanceof IActiveState) {
            return ((IActiveState)tileEntity).getActive();
        }
        return false;
    }

    public static ForgeDirection getLeft(int orientation) {
        switch (orientation) {
            case 2: {
                return ForgeDirection.EAST;
            }
            case 3: {
                return ForgeDirection.WEST;
            }
            case 4: {
                return ForgeDirection.SOUTH;
            }
        }
        return ForgeDirection.NORTH;
    }

    public static ForgeDirection getRight(int orientation) {
        return MekanismUtils.getLeft(orientation).getOpposite();
    }

    public static boolean oreDictCheck(ur check, String oreDict) {
        boolean hasResource = false;
        for (ur ore : OreDictionary.getOres((String)oreDict)) {
            if (!ore.a(check)) continue;
            hasResource = true;
        }
        return hasResource;
    }

    public static int getBaseOrientation(int side, int blockFacing) {
        if (blockFacing == 3 || side == 1 || side == 0) {
            if (side == 2 || side == 3) {
                return ForgeDirection.getOrientation((int)side).getOpposite().ordinal();
            }
            return side;
        }
        if (blockFacing == 2) {
            if (side == 2 || side == 3) {
                return side;
            }
            return ForgeDirection.getOrientation((int)side).getOpposite().ordinal();
        }
        if (blockFacing == 4) {
            return MekanismUtils.getRight(side).ordinal();
        }
        if (blockFacing == 5) {
            return MekanismUtils.getLeft(side).ordinal();
        }
        return side;
    }

    public static void incrementOutput(IConfigurable config, int side) {
        int max = config.getSideData().size() - 1;
        int current = config.getSideData().indexOf(config.getSideData().get(config.getConfiguration()[side]));
        if (current < max) {
            config.getConfiguration()[side] = (byte)(current + 1);
        } else if (current == max) {
            config.getConfiguration()[side] = 0;
        }
    }

    public static InfuseObject getInfuseObject(ur itemStack) {
        if (itemStack != null) {
            for (Map.Entry entry : Mekanism.infusions.entrySet()) {
                if (!itemStack.a((ur)entry.getKey())) continue;
                return (InfuseObject)entry.getValue();
            }
        }
        return null;
    }

    public static int getTicks(int multiplier) {
        return 200 / (multiplier + 1);
    }

    public static double getEnergy(int multiplier, double def) {
        return def * (double)(multiplier + 1);
    }

    public static void makeBoundingBlock(yc world, int x, int y2, int z, int origX, int origY, int origZ) {
        world.e(x, y2, z, Mekanism.BoundingBlock.cm);
        ((TileEntityBoundingBlock)world.q(x, y2, z)).setMainLocation(origX, origY, origZ);
    }
}

