/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import java.util.ArrayList;
import java.util.List;
import mekanism.common.MekanismUtils;
import mekanism.common.TileEntityBasicMachine;

public class MachineryManager {
    public List machines = new ArrayList();

    public MachineryManager() {
        this.reset();
        System.out.println("[Mekanism] Successfully initialized Machinery Manager.");
    }

    public void register(TileEntityBasicMachine machine) {
        if (!this.machines.contains(machine)) {
            this.machines.add(machine);
        } else {
            System.out.println("[Mekanism] Attempted to add machine to manager that already exists.");
        }
    }

    public void remove(TileEntityBasicMachine machine) {
        if (this.machines.contains(machine)) {
            this.machines.remove(machine);
        } else {
            System.out.println("[Mekanism] Attempted to remove machine from manager that doesn't exist.");
        }
    }

    public TileEntityBasicMachine getMachine(yc world, int x, int y, int z) {
        if (this.machines.contains((TileEntityBasicMachine)world.q(x, y, z))) {
            return (TileEntityBasicMachine)world.q(x, y, z);
        }
        System.out.println("[Mekanism] Attempted to grab machine from manager that doesn't exist.");
        return null;
    }

    public void destroyAll(boolean explode) {
        for (TileEntityBasicMachine machine : this.machines) {
            if (explode) {
                MekanismUtils.doFakeBlockExplosion(machine.k, machine.l, machine.m, machine.n);
            }
            machine.k.d(machine.l, machine.m, machine.n, 0, 0);
            machine.k.r(machine.l, machine.m, machine.n);
            this.remove(machine);
        }
    }

    public int size() {
        return this.machines.size();
    }

    public void reset() {
        this.machines.clear();
    }
}

