/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import java.util.List;
import mekanism.api.EnumGas;
import mekanism.api.IStorageTank;
import mekanism.common.ItemMekanism;
import mekanism.common.Mekanism;

public class ItemStorageTank
extends ItemMekanism
implements IStorageTank {
    public int MAX_GAS;
    public int TRANSFER_RATE;

    public ItemStorageTank(int id, int maxGas, int transferRate) {
        super(id);
        this.MAX_GAS = maxGas;
        this.TRANSFER_RATE = transferRate;
        this.d(1);
        this.e(100);
        this.setNoRepair();
        this.a(Mekanism.tabMekanism);
    }

    public void a(ur itemstack, qx entityplayer, List list, boolean flag) {
        int gas = this.getGas(itemstack);
        if (this.getGasType(itemstack) == EnumGas.NONE) {
            list.add("No gas stored.");
        } else {
            list.add("Stored " + this.getGasType((ur)itemstack).name + ": " + gas);
        }
    }

    public void d(ur itemstack, yc world, qx entityplayer) {
        itemstack = this.getEmptyItem();
    }

    public void a(ur itemstack, yc world, lq entity, int i, boolean flag) {
        ItemStorageTank item = (ItemStorageTank)itemstack.b();
        if (item.getGas(itemstack) == 0 && item.getGasType(itemstack) != EnumGas.NONE) {
            item.setGasType(itemstack, EnumGas.NONE);
        }
    }

    @Override
    public int getGas(ur itemstack) {
        if (itemstack.d == null) {
            return 0;
        }
        int stored = 0;
        if (itemstack.d.a("gas") != null) {
            stored = itemstack.d.e("gas");
        }
        itemstack.b((int)Math.abs((float)stored / (float)this.MAX_GAS * 100.0f - 100.0f));
        return stored;
    }

    @Override
    public void setGas(ur itemstack, EnumGas type, int amount) {
        if (itemstack.d == null) {
            itemstack.d(new bq());
        }
        if (this.getGasType(itemstack) == EnumGas.NONE) {
            this.setGasType(itemstack, type);
        }
        if (this.getGasType(itemstack) == type) {
            int stored = Math.max(Math.min(amount, this.MAX_GAS), 0);
            itemstack.d.a("gas", stored);
            itemstack.b((int)Math.abs((float)stored / (float)this.MAX_GAS * 100.0f - 100.0f));
        }
        if (this.getGas(itemstack) == 0) {
            this.setGasType(itemstack, EnumGas.NONE);
        }
    }

    public ur getEmptyItem() {
        ur empty = new ur((up)this);
        this.setGasType(empty, EnumGas.NONE);
        empty.b(100);
        return empty;
    }

    public void a(int i, tj tabs, List list) {
        ur empty = new ur((up)this);
        this.setGasType(empty, EnumGas.NONE);
        empty.b(100);
        list.add(empty);
        for (EnumGas type : EnumGas.values()) {
            if (type == EnumGas.NONE) continue;
            ur charged = new ur((up)this);
            this.setGasType(charged, type);
            this.setGas(charged, type, ((IStorageTank)charged.b()).getMaxGas());
            list.add(charged);
        }
    }

    @Override
    public int getMaxGas() {
        return this.MAX_GAS;
    }

    @Override
    public int getRate() {
        return this.TRANSFER_RATE;
    }

    @Override
    public int addGas(ur itemstack, EnumGas type, int amount) {
        if (this.getGasType(itemstack) == type || this.getGasType(itemstack) == EnumGas.NONE) {
            int rejects = Math.max(this.getGas(itemstack) + amount - this.MAX_GAS, 0);
            this.setGas(itemstack, type, this.getGas(itemstack) + amount - rejects);
            return rejects;
        }
        return amount;
    }

    @Override
    public int removeGas(ur itemstack, EnumGas type, int amount) {
        if (this.getGasType(itemstack) == type) {
            int gasToUse = Math.min(this.getGas(itemstack), amount);
            this.setGas(itemstack, type, this.getGas(itemstack) - gasToUse);
            return gasToUse;
        }
        return 0;
    }

    @Override
    public boolean canReceiveGas(ur itemstack, EnumGas type) {
        return this.getGasType(itemstack) == type || this.getGasType(itemstack) == EnumGas.NONE;
    }

    @Override
    public boolean canProvideGas(ur itemstack, EnumGas type) {
        return this.getGasType(itemstack) == type;
    }

    @Override
    public EnumGas getGasType(ur itemstack) {
        if (itemstack.d == null) {
            return EnumGas.NONE;
        }
        if (itemstack.d.i("type") == null) {
            return EnumGas.NONE;
        }
        return EnumGas.getFromName(itemstack.d.i("gasType"));
    }

    @Override
    public void setGasType(ur itemstack, EnumGas type) {
        if (itemstack.d == null) {
            itemstack.d(new bq());
        }
        itemstack.d.a("gasType", type.name);
    }
}

