/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import ic2.api.ICustomElectricItem;
import java.util.List;
import mekanism.common.ItemMekanism;
import mekanism.common.Mekanism;
import universalelectricity.core.electricity.ElectricInfo;
import universalelectricity.core.implement.IItemElectric;

public class ItemEnergized
extends ItemMekanism
implements IItemElectric,
ICustomElectricItem {
    public double MAX_ELECTRICITY;
    public double VOLTAGE;

    public ItemEnergized(int id, double maxElectricity, double voltage) {
        super(id);
        this.MAX_ELECTRICITY = maxElectricity;
        this.VOLTAGE = voltage;
        this.d(1);
        this.e(100);
        this.setNoRepair();
        this.a(Mekanism.tabMekanism);
    }

    public void a(ur itemstack, qx entityplayer, List list, boolean flag) {
        double energy = this.getJoules(itemstack);
        list.add("Stored Energy: " + ElectricInfo.getDisplayShort(energy, ElectricInfo.ElectricUnit.JOULES));
    }

    public void d(ur itemstack, yc world, qx entityplayer) {
        itemstack = this.getUnchargedItem();
    }

    public ur getUnchargedItem() {
        ur charged = new ur((up)this);
        charged.b(100);
        return charged;
    }

    public void a(int i, tj tabs, List list) {
        ur discharged = new ur((up)this);
        discharged.b(100);
        list.add(discharged);
        ur charged = new ur((up)this);
        this.setJoules(((IItemElectric)charged.b()).getMaxJoules(new Object[0]), charged);
        list.add(charged);
    }

    @Override
    public double getJoules(Object ... data) {
        if (data[0] instanceof ur) {
            ur itemStack = (ur)data[0];
            if (itemStack.d == null) {
                return 0.0;
            }
            double electricityStored = 0.0;
            electricityStored = itemStack.d.a("electricity") instanceof bv ? (double)itemStack.d.g("electricity") : itemStack.d.h("electricity");
            itemStack.b((int)Math.abs(electricityStored / this.MAX_ELECTRICITY * 100.0 - 100.0));
            return electricityStored;
        }
        return -1.0;
    }

    @Override
    public void setJoules(double wattHours, Object ... data) {
        if (data[0] instanceof ur) {
            ur itemStack = (ur)data[0];
            if (itemStack.d == null) {
                itemStack.d(new bq());
            }
            double electricityStored = Math.max(Math.min(wattHours, this.getMaxJoules(new Object[0])), 0.0);
            itemStack.d.a("electricity", electricityStored);
            itemStack.b((int)Math.abs(electricityStored / this.MAX_ELECTRICITY * 100.0 - 100.0));
        }
    }

    @Override
    public double getMaxJoules(Object ... data) {
        return this.MAX_ELECTRICITY;
    }

    @Override
    public double getVoltage(Object ... data) {
        return this.VOLTAGE;
    }

    @Override
    public double onReceive(double amps, double voltage, ur itemStack) {
        double rejectedElectricity = Math.max(this.getJoules(itemStack) + ElectricInfo.getJoules(amps, voltage, 1.0) - this.getMaxJoules(new Object[0]), 0.0);
        this.setJoules(this.getJoules(itemStack) + ElectricInfo.getJoules(amps, voltage, 1.0) - rejectedElectricity, itemStack);
        return rejectedElectricity;
    }

    @Override
    public double onUse(double joulesNeeded, ur itemStack) {
        double electricityToUse = Math.min(this.getJoules(itemStack), joulesNeeded);
        this.setJoules(this.getJoules(itemStack) - electricityToUse, itemStack);
        return electricityToUse;
    }

    @Override
    public boolean canReceiveElectricity() {
        return true;
    }

    @Override
    public boolean canProduceElectricity() {
        return true;
    }

    @Override
    public int charge(ur itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        double givenEnergy = (double)amount * Mekanism.FROM_IC2;
        double energyNeeded = this.MAX_ELECTRICITY - this.getJoules(itemStack);
        double energyToStore = Math.min(Math.min((double)amount, this.MAX_ELECTRICITY * 0.01), energyNeeded);
        if (!simulate) {
            this.setJoules(this.getJoules(itemStack) + energyToStore, itemStack);
        }
        return (int)(energyToStore * Mekanism.TO_IC2);
    }

    @Override
    public int discharge(ur itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        double energyWanted = (double)amount * Mekanism.FROM_IC2;
        double energyToGive = Math.min(Math.min(energyWanted, this.MAX_ELECTRICITY * 0.01), this.getJoules(itemStack));
        if (!simulate) {
            this.setJoules(this.getJoules(itemStack) - energyToGive, itemStack);
        }
        return (int)(energyToGive * Mekanism.TO_IC2);
    }

    @Override
    public boolean canUse(ur itemStack, int amount) {
        return this.getJoules(itemStack) >= (double)amount * Mekanism.FROM_IC2;
    }

    @Override
    public boolean canShowChargeToolTip(ur itemStack) {
        return false;
    }

    @Override
    public boolean canProvideEnergy() {
        return this.canProduceElectricity();
    }

    @Override
    public int getChargedItemId() {
        return this.cj;
    }

    @Override
    public int getEmptyItemId() {
        return this.cj;
    }

    @Override
    public int getMaxCharge() {
        return (int)(this.MAX_ELECTRICITY * Mekanism.TO_IC2);
    }

    @Override
    public int getTier() {
        return 3;
    }

    @Override
    public int getTransferLimit() {
        return (int)(this.getVoltage(new Object[0]) * Mekanism.TO_IC2);
    }
}

