/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import ic2.api.ICustomElectricItem;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.IEnergyCube;
import mekanism.api.Tier;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.TileEntityEnergyCube;
import universalelectricity.core.electricity.ElectricInfo;
import universalelectricity.core.implement.IItemElectric;

public class ItemBlockEnergyCube
extends vq
implements IItemElectric,
IEnergyCube,
ICustomElectricItem {
    public amq metaBlock;

    public ItemBlockEnergyCube(int id, amq block) {
        super(id);
        this.metaBlock = block;
        this.d(1);
        this.e(100);
        this.setNoRepair();
        this.a(Mekanism.tabMekanism);
    }

    public void a(ur itemstack, qx entityplayer, List list, boolean flag) {
        double energy = this.getJoules(itemstack);
        list.add("Stored Energy: " + ElectricInfo.getDisplayShort(energy, ElectricInfo.ElectricUnit.JOULES));
        list.add("Voltage: " + this.getVoltage(itemstack) + "v");
    }

    public ur getUnchargedItem(Tier.EnergyCubeTier tier) {
        ur charged = new ur((up)this);
        this.setTier(charged, tier);
        charged.b(100);
        return charged;
    }

    @Override
    public double getJoules(Object ... data) {
        if (data[0] instanceof ur) {
            ur itemStack = (ur)data[0];
            if (itemStack.d == null) {
                return 0.0;
            }
            double electricityStored = 0.0;
            electricityStored = itemStack.d.a("electricity") instanceof bv ? (double)itemStack.d.g("electricity") : itemStack.d.h("electricity");
            itemStack.b((int)Math.abs(electricityStored / this.getTier((ur)itemStack).MAX_ELECTRICITY * 100.0 - 100.0));
            return electricityStored;
        }
        return -1.0;
    }

    @Override
    public void setJoules(double wattHours, Object ... data) {
        if (data[0] instanceof ur) {
            ur itemStack = (ur)data[0];
            if (itemStack.d == null) {
                itemStack.d(new bq());
            }
            double electricityStored = Math.max(Math.min(wattHours, this.getMaxJoules(itemStack)), 0.0);
            itemStack.d.a("electricity", electricityStored);
            itemStack.b((int)Math.abs(electricityStored / this.getTier((ur)itemStack).MAX_ELECTRICITY * 100.0 - 100.0));
        }
    }

    @Override
    public double getMaxJoules(Object ... data) {
        if (data[0] instanceof ur) {
            ur itemstack = (ur)data[0];
            return this.getTier((ur)itemstack).MAX_ELECTRICITY;
        }
        return Tier.EnergyCubeTier.BASIC.MAX_ELECTRICITY;
    }

    @Override
    public double getVoltage(Object ... data) {
        if (data[0] instanceof ur) {
            ur itemstack = (ur)data[0];
            return this.getTier((ur)itemstack).VOLTAGE;
        }
        return Tier.EnergyCubeTier.BASIC.VOLTAGE;
    }

    @Override
    public double onReceive(double amps, double voltage, ur itemStack) {
        double rejectedElectricity = Math.max(this.getJoules(itemStack) + ElectricInfo.getJoules(amps, voltage, 1.0) - this.getMaxJoules(itemStack), 0.0);
        this.setJoules(this.getJoules(itemStack) + ElectricInfo.getJoules(amps, voltage, 1.0) - rejectedElectricity, itemStack);
        return rejectedElectricity;
    }

    @Override
    public double onUse(double joulesNeeded, ur itemStack) {
        double electricityToUse = Math.min(this.getJoules(itemStack), joulesNeeded);
        this.setJoules(this.getJoules(itemStack) - electricityToUse, itemStack);
        return electricityToUse;
    }

    @Override
    public boolean canReceiveElectricity() {
        return true;
    }

    @Override
    public boolean canProduceElectricity() {
        return true;
    }

    public String d(ur itemstack) {
        return this.a() + "." + this.getTier((ur)itemstack).name;
    }

    public boolean placeBlockAt(ur stack, qx player, yc world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        boolean place = super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
        if (place) {
            TileEntityEnergyCube tileEntity = (TileEntityEnergyCube)world.q(x, y, z);
            tileEntity.tier = ((IEnergyCube)stack.b()).getTier(stack);
            tileEntity.electricityStored = this.getJoules(stack);
            tileEntity.output = tileEntity.tier.OUTPUT;
            if (tileEntity.powerProvider != null) {
                tileEntity.powerProvider.configure(0, 0, 100, 0, (int)(tileEntity.tier.MAX_ELECTRICITY * Mekanism.TO_BC));
            }
            if (!world.I) {
                PacketHandler.sendTileEntityPacketToClients(tileEntity, 0.0, tileEntity.getNetworkedData(new ArrayList()));
            }
        }
        return place;
    }

    @Override
    public Tier.EnergyCubeTier getTier(ur itemstack) {
        if (itemstack.d == null) {
            return Tier.EnergyCubeTier.BASIC;
        }
        if (itemstack.d.i("tier") == null) {
            return Tier.EnergyCubeTier.BASIC;
        }
        return Tier.EnergyCubeTier.getFromName(itemstack.d.i("tier"));
    }

    @Override
    public void setTier(ur itemstack, Tier.EnergyCubeTier tier) {
        if (itemstack.d == null) {
            itemstack.d(new bq());
        }
        itemstack.d.a("tier", tier.name);
    }

    @Override
    public int charge(ur itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        double givenEnergy = (double)amount * Mekanism.FROM_IC2;
        double energyNeeded = this.getTier((ur)itemStack).MAX_ELECTRICITY - this.getJoules(itemStack);
        double energyToStore = Math.min(Math.min((double)amount, this.getTier((ur)itemStack).MAX_ELECTRICITY * 0.01), energyNeeded);
        if (!simulate) {
            this.setJoules(this.getJoules(itemStack) + energyToStore, itemStack);
        }
        return (int)(energyToStore * Mekanism.TO_IC2);
    }

    @Override
    public int discharge(ur itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        double energyWanted = (double)amount * Mekanism.FROM_IC2;
        double energyToGive = Math.min(Math.min(energyWanted, this.getTier((ur)itemStack).MAX_ELECTRICITY * 0.01), this.getJoules(itemStack));
        if (!simulate) {
            this.setJoules(this.getJoules(itemStack) - energyToGive, itemStack);
        }
        return (int)(energyToGive * Mekanism.TO_IC2);
    }

    @Override
    public boolean canUse(ur itemStack, int amount) {
        return this.getJoules(itemStack) >= (double)amount * Mekanism.FROM_IC2;
    }

    @Override
    public boolean canShowChargeToolTip(ur itemStack) {
        return false;
    }

    @Override
    public boolean canProvideEnergy() {
        return this.canProduceElectricity();
    }

    @Override
    public int getChargedItemId() {
        return this.cj;
    }

    @Override
    public int getEmptyItemId() {
        return this.cj;
    }

    @Override
    public int getMaxCharge() {
        return 0;
    }

    @Override
    public int getTier() {
        return 3;
    }

    @Override
    public int getTransferLimit() {
        return (int)(this.getVoltage(new Object[0]) * Mekanism.TO_IC2);
    }
}

