/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import mekanism.client.GuiCredits;
import mekanism.common.Mekanism;
import net.minecraft.client.Minecraft;

public class ThreadClientUpdate
extends Thread {
    private int downloadType;
    private int bytesDownloaded;
    private int lastBytesDownloaded;
    private byte[] buffer = new byte[10240];
    private URL url;

    public ThreadClientUpdate(String location, int type) {
        this.downloadType = type;
        try {
            this.url = new URL(location);
            this.setDaemon(true);
            this.start();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        String downloadName = this.downloadType == 0 ? "" : (this.downloadType == 1 ? "Generators" : "Tools");
        File download = new File(Minecraft.b() + ("/mods/Mekanism" + downloadName + "-v" + Mekanism.latestVersionNumber + ".jar"));
        try {
            this.prepareForDownload();
            download.createNewFile();
            FileOutputStream outputStream = new FileOutputStream(download.getAbsolutePath());
            InputStream stream = this.url.openStream();
            while ((this.lastBytesDownloaded = stream.read(this.buffer)) > 0) {
                outputStream.write(this.buffer, 0, this.lastBytesDownloaded);
                this.buffer = new byte[10240];
                this.bytesDownloaded += this.lastBytesDownloaded;
            }
            outputStream.close();
            stream.close();
            if (this.downloadType == 2) {
                GuiCredits.onFinishedDownloading();
                System.out.println("[Mekanism] Successfully updated to latest version (" + Mekanism.latestVersionNumber + ").");
            }
            this.finalize();
        }
        catch (Throwable e) {
            GuiCredits.onErrorDownloading();
            System.err.println("[Mekanism] Error while finishing update thread: " + e.getMessage());
            try {
                this.finalize();
            }
            catch (Throwable e1) {
                System.err.println("[Mekanism] Error while finalizing update thread: " + e1.getMessage());
            }
        }
    }

    public void prepareForDownload() {
        File[] modsList;
        for (File file : modsList = new File(Minecraft.b() + "/mods").listFiles()) {
            if (!file.getName().startsWith("Mekanism") || !file.getName().endsWith(".jar") || file.getName().contains(Mekanism.latestVersionNumber)) continue;
            file.delete();
        }
        System.out.println("[Mekanism] Preparing to update...");
    }
}

