/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import cpw.mods.fml.client.FMLClientHandler;
import java.net.URL;
import java.util.List;
import mekanism.common.Mekanism;

public class Sound {
    public String soundPath;
    public String identifier;
    public int xCoord;
    public int yCoord;
    public int zCoord;
    public boolean isPlaying = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sound(String id, String sound, yc world, int x, int y, int z) {
        List list = Mekanism.audioHandler.sounds;
        synchronized (list) {
            this.soundPath = sound;
            this.identifier = id;
            this.xCoord = x;
            this.yCoord = y;
            this.zCoord = z;
            URL url = this.getClass().getClassLoader().getResource("resources/mekanism/sound/" + sound);
            if (url == null) {
                System.out.println("[Mekanism] Invalid sound file: " + sound);
            }
            if (Mekanism.audioHandler.soundSystem != null) {
                Mekanism.audioHandler.soundSystem.newSource(false, id, url, sound, true, (float)x, (float)y, (float)z, 0, 16.0f);
                this.updateVolume((qx)FMLClientHandler.instance().getClient().g);
                Mekanism.audioHandler.soundSystem.activate(id);
            }
            Mekanism.audioHandler.sounds.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play() {
        List list = Mekanism.audioHandler.sounds;
        synchronized (list) {
            if (this.isPlaying) {
                return;
            }
            if (Mekanism.audioHandler.soundSystem != null) {
                this.updateVolume((qx)FMLClientHandler.instance().getClient().g);
                Mekanism.audioHandler.soundSystem.play(this.identifier);
            }
            this.isPlaying = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopLoop() {
        List list = Mekanism.audioHandler.sounds;
        synchronized (list) {
            if (!this.isPlaying) {
                return;
            }
            if (Mekanism.audioHandler.soundSystem != null) {
                this.updateVolume((qx)FMLClientHandler.instance().getClient().g);
                Mekanism.audioHandler.soundSystem.stop(this.identifier);
            }
            this.isPlaying = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove() {
        List list = Mekanism.audioHandler.sounds;
        synchronized (list) {
            if (this.isPlaying) {
                this.stopLoop();
            }
            Mekanism.audioHandler.sounds.remove(this);
            if (Mekanism.audioHandler.soundSystem != null) {
                this.updateVolume((qx)FMLClientHandler.instance().getClient().g);
                Mekanism.audioHandler.soundSystem.removeSource(this.identifier);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVolume(qx entityplayer) {
        List list = Mekanism.audioHandler.sounds;
        synchronized (list) {
            float volume = 0.0f;
            double distanceVolume = entityplayer.e((double)this.xCoord, (double)this.yCoord, (double)this.zCoord) * 0.008;
            volume = (float)Math.max((double)Mekanism.audioHandler.masterVolume - distanceVolume, 0.0) * 0.05f;
            if (Mekanism.audioHandler.soundSystem != null) {
                Mekanism.audioHandler.soundSystem.setVolume(this.identifier, volume);
            }
        }
    }
}

