/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.TextureFXManager;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.IOException;
import java.util.List;
import mekanism.client.BlockRenderingHandler;
import mekanism.client.ClientTickHandler;
import mekanism.client.GuiCombiner;
import mekanism.client.GuiControlPanel;
import mekanism.client.GuiCredits;
import mekanism.client.GuiCrusher;
import mekanism.client.GuiEnergyCube;
import mekanism.client.GuiEnrichmentChamber;
import mekanism.client.GuiGasTank;
import mekanism.client.GuiMetallurgicInfuser;
import mekanism.client.GuiOsmiumCompressor;
import mekanism.client.GuiPortableTeleporter;
import mekanism.client.GuiPurificationChamber;
import mekanism.client.GuiSmeltingFactory;
import mekanism.client.GuiStopwatch;
import mekanism.client.GuiTeleporter;
import mekanism.client.GuiTheoreticalElementizer;
import mekanism.client.GuiWeatherOrb;
import mekanism.client.ItemRenderingHandler;
import mekanism.client.PressurizedTubeRenderer;
import mekanism.client.RenderObsidianTNT;
import mekanism.client.RenderPressurizedTube;
import mekanism.client.RenderTheoreticalElementizer;
import mekanism.client.Sound;
import mekanism.client.SoundHandler;
import mekanism.client.TextureAnimatedFX;
import mekanism.client.ThreadSendData;
import mekanism.common.CommonProxy;
import mekanism.common.EntityObsidianTNT;
import mekanism.common.ItemPortableTeleporter;
import mekanism.common.Mekanism;
import mekanism.common.TileEntityAdvancedElectricMachine;
import mekanism.common.TileEntityControlPanel;
import mekanism.common.TileEntityElectricMachine;
import mekanism.common.TileEntityEnergyCube;
import mekanism.common.TileEntityGasTank;
import mekanism.common.TileEntityMetallurgicInfuser;
import mekanism.common.TileEntityPressurizedTube;
import mekanism.common.TileEntitySmeltingFactory;
import mekanism.common.TileEntityTeleporter;
import mekanism.common.TileEntityTheoreticalElementizer;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;

public class ClientProxy
extends CommonProxy {
    public static int RENDER_ID = RenderingRegistry.getNextAvailableRenderId();
    public static int TUBE_RENDER_ID = RenderingRegistry.getNextAvailableRenderId();

    @Override
    public void loadConfiguration() {
        super.loadConfiguration();
        Mekanism.configuration.load();
        Mekanism.enableSounds = Mekanism.configuration.get("general", "EnableSounds", true).getBoolean(true);
    }

    @Override
    public int getArmorIndex(String string) {
        return RenderingRegistry.addNewArmourRendererPrefix((String)string);
    }

    @Override
    public void registerSpecialTileEntities() {
        ClientRegistry.registerTileEntity(TileEntityTheoreticalElementizer.class, (String)"TheoreticalElementizer", (bdx)new RenderTheoreticalElementizer());
        ClientRegistry.registerTileEntity(TileEntityPressurizedTube.class, (String)"PressurizedTube", (bdx)new RenderPressurizedTube());
    }

    @Override
    public void registerRenderInformation() {
        MinecraftForgeClient.preloadTexture((String)"/resources/mekanism/textures/items.png");
        MinecraftForgeClient.preloadTexture((String)"/resources/mekanism/textures/terrain.png");
        MinecraftForgeClient.preloadTexture((String)"/resources/mekanism/animate/CrusherFront.png");
        MinecraftForgeClient.preloadTexture((String)"/resources/mekanism/animate/CompressorFront.png");
        MinecraftForgeClient.preloadTexture((String)"/resources/mekanism/animate/CombinerFront.png");
        MinecraftForgeClient.preloadTexture((String)"/resources/mekanism/animate/InfuserFront.png");
        MinecraftForgeClient.preloadTexture((String)"/resources/mekanism/animate/InfuserBack.png");
        MinecraftForgeClient.preloadTexture((String)"/resources/mekanism/animate/InfuserSide.png");
        MinecraftForgeClient.preloadTexture((String)"/resources/mekanism/animate/PurificationChamberFront.png");
        try {
            TextureFXManager.instance().addAnimation((bdg)new TextureAnimatedFX("/resources/mekanism/animate/CrusherFront.png", Mekanism.ANIMATED_TEXTURE_INDEX + 1));
            TextureFXManager.instance().addAnimation((bdg)new TextureAnimatedFX("/resources/mekanism/animate/CompressorFront.png", Mekanism.ANIMATED_TEXTURE_INDEX + 2));
            TextureFXManager.instance().addAnimation((bdg)new TextureAnimatedFX("/resources/mekanism/animate/CombinerFront.png", Mekanism.ANIMATED_TEXTURE_INDEX + 3));
            TextureFXManager.instance().addAnimation((bdg)new TextureAnimatedFX("/resources/mekanism/animate/InfuserFront.png", Mekanism.ANIMATED_TEXTURE_INDEX + 4));
            TextureFXManager.instance().addAnimation((bdg)new TextureAnimatedFX("/resources/mekanism/animate/InfuserBack.png", Mekanism.ANIMATED_TEXTURE_INDEX + 5));
            TextureFXManager.instance().addAnimation((bdg)new TextureAnimatedFX("/resources/mekanism/animate/InfuserSide.png", Mekanism.ANIMATED_TEXTURE_INDEX + 6));
            TextureFXManager.instance().addAnimation((bdg)new TextureAnimatedFX("/resources/mekanism/animate/PurificationChamberFront.png", Mekanism.ANIMATED_TEXTURE_INDEX + 9));
        }
        catch (IOException e) {
            System.err.println("[Mekanism] Error registering animation with FML: " + e.getMessage());
        }
        RenderingRegistry.registerEntityRenderingHandler(EntityObsidianTNT.class, (bbv)new RenderObsidianTNT());
        MinecraftForgeClient.registerItemRenderer((int)Mekanism.energyCubeID, (IItemRenderer)new ItemRenderingHandler());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRenderingHandler());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new PressurizedTubeRenderer());
        System.out.println("[Mekanism] Render registrations complete.");
    }

    @Override
    public yc getClientWorld() {
        return FMLClientHandler.instance().getClient().e;
    }

    @Override
    public void loadUtilities() {
        if (FMLClientHandler.instance().getClient().y.t) {
            new ThreadSendData();
        }
        System.out.println("[Mekanism] Utility initiative complete.");
    }

    public aul getClientGui(int ID, qx player, yc world, int x, int y, int z) {
        any tileEntity = world.q(x, y, z);
        switch (ID) {
            case 0: {
                return new GuiStopwatch(player);
            }
            case 1: {
                return new GuiCredits();
            }
            case 2: {
                return new GuiWeatherOrb(player);
            }
            case 3: {
                return new GuiEnrichmentChamber(player.bJ, (TileEntityElectricMachine)tileEntity);
            }
            case 4: {
                return new GuiOsmiumCompressor(player.bJ, (TileEntityAdvancedElectricMachine)tileEntity);
            }
            case 5: {
                return new GuiCombiner(player.bJ, (TileEntityAdvancedElectricMachine)tileEntity);
            }
            case 6: {
                return new GuiCrusher(player.bJ, (TileEntityElectricMachine)tileEntity);
            }
            case 7: {
                return new GuiTheoreticalElementizer(player.bJ, (TileEntityTheoreticalElementizer)tileEntity);
            }
            case 8: {
                return new GuiEnergyCube(player.bJ, (TileEntityEnergyCube)tileEntity);
            }
            case 9: {
                return new GuiControlPanel((TileEntityControlPanel)tileEntity, player, world);
            }
            case 10: {
                return new GuiGasTank(player.bJ, (TileEntityGasTank)tileEntity);
            }
            case 11: {
                return new GuiSmeltingFactory(player.bJ, (TileEntitySmeltingFactory)tileEntity);
            }
            case 12: {
                return new GuiMetallurgicInfuser(player.bJ, (TileEntityMetallurgicInfuser)tileEntity);
            }
            case 13: {
                return new GuiTeleporter(player.bJ, (TileEntityTeleporter)tileEntity);
            }
            case 14: {
                ur itemStack = player.bS();
                if (itemStack != null && itemStack.b() instanceof ItemPortableTeleporter) {
                    return new GuiPortableTeleporter(player, itemStack);
                }
            }
            case 15: {
                return new GuiPurificationChamber(player.bJ, (TileEntityAdvancedElectricMachine)tileEntity);
            }
        }
        return null;
    }

    @Override
    public void loadTickHandler() {
        super.loadTickHandler();
        TickRegistry.registerTickHandler((ITickHandler)new ClientTickHandler(), (Side)Side.CLIENT);
    }

    @Override
    public void loadSoundHandler() {
        if (Mekanism.enableSounds) {
            Mekanism.audioHandler = new SoundHandler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unloadSoundHandler() {
        if (Mekanism.audioHandler != null) {
            List list = Mekanism.audioHandler.sounds;
            synchronized (list) {
                for (Sound sound : Mekanism.audioHandler.sounds) {
                    sound.stopLoop();
                    Mekanism.audioHandler.soundSystem.removeSource(sound.identifier);
                }
                Mekanism.audioHandler.sounds.clear();
            }
        }
    }
}

