/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import mekanism.api.EnumGas;
import mekanism.api.GasTransferProtocol;
import mekanism.api.IGasAcceptor;
import mekanism.api.IPressurizedTube;
import mekanism.api.ITubeConnection;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.vector.Vector3;

public class GasTransmission {
    public static any[] getConnectedTubes(any tileEntity) {
        any[] tubes = new any[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.values()) {
            any tube;
            if (orientation == ForgeDirection.UNKNOWN || !((tube = Vector3.getTileEntityFromSide(tileEntity.k, new Vector3(tileEntity.l, tileEntity.m, tileEntity.n), orientation)) instanceof IPressurizedTube) || !((IPressurizedTube)tube).canTransferGas()) continue;
            tubes[orientation.ordinal()] = tube;
        }
        return tubes;
    }

    public static IGasAcceptor[] getConnectedAcceptors(any tileEntity) {
        IGasAcceptor[] acceptors = new IGasAcceptor[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.values()) {
            any acceptor;
            if (orientation == ForgeDirection.UNKNOWN || !((acceptor = Vector3.getTileEntityFromSide(tileEntity.k, new Vector3(tileEntity.l, tileEntity.m, tileEntity.n), orientation)) instanceof IGasAcceptor)) continue;
            acceptors[orientation.ordinal()] = (IGasAcceptor)acceptor;
        }
        return acceptors;
    }

    public static ITubeConnection[] getConnections(any tileEntity) {
        ITubeConnection[] connections = new ITubeConnection[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.values()) {
            any connection;
            if (orientation == ForgeDirection.UNKNOWN || !((connection = Vector3.getTileEntityFromSide(tileEntity.k, new Vector3(tileEntity.l, tileEntity.m, tileEntity.n), orientation)) instanceof ITubeConnection)) continue;
            connections[orientation.ordinal()] = (ITubeConnection)connection;
        }
        return connections;
    }

    public static int emitGasToNetwork(EnumGas type, int amount, any sender, ForgeDirection facing) {
        any pointer = Vector3.getTileEntityFromSide(sender.k, new Vector3(sender.l, sender.m, sender.n), facing);
        if (pointer != null) {
            GasTransferProtocol calculation = new GasTransferProtocol(pointer, type, amount);
            return calculation.calculate();
        }
        return amount;
    }
}

