/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import java.util.ArrayList;
import java.util.Arrays;
import mekanism.api.EnumGas;
import mekanism.api.GasTransmission;
import mekanism.api.IGasAcceptor;
import net.minecraftforge.common.ForgeDirection;

public class GasTransferProtocol {
    public ArrayList iteratedTubes = new ArrayList();
    public ArrayList availableAcceptors = new ArrayList();
    public any pointer;
    public EnumGas transferType;
    public int gasToSend;

    public GasTransferProtocol(any head, EnumGas type, int amount) {
        this.pointer = head;
        this.transferType = type;
        this.gasToSend = amount;
    }

    public void loopThrough(any tile) {
        any[] tubes;
        IGasAcceptor[] acceptors;
        for (IGasAcceptor acceptor : acceptors = GasTransmission.getConnectedAcceptors(tile)) {
            if (acceptor == null || !acceptor.canReceiveGas(ForgeDirection.getOrientation((int)Arrays.asList(acceptors).indexOf(acceptor)).getOpposite(), this.transferType)) continue;
            this.availableAcceptors.add(acceptor);
        }
        this.iteratedTubes.add(tile);
        for (any tube : tubes = GasTransmission.getConnectedTubes(tile)) {
            if (tube == null || this.iteratedTubes.contains(tube)) continue;
            this.loopThrough(tube);
        }
    }

    public int calculate() {
        this.loopThrough(this.pointer);
        if (!this.availableAcceptors.isEmpty()) {
            int divider = this.availableAcceptors.size();
            int remaining = this.gasToSend % divider;
            int sending = (this.gasToSend - remaining) / divider;
            for (IGasAcceptor acceptor : this.availableAcceptors) {
                int currentSending = sending;
                if (remaining > 0) {
                    ++currentSending;
                    --remaining;
                }
                int rejects = acceptor.transferGasToAcceptor(currentSending, this.transferType);
                this.gasToSend -= currentSending - rejects;
            }
        }
        return this.gasToSend;
    }
}

