/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab.tile;

import java.util.EnumSet;
import universalelectricity.core.UniversalElectricity;
import universalelectricity.core.electricity.ElectricityNetworkHelper;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.prefab.tile.TileEntityElectrical;

public abstract class TileEntityElectricityRunnable
extends TileEntityElectrical {
    public double prevWatts;
    public double wattsReceived = 0.0;

    @Override
    public void h() {
        super.h();
        this.prevWatts = this.wattsReceived;
        if (!this.k.I) {
            if (!this.isDisabled()) {
                ElectricityPack electricityPack = ElectricityNetworkHelper.consumeFromMultipleSides(this, this.getConsumingSides(), this.getRequest());
                this.onReceive(electricityPack);
            } else {
                ElectricityNetworkHelper.consumeFromMultipleSides(this, new ElectricityPack());
            }
        }
    }

    protected EnumSet getConsumingSides() {
        return ElectricityNetworkHelper.getDirections(this);
    }

    public ElectricityPack getRequest() {
        return new ElectricityPack();
    }

    public void onReceive(ElectricityPack electricityPack) {
        if (UniversalElectricity.isVoltageSensitive && electricityPack.voltage > this.getVoltage()) {
            this.k.a(null, (double)this.l, (double)this.m, (double)this.n, 1.5f, true);
            return;
        }
        this.wattsReceived = Math.min(this.wattsReceived + electricityPack.getWatts(), this.getWattBuffer());
    }

    public double getWattBuffer() {
        return this.getRequest().getWatts() * 2.0;
    }
}

