/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab.network;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.network.IPacketHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.network.IPacketReceiver;

public class PacketManager
implements IPacketHandler,
IPacketReceiver {
    public static void writeNBTTagCompound(bs tag, DataOutputStream dataStream) throws IOException {
        if (tag == null) {
            dataStream.writeShort(-1);
        } else {
            byte[] var2 = cc.a((bs)tag);
            dataStream.writeShort((short)var2.length);
            dataStream.write(var2);
        }
    }

    public static bs readNBTTagCompound(ByteArrayDataInput dataStream) throws IOException {
        short var1 = dataStream.readShort();
        if (var1 < 0) {
            return null;
        }
        byte[] var2 = new byte[var1];
        dataStream.readFully(var2);
        return cc.a((byte[])var2);
    }

    public static ei getPacketWithID(String channelName, int id, Object ... sendData) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeInt(id);
            data = PacketManager.encodeDataStream(data, sendData);
            dk packet = new dk();
            packet.a = channelName;
            packet.c = bytes.toByteArray();
            packet.b = packet.c.length;
            return packet;
        }
        catch (IOException e) {
            System.out.println("Failed to create packet.");
            e.printStackTrace();
            return null;
        }
    }

    public static ei getPacket(String channelName, Object ... sendData) {
        return PacketManager.getPacketWithID(channelName, PacketType.UNSPECIFIED.ordinal(), sendData);
    }

    public static ei getPacket(String channelName, aqp sender, Object ... sendData) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream data = new DataOutputStream(bytes);
        try {
            data.writeInt(PacketType.TILEENTITY.ordinal());
            data.writeInt(sender.l);
            data.writeInt(sender.m);
            data.writeInt(sender.n);
            data = PacketManager.encodeDataStream(data, sendData);
            dk packet = new dk();
            packet.a = channelName;
            packet.c = bytes.toByteArray();
            packet.b = packet.c.length;
            return packet;
        }
        catch (IOException e) {
            System.out.println("Failed to create packet.");
            e.printStackTrace();
            return null;
        }
    }

    public static void sendPacketToClients(ei packet, aab worldObj, Vector3 position, double range) {
        try {
            PacketDispatcher.sendPacketToAllAround((double)position.x, (double)position.y, (double)position.z, (double)range, (int)worldObj.t.h, (ei)packet);
        }
        catch (Exception e) {
            System.out.println("Sending packet to client failed.");
            e.printStackTrace();
        }
    }

    public static void sendPacketToClients(ei packet, aab worldObj) {
        try {
            PacketDispatcher.sendPacketToAllInDimension((ei)packet, (int)worldObj.t.h);
        }
        catch (Exception e) {
            System.out.println("Sending packet to client failed.");
            e.printStackTrace();
        }
    }

    public static void sendPacketToClients(ei packet) {
        try {
            PacketDispatcher.sendPacketToAllPlayers((ei)packet);
        }
        catch (Exception e) {
            System.out.println("Sending packet to client failed.");
            e.printStackTrace();
        }
    }

    public static DataOutputStream encodeDataStream(DataOutputStream data, Object ... sendData) {
        try {
            for (Object dataValue : sendData) {
                if (dataValue instanceof Integer) {
                    data.writeInt((Integer)dataValue);
                    continue;
                }
                if (dataValue instanceof Float) {
                    data.writeFloat(((Float)dataValue).floatValue());
                    continue;
                }
                if (dataValue instanceof Double) {
                    data.writeDouble((Double)dataValue);
                    continue;
                }
                if (dataValue instanceof Byte) {
                    data.writeByte(((Byte)dataValue).byteValue());
                    continue;
                }
                if (dataValue instanceof Boolean) {
                    data.writeBoolean((Boolean)dataValue);
                    continue;
                }
                if (dataValue instanceof String) {
                    data.writeUTF((String)dataValue);
                    continue;
                }
                if (dataValue instanceof Short) {
                    data.writeShort(((Short)dataValue).shortValue());
                    continue;
                }
                if (dataValue instanceof Long) {
                    data.writeLong((Long)dataValue);
                    continue;
                }
                if (!(dataValue instanceof bs)) continue;
                PacketManager.writeNBTTagCompound((bs)dataValue, data);
            }
            return data;
        }
        catch (IOException e) {
            System.out.println("Packet data encoding failed.");
            e.printStackTrace();
            return data;
        }
    }

    public void onPacketData(cg network, dk packet, Player player) {
        try {
            ByteArrayDataInput data = ByteStreams.newDataInput((byte[])packet.c);
            int packetTypeID = data.readInt();
            PacketType packetType = PacketType.get(packetTypeID);
            if (packetType == PacketType.TILEENTITY) {
                aqp tileEntity;
                int x2 = data.readInt();
                int y = data.readInt();
                int z2 = data.readInt();
                aab world = ((sq)player).q;
                if (world != null && (tileEntity = world.r(x2, y, z2)) != null && tileEntity instanceof IPacketReceiver) {
                    ((IPacketReceiver)tileEntity).handlePacketData(network, packetTypeID, packet, (sq)player, data);
                }
            } else {
                this.handlePacketData(network, packetTypeID, packet, (sq)player, data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void handlePacketData(cg network, int packetType, dk packet, sq player, ByteArrayDataInput dataStream) {
    }

    public static enum PacketType {
        UNSPECIFIED,
        TILEENTITY;


        public static PacketType get(int id) {
            if (id >= 0 && id < PacketType.values().length) {
                return PacketType.values()[id];
            }
            return UNSPECIFIED;
        }
    }
}

