/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab.flag;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import universalelectricity.core.vector.Vector3;
import universalelectricity.prefab.flag.Flag;
import universalelectricity.prefab.flag.FlagBase;
import universalelectricity.prefab.flag.FlagRegion;
import universalelectricity.prefab.vector.Region3;

public class FlagWorld
extends FlagBase {
    public static final String GLOBAL_REGION = "dimension";
    public aab world;
    private final List regions = new ArrayList();

    public FlagWorld(aab world) {
        this.world = world;
    }

    @Override
    public void readFromNBT(bs nbt) {
        for (bs childCompound : nbt.c()) {
            try {
                FlagRegion flagRegion = new FlagRegion(this);
                flagRegion.readFromNBT(childCompound);
                this.regions.add(flagRegion);
            }
            catch (Exception e) {
                System.out.println("Mod Flag: Failed to read flag data: " + childCompound.e());
                e.printStackTrace();
            }
        }
    }

    @Override
    public void writeToNBT(bs nbt) {
        for (FlagRegion region : this.regions) {
            try {
                bs flagCompound = new bs();
                region.writeToNBT(flagCompound);
                nbt.a(region.name, (cf)flagCompound);
            }
            catch (Exception e) {
                System.out.println("Failed to save world flag data: " + region.name);
                e.printStackTrace();
            }
        }
    }

    public List getFlagsInPosition(Vector3 position) {
        ArrayList<Flag> returnFlags = new ArrayList<Flag>();
        for (FlagRegion flagRegion : this.regions) {
            if (!flagRegion.region.isIn(position) && !flagRegion.name.equalsIgnoreCase(GLOBAL_REGION)) continue;
            for (Flag flag : flagRegion.getFlags()) {
                returnFlags.add(flag);
            }
        }
        return returnFlags;
    }

    public List getValues(String flagName, Vector3 position) {
        ArrayList<String> values = new ArrayList<String>();
        for (Flag flag : this.getFlagsInPosition(position)) {
            values.add(flag.value);
        }
        return values;
    }

    public boolean containsValue(String flagName, String checkValue, Vector3 position) {
        for (Flag flag : this.getFlagsInPosition(position)) {
            if (!flag.name.equalsIgnoreCase(flagName) || !flag.value.equalsIgnoreCase(checkValue)) continue;
            return true;
        }
        return false;
    }

    public boolean addRegion(String name, Vector3 position, int radius) {
        Vector3 minVec = new Vector3(position.intX() - radius, 0.0, position.intZ() - radius);
        Vector3 maxVec = new Vector3(position.intX() + radius, this.world.P(), position.intZ() + radius);
        return this.regions.add(new FlagRegion(this, name, new Region3(minVec, maxVec)));
    }

    public FlagRegion getRegion(String name) {
        for (FlagRegion region : this.regions) {
            if (!region.name.equals(name)) continue;
            return region;
        }
        return null;
    }

    public List getRegions(Vector3 position) {
        ArrayList<FlagRegion> returnRegions = new ArrayList<FlagRegion>();
        for (FlagRegion region : this.regions) {
            if (!region.region.isIn(position)) continue;
            returnRegions.add(region);
        }
        return returnRegions;
    }

    public boolean removeRegion(String name) {
        for (FlagRegion region : this.regions) {
            if (!region.name.equals(name)) continue;
            this.regions.remove(region);
            return true;
        }
        return false;
    }

    public List getRegions() {
        Iterator it = this.regions.iterator();
        while (it.hasNext()) {
            FlagRegion region = (FlagRegion)it.next();
            if (region == null) {
                it.remove();
                continue;
            }
            if (region.name != null && region.name != "") continue;
            it.remove();
        }
        return this.regions;
    }
}

