/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.path;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.block.IConnectionProvider;

public class Pathfinder {
    public IPathCallBack callBackCheck;
    public List iteratedNodes;
    public List results;

    public Pathfinder(IPathCallBack callBack) {
        this.callBackCheck = callBack;
        this.clear();
    }

    public boolean findNodes(IConnectionProvider provider) {
        aqp[] connectedBlocks = provider.getAdjacentConnections();
        this.iteratedNodes.add(provider);
        if (this.callBackCheck.onSearch(this, provider)) {
            return false;
        }
        for (int i = 0; i < connectedBlocks.length; ++i) {
            aqp connectedBlock = connectedBlocks[i];
            if (!(connectedBlock instanceof IConnectionProvider) || this.iteratedNodes.contains(connectedBlock) || !this.callBackCheck.isValidNode(this, ForgeDirection.getOrientation((int)i), provider, (IConnectionProvider)connectedBlock) || this.findNodes((IConnectionProvider)connectedBlock)) continue;
            return false;
        }
        return true;
    }

    public Pathfinder init(IConnectionProvider provider) {
        this.findNodes(provider);
        return this;
    }

    public Pathfinder clear() {
        this.iteratedNodes = new ArrayList();
        this.results = new ArrayList();
        return this;
    }

    public static interface IPathCallBack {
        public boolean isValidNode(Pathfinder var1, ForgeDirection var2, IConnectionProvider var3, IConnectionProvider var4);

        public boolean onSearch(Pathfinder var1, IConnectionProvider var2);
    }
}

