/*
 * Decompiled with CFR 0.152.
 */
package atomicscience.wujian;

import atomicscience.TabAS;
import atomicscience.api.AtomicScience;
import ic2.api.ICustomElectricItem;
import universalelectricity.core.UniversalElectricity;
import universalelectricity.core.item.ItemElectric;

public abstract class ItIC2ElectricItem
extends ItemElectric
implements ICustomElectricItem {
    public static final float CHARGE_RATE = 0.005f;

    public ItIC2ElectricItem(int itemID, String name) {
        super(AtomicScience.CONFIGURATION.getItem(name, itemID).getInt());
        this.b("atomicscience:" + name);
        this.a(TabAS.INSTANCE);
    }

    @Override
    public boolean canProvideEnergy() {
        return false;
    }

    @Override
    public int getChargedItemId() {
        return 0;
    }

    @Override
    public int getEmptyItemId() {
        return 0;
    }

    @Override
    public int getMaxCharge() {
        return (int)(this.getMaxJoules(null) * UniversalElectricity.TO_IC2_RATIO);
    }

    @Override
    public int getTier() {
        return 0;
    }

    @Override
    public int getTransferLimit() {
        return (int)(this.getMaxJoules(null) * (double)0.005f * UniversalElectricity.TO_IC2_RATIO);
    }

    @Override
    public int charge(wm itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        double inputElectricity = (double)amount * UniversalElectricity.IC2_RATIO;
        inputElectricity = Math.min(inputElectricity, this.getMaxJoules(itemStack) - this.getJoules(itemStack));
        if (!ignoreTransferLimit) {
            inputElectricity = Math.min(inputElectricity, this.getMaxJoules(itemStack) * (double)0.005f);
        }
        if (!simulate) {
            this.setJoules(this.getJoules(itemStack) + inputElectricity, itemStack);
        }
        return (int)(inputElectricity * UniversalElectricity.TO_IC2_RATIO);
    }

    @Override
    public int discharge(wm itemStack, int amount, int tier, boolean ignoreTransferLimit, boolean simulate) {
        double outputElectricity = (double)amount * UniversalElectricity.IC2_RATIO;
        outputElectricity = Math.min(outputElectricity, this.getJoules(itemStack));
        if (!ignoreTransferLimit) {
            outputElectricity = Math.min(this.getJoules(itemStack), this.getMaxJoules(itemStack) * (double)0.005f);
        }
        if (!simulate) {
            this.setJoules(this.getJoules(itemStack) - outputElectricity, itemStack);
        }
        return (int)(outputElectricity * UniversalElectricity.TO_IC2_RATIO);
    }

    @Override
    public boolean canUse(wm itemStack, int amount) {
        return false;
    }

    @Override
    public boolean canShowChargeToolTip(wm itemStack) {
        return false;
    }
}

