/*
 * Decompiled with CFR 0.152.
 */
package atomicscience.jiqi;

import ic2.api.Direction;
import ic2.api.IWrenchable;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import universalelectricity.core.UniversalElectricity;
import universalelectricity.core.electricity.ElectricityPack;
import universalelectricity.prefab.block.BlockRotatable;
import universalelectricity.prefab.implement.IRotatable;
import universalelectricity.prefab.tile.TileEntityElectricityRunnable;

public abstract class TIC2Receiver
extends TileEntityElectricityRunnable
implements IEnergySink,
IWrenchable {
    @Override
    public void initiate() {
        super.initiate();
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
    }

    @Override
    public void w_() {
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        super.w_();
    }

    @Override
    public boolean acceptsEnergyFrom(aqp emitter, Direction direction) {
        return this.canConnect(direction.toForgeDirection());
    }

    @Override
    public boolean isAddedToEnergyNet() {
        return this.ticks > 0L;
    }

    @Override
    public int demandsEnergy() {
        return (int)(this.getRequest().getWatts() * UniversalElectricity.TO_IC2_RATIO);
    }

    @Override
    public int injectEnergy(Direction direction, int i) {
        double givenElectricity = (double)i * UniversalElectricity.IC2_RATIO;
        double rejects = 0.0;
        if (givenElectricity > this.getWattBuffer()) {
            rejects = givenElectricity - this.getRequest().getWatts();
        }
        this.onReceive(new ElectricityPack(givenElectricity / this.getVoltage(), this.getVoltage()));
        return (int)(rejects * UniversalElectricity.TO_IC2_RATIO);
    }

    @Override
    public int getMaxSafeInput() {
        return 2048;
    }

    @Override
    public boolean wrenchCanSetFacing(sq entityPlayer, int side) {
        return this.q() instanceof IRotatable;
    }

    @Override
    public short getFacing() {
        if (this instanceof IRotatable) {
            return (short)((IRotatable)((Object)this)).getDirection((aak)this.k, this.l, this.m, this.n).ordinal();
        }
        return 0;
    }

    @Override
    public void setFacing(short facing) {
        if (this.q() instanceof BlockRotatable) {
            ((BlockRotatable)this.q()).onUseWrench(this.k, this.l, this.m, this.n, null, facing, 0.0f, 0.0f, 0.0f);
        }
    }

    @Override
    public boolean wrenchCanRemove(sq entityPlayer) {
        return false;
    }

    @Override
    public float getWrenchDropRate() {
        return 0.0f;
    }

    @Override
    public wm getWrenchDrop(sq entityPlayer) {
        return null;
    }

    @Override
    public boolean canConnect(ForgeDirection direction) {
        if (this instanceof IRotatable) {
            return direction == ForgeDirection.getOrientation((int)this.p()).getOpposite();
        }
        return true;
    }

    public ForgeDirection getDirection(aak world, int x, int y, int z) {
        return ForgeDirection.getOrientation((int)this.p());
    }

    public void setDirection(aab world, int x, int y, int z, ForgeDirection facingDirection) {
        this.k.b(this.l, this.m, this.n, facingDirection.ordinal(), 2);
    }
}

