/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core.vector;

import java.util.List;
import net.minecraftforge.common.ForgeDirection;
import universalelectricity.core.vector.Vector2;

public class Vector3
implements Cloneable {
    public double x;
    public double y;
    public double z;

    public Vector3() {
        this(0.0, 0.0, 0.0);
    }

    public Vector3(double x2, double y, double z) {
        this.x = x2;
        this.y = y;
        this.z = z;
    }

    public Vector3(mp par1) {
        this.x = par1.u;
        this.y = par1.v;
        this.z = par1.w;
    }

    public Vector3(aqp par1) {
        this.x = par1.l;
        this.y = par1.m;
        this.z = par1.n;
    }

    public Vector3(arc par1) {
        this.x = par1.c;
        this.y = par1.d;
        this.z = par1.e;
    }

    public Vector3(ara par1) {
        this.x = par1.b;
        this.y = par1.c;
        this.z = par1.d;
    }

    public Vector3(t par1) {
        this.x = par1.a;
        this.y = par1.b;
        this.z = par1.c;
    }

    public Vector3(ForgeDirection direction) {
        this.x = direction.offsetX;
        this.y = direction.offsetY;
        this.z = direction.offsetZ;
    }

    public int intX() {
        return (int)Math.floor(this.x);
    }

    public int intY() {
        return (int)Math.floor(this.y);
    }

    public int intZ() {
        return (int)Math.floor(this.z);
    }

    public boolean isEqual(Vector3 vector3) {
        return this.x == vector3.x && this.y == vector3.y && this.z == vector3.z;
    }

    public Vector3 clone() {
        return new Vector3(this.x, this.y, this.z);
    }

    public int getBlockID(aak world) {
        return world.a(this.intX(), this.intY(), this.intZ());
    }

    public int getBlockMetadata(aak world) {
        return world.h(this.intX(), this.intY(), this.intZ());
    }

    public aqp getTileEntity(aak world) {
        return world.r(this.intX(), this.intY(), this.intZ());
    }

    public boolean setBlock(aab world, int id, int metadata, int notify) {
        return world.f(this.intX(), this.intY(), this.intZ(), id, metadata, notify);
    }

    public boolean setBlock(aab world, int id, int metadata) {
        return this.setBlock(world, id, metadata, 3);
    }

    public boolean setBlock(aab world, int id) {
        return this.setBlock(world, id, 0);
    }

    public Vector2 toVector2() {
        return new Vector2(this.x, this.z);
    }

    public arc toVec3() {
        return arc.a((double)this.x, (double)this.y, (double)this.z);
    }

    public double getMagnitude() {
        return Math.sqrt(this.getMagnitudeSquared());
    }

    public double getMagnitudeSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3 normalize() {
        double d = this.getMagnitude();
        if (d != 0.0) {
            this.multiply(1.0 / d);
        }
        return this;
    }

    public static double distance(Vector3 par1, Vector3 par2) {
        double var2 = par1.x - par2.x;
        double var4 = par1.y - par2.y;
        double var6 = par1.z - par2.z;
        return kx.a((double)(var2 * var2 + var4 * var4 + var6 * var6));
    }

    public double distanceTo(Vector3 vector3) {
        double var2 = vector3.x - this.x;
        double var4 = vector3.y - this.y;
        double var6 = vector3.z - this.z;
        return kx.a((double)(var2 * var2 + var4 * var4 + var6 * var6));
    }

    public Vector3 add(Vector3 par1) {
        this.x += par1.x;
        this.y += par1.y;
        this.z += par1.z;
        return this;
    }

    public Vector3 add(double par1) {
        this.x += par1;
        this.y += par1;
        this.z += par1;
        return this;
    }

    public Vector3 subtract(Vector3 amount) {
        this.x -= amount.x;
        this.y -= amount.y;
        this.z -= amount.z;
        return this;
    }

    public Vector3 invert() {
        this.multiply(-1.0);
        return this;
    }

    public Vector3 multiply(double amount) {
        this.x *= amount;
        this.y *= amount;
        this.z *= amount;
        return this;
    }

    public Vector3 multiply(Vector3 vec) {
        this.x *= vec.x;
        this.y *= vec.y;
        this.z *= vec.z;
        return this;
    }

    public static Vector3 subtract(Vector3 par1, Vector3 par2) {
        return new Vector3(par1.x - par2.x, par1.y - par2.y, par1.z - par2.z);
    }

    public static Vector3 add(Vector3 par1, Vector3 par2) {
        return new Vector3(par1.x + par2.x, par1.y + par2.y, par1.z + par2.z);
    }

    public static Vector3 add(Vector3 par1, double par2) {
        return new Vector3(par1.x + par2, par1.y + par2, par1.z + par2);
    }

    public static Vector3 multiply(Vector3 vec1, Vector3 vec2) {
        return new Vector3(vec1.x * vec2.x, vec1.y * vec2.y, vec1.z * vec2.z);
    }

    public static Vector3 multiply(Vector3 vec1, double vec2) {
        return new Vector3(vec1.x * vec2, vec1.y * vec2, vec1.z * vec2);
    }

    public Vector3 round() {
        return new Vector3(Math.round(this.x), Math.round(this.y), Math.round(this.z));
    }

    public Vector3 floor() {
        return new Vector3(Math.floor(this.x), Math.floor(this.y), Math.floor(this.z));
    }

    public List getEntitiesWithin(aab worldObj, Class par1Class) {
        return worldObj.a(par1Class, aqx.a((double)this.intX(), (double)this.intY(), (double)this.intZ(), (double)(this.intX() + 1), (double)(this.intY() + 1), (double)(this.intZ() + 1)));
    }

    public Vector3 modifyPositionFromSide(ForgeDirection side, double amount) {
        switch (side.ordinal()) {
            case 0: {
                this.y -= amount;
                break;
            }
            case 1: {
                this.y += amount;
                break;
            }
            case 2: {
                this.z -= amount;
                break;
            }
            case 3: {
                this.z += amount;
                break;
            }
            case 4: {
                this.x -= amount;
                break;
            }
            case 5: {
                this.x += amount;
            }
        }
        return this;
    }

    public Vector3 modifyPositionFromSide(ForgeDirection side) {
        this.modifyPositionFromSide(side, 1.0);
        return this;
    }

    public static Vector3 readFromNBT(bs nbtCompound) {
        Vector3 tempVector = new Vector3();
        tempVector.x = nbtCompound.h("x");
        tempVector.y = nbtCompound.h("y");
        tempVector.z = nbtCompound.h("z");
        return tempVector;
    }

    public bs writeToNBT(bs par1NBTTagCompound) {
        par1NBTTagCompound.a("x", this.x);
        par1NBTTagCompound.a("y", this.y);
        par1NBTTagCompound.a("z", this.z);
        return par1NBTTagCompound;
    }

    public int hashCode() {
        return ("X:" + this.x + "Y:" + this.y + "Z:" + this.z).hashCode();
    }

    public String toString() {
        return "Vector3 [" + this.x + "," + this.y + "," + this.z + "]";
    }
}

