/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.tick;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import java.util.EnumSet;
import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.api.electricity.ElectricItemUtils;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.general.MuseMathUtils;
import net.machinemuse.powersuits.common.MuseLogger;
import net.machinemuse.powersuits.common.PlayerInputMap;
import net.machinemuse.powersuits.event.MovementManager;

public class PlayerTickHandler
implements ITickHandler {
    public void tickStart(EnumSet type, Object ... tickData) {
        sq player = PlayerTickHandler.toPlayer(tickData[0]);
        this.handle(player);
    }

    public void handle(sq player) {
        List modularItemsEquipped = MuseItemUtils.modularItemsEquipped(player);
        wm helmet = player.q(3);
        wm torso = player.q(2);
        wm pants = player.q(1);
        wm boots = player.q(0);
        wm tool = player.cb();
        double totalWeight = MuseItemUtils.getPlayerWeight(player);
        double weightCapacity = 25000.0;
        double foodAdjustment = 0.0;
        for (IPlayerTickModule module : ModuleManager.getPlayerTickModules()) {
            for (wm itemStack : modularItemsEquipped) {
                if (!module.isValidForItem(itemStack, player)) continue;
                if (MuseItemUtils.itemHasActiveModule(itemStack, module.getName())) {
                    module.onPlayerTickActive(player, itemStack);
                    continue;
                }
                module.onPlayerTickInactive(player, itemStack);
            }
        }
        if (helmet != null && helmet.b() instanceof IModularItem && helmet.q().b("ench")) {
            helmet.q().o("ench");
        }
        if (pants != null && pants.b() instanceof IModularItem && pants.q().b("ench")) {
            pants.q().o("ench");
        }
        if (boots != null && boots.b() instanceof IModularItem && boots.q().b("ench")) {
            boots.q().o("ench");
        }
        if (torso != null && torso.b() instanceof IModularItem && torso.q().b("ench")) {
            torso.q().o("ench");
        }
        player.cl().a((float)(-foodAdjustment));
        player.T = (float)MovementManager.computeFallHeightFromVelocity(MuseMathUtils.clampDouble(player.y, -1000.0, 0.0));
        if (totalWeight > weightCapacity) {
            player.x *= weightCapacity / totalWeight;
            player.z *= weightCapacity / totalWeight;
        }
    }

    public static void thrust(sq player, double thrust, double jetEnergy, boolean flightControl) {
        PlayerInputMap movementInput = PlayerInputMap.getInputMapFor(player.bS);
        boolean jumpkey = movementInput.jumpKey;
        float forwardkey = movementInput.forwardKey;
        float strafekey = movementInput.strafeKey;
        boolean downkey = movementInput.downKey;
        boolean sneakkey = movementInput.sneakKey;
        double totalEnergyDrain = 0.0;
        if (flightControl) {
            arc desiredDirection = player.Y().a();
            double strafeX = desiredDirection.e;
            double strafeZ = -desiredDirection.c;
            double scaleStrafe = strafeX * strafeX + strafeZ * strafeZ;
            desiredDirection.c = desiredDirection.c * (double)Math.signum(forwardkey) + strafeX * (double)Math.signum(strafekey);
            desiredDirection.d = desiredDirection.d * (double)Math.signum(forwardkey) + (double)(jumpkey ? 1 : 0) - (double)(downkey ? 1 : 0);
            desiredDirection.e = desiredDirection.e * (double)Math.signum(forwardkey) + strafeZ * (double)Math.signum(strafekey);
            desiredDirection = desiredDirection.a();
            if (player.y < 0.0 && desiredDirection.d >= 0.0) {
                if (-player.y > thrust) {
                    totalEnergyDrain += jetEnergy * thrust;
                    player.y += thrust;
                    thrust = 0.0;
                } else {
                    totalEnergyDrain += jetEnergy * Math.abs(player.y);
                    thrust -= player.y;
                    player.y = 0.0;
                }
            }
            if (player.y < -1.0) {
                totalEnergyDrain += jetEnergy * Math.abs(1.0 + player.y);
                thrust += 1.0 + player.y;
                player.y = -1.0;
            }
            if (Math.abs(player.x) > 0.0 && desiredDirection.b() == 0.0) {
                if (Math.abs(player.x) > thrust) {
                    totalEnergyDrain += jetEnergy * thrust;
                    player.x -= Math.signum(player.x) * thrust;
                    thrust = 0.0;
                } else {
                    totalEnergyDrain += jetEnergy * Math.abs(player.x);
                    thrust -= Math.abs(player.x);
                    player.x = 0.0;
                }
            }
            if (Math.abs(player.z) > 0.0 && desiredDirection.b() == 0.0) {
                if (Math.abs(player.z) > thrust) {
                    totalEnergyDrain += jetEnergy * thrust;
                    player.z -= Math.signum(player.z) * thrust;
                    thrust = 0.0;
                } else {
                    totalEnergyDrain += jetEnergy * Math.abs(player.z);
                    thrust -= Math.abs(player.z);
                    player.z = 0.0;
                }
            }
            double vx = thrust * desiredDirection.c;
            double vy = thrust * desiredDirection.d;
            double vz = thrust * desiredDirection.e;
            player.x += vx;
            player.y += vy;
            player.z += vz;
            ElectricItemUtils.drainPlayerEnergy(player, totalEnergyDrain += jetEnergy * (vx * vx + vy * vy + vz * vz));
        } else {
            arc playerHorzFacing = player.Y();
            playerHorzFacing.d = 0.0;
            playerHorzFacing.a();
            totalEnergyDrain += jetEnergy;
            if (forwardkey == 0.0f) {
                player.y += thrust;
            } else {
                player.y += thrust / 2.0;
                player.x += playerHorzFacing.c * thrust / 2.0 * (double)Math.signum(forwardkey);
                player.z += playerHorzFacing.e * thrust / 2.0 * (double)Math.signum(forwardkey);
            }
        }
    }

    public static double getWeightPenaltyRatio(double currentWeight, double capacity) {
        if (currentWeight < capacity) {
            return 1.0;
        }
        return capacity / currentWeight;
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
        sq player = PlayerTickHandler.toPlayer(tickData[0]);
        List stacks = MuseItemUtils.getModularItemsInInventory((lt)player.bK);
    }

    public static aab toWorld(Object data) {
        aab world = null;
        try {
            world = (aab)data;
        }
        catch (ClassCastException e) {
            MuseLogger.logError("MMMPS: Player tick handler received invalid World object");
            e.printStackTrace();
        }
        return world;
    }

    public static sq toPlayer(Object data) {
        sq player = null;
        try {
            player = (sq)((Object)data);
        }
        catch (ClassCastException e) {
            MuseLogger.logError("MMMPS: Player tick handler received invalid Player object");
            e.printStackTrace();
        }
        return player;
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.PLAYER);
    }

    public String getLabel() {
        return "MMMPS: Player Tick";
    }
}

