/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.weapon;

import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.api.MusePlayerUtils;
import net.machinemuse.api.electricity.ElectricItemUtils;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;

public class RailgunModule
extends PowerModuleBase
implements IRightClickModule {
    public static final String MODULE_RAILGUN = "Railgun";
    private static String IMPULSE = "Railgun Total Impulse";
    private static String ENERGY = "Railgun Energy Cost";

    public RailgunModule(List validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.solenoid, 6));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.hvcapacitor, 1));
        this.addBaseProperty(IMPULSE, 500.0, "Ns");
        this.addBaseProperty(ENERGY, 500.0, "J");
        this.addTradeoffProperty("Voltage", IMPULSE, 2500.0);
        this.addTradeoffProperty("Voltage", ENERGY, 2500.0);
    }

    @Override
    public String getCategory() {
        return "Weapon";
    }

    @Override
    public String getName() {
        return MODULE_RAILGUN;
    }

    @Override
    public String getDescription() {
        return "An assembly which accelerates a projectile to supersonic speeds using magnetic force. Heavy recoil.";
    }

    public void drawParticleStreamTo(sq source, aab world, double x2, double y, double z) {
        arc direction = source.Y().a();
        double scale = 1.0;
        double xoffset = 1.3f;
        double yoffset = -0.2;
        double zoffset = 0.3f;
        arc horzdir = direction.a();
        horzdir.d = 0.0;
        horzdir = horzdir.a();
        double cx2 = source.u + direction.c * xoffset - direction.d * horzdir.c * yoffset - horzdir.e * zoffset;
        double cy2 = source.v + (double)source.e() + direction.d * xoffset + (1.0 - Math.abs(direction.d)) * yoffset;
        double cz2 = source.w + direction.e * xoffset - direction.d * horzdir.e * yoffset + horzdir.c * zoffset;
        double dx2 = x2 - cx2;
        double dy2 = y - cy2;
        double dz2 = z - cz2;
        double ratio = Math.sqrt(dx2 * dx2 + dy2 * dy2 + dz2 * dz2);
        while (Math.abs(cx2 - x2) > Math.abs(dx2 / ratio)) {
            world.a("townaura", cx2, cy2, cz2, 0.0, 0.0, 0.0);
            cx2 += dx2 * 0.1 / ratio;
            cy2 += dy2 * 0.1 / ratio;
            cz2 += dz2 * 0.1 / ratio;
        }
    }

    @Override
    public void onRightClick(sq player, aab world, wm itemStack) {
        double range = 64.0;
        double energyConsumption = ModuleManager.computeModularProperty(itemStack, ENERGY);
        if (ElectricItemUtils.getPlayerEnergy(player) > energyConsumption) {
            ElectricItemUtils.drainPlayerEnergy(player, energyConsumption);
            ara hitMOP = MusePlayerUtils.doCustomRayTrace(player.q, player, true, range);
            world.a((mp)((Object)player), "random.bow", 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
            double damage = ModuleManager.computeModularProperty(itemStack, IMPULSE) / 100.0;
            double knockback = damage / 20.0;
            arc lookVec = player.Y();
            if (hitMOP != null) {
                switch (hitMOP.a) {
                    case b: {
                        this.drawParticleStreamTo(player, world, hitMOP.f.c, hitMOP.f.d, hitMOP.f.e);
                        mg damageSource = mg.a((sq)player);
                        if (!hitMOP.g.a(damageSource, (int)damage)) break;
                        hitMOP.g.g(lookVec.c * knockback, Math.abs(lookVec.d + (double)0.2f) * knockback, lookVec.e * knockback);
                        break;
                    }
                    case a: {
                        this.drawParticleStreamTo(player, world, hitMOP.f.c, hitMOP.f.d, hitMOP.f.e);
                        break;
                    }
                }
                player.g(-lookVec.c * knockback, Math.abs(-lookVec.d + (double)0.2f) * knockback, -lookVec.e * knockback);
                world.a((mp)((Object)player), "random.bow", 0.5f, 0.4f / ((float)Math.random() * 0.4f + 0.8f));
            }
        }
    }

    @Override
    public String getTextureFile() {
        return "electricweapon";
    }

    @Override
    public void onItemUse(wm stack, sq player, aab world, int x2, int y, int z, int side, float hitX, float hitY, float hitZ) {
    }

    @Override
    public boolean onItemUseFirst(wm itemStack, sq player, aab world, int x2, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void onPlayerStoppedUsing(wm itemStack, aab world, sq player, int par4) {
    }
}

