/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.weapon;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.api.electricity.ElectricItemUtils;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.powersuits.entity.EntityPlasmaBolt;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.network.packets.MusePacketPlasmaBolt;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;

public class PlasmaCannonModule
extends PowerModuleBase
implements IRightClickModule {
    public static final String MODULE_PLASMA_CANNON = "Plasma Cannon";
    public static final String PLASMA_CANNON_ENERGY_PER_TICK = "Plasma Energy Per Tick";
    public static final String PLASMA_CANNON_DAMAGE_AT_FULL_CHARGE = "Plasma Damage At Full Charge";
    public static final String PLASMA_CANNON_EXPLOSIVENESS = "Plasma Explosiveness";

    public PlasmaCannonModule(List validItems) {
        super(validItems);
        this.addBaseProperty(PLASMA_CANNON_ENERGY_PER_TICK, 10.0, "J");
        this.addBaseProperty(PLASMA_CANNON_DAMAGE_AT_FULL_CHARGE, 2.0, "pt");
        this.addTradeoffProperty("Amperage", PLASMA_CANNON_ENERGY_PER_TICK, 150.0, "J");
        this.addTradeoffProperty("Amperage", PLASMA_CANNON_DAMAGE_AT_FULL_CHARGE, 38.0, "pt");
        this.addTradeoffProperty("Voltage", PLASMA_CANNON_ENERGY_PER_TICK, 50.0, "J");
        this.addTradeoffProperty("Voltage", PLASMA_CANNON_EXPLOSIVENESS, 0.5, "Creeper");
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.fieldEmitter, 2));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.hvcapacitor, 2));
    }

    @Override
    public String getCategory() {
        return "Weapon";
    }

    @Override
    public String getName() {
        return MODULE_PLASMA_CANNON;
    }

    @Override
    public String getDescription() {
        return "Use electrical arcs in a containment field to superheat air to a plasma and launch it at enemies.";
    }

    @Override
    public void onRightClick(sq player, aab world, wm item) {
        if (ElectricItemUtils.getPlayerEnergy(player) > 500.0) {
            player.a(item, 72000);
        }
    }

    @Override
    public String getTextureFile() {
        return "gravityweapon";
    }

    @Override
    public void onItemUse(wm stack, sq player, aab world, int x2, int y, int z, int side, float hitX, float hitY, float hitZ) {
    }

    @Override
    public boolean onItemUseFirst(wm itemStack, sq player, aab world, int x2, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void onPlayerStoppedUsing(wm itemStack, aab world, sq player, int par4) {
        int chargeTicks = Math.max(itemStack.n() - par4, 10);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            double energyConsumption = ModuleManager.computeModularProperty(itemStack, PLASMA_CANNON_ENERGY_PER_TICK) * (double)chargeTicks;
            if (ElectricItemUtils.getPlayerEnergy(player) > energyConsumption) {
                ElectricItemUtils.drainPlayerEnergy(player, energyConsumption);
                double explosiveness = ModuleManager.computeModularProperty(itemStack, PLASMA_CANNON_EXPLOSIVENESS);
                double damagingness = ModuleManager.computeModularProperty(itemStack, PLASMA_CANNON_DAMAGE_AT_FULL_CHARGE);
                EntityPlasmaBolt plasmaBolt = new EntityPlasmaBolt(world, player, explosiveness, damagingness, chargeTicks);
                world.d((mp)((Object)plasmaBolt));
                MusePacketPlasmaBolt packet = new MusePacketPlasmaBolt((Player)player, plasmaBolt.k, plasmaBolt.size);
                PacketDispatcher.sendPacketToAllPlayers((ei)packet.getPacket250());
            }
        }
    }
}

