/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.api.electricity.ElectricItemUtils;
import net.machinemuse.api.moduletrigger.IBlockBreakingModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class ShovelModule
extends PowerModuleBase
implements IBlockBreakingModule,
IToggleableModule {
    public static final String MODULE_SHOVEL = "Shovel";
    public static final wm ironShovel = new wm(wk.g);
    public static final String SHOVEL_HARVEST_SPEED = "Shovel Harvest Speed";
    public static final String SHOVEL_ENERGY_CONSUMPTION = "Shovel Energy Consumption";

    public ShovelModule(List validItems) {
        super(validItems);
        this.addInstallCost(new wm(wk.p, 3));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.solenoid, 1));
        this.addBaseProperty(SHOVEL_ENERGY_CONSUMPTION, 50.0, "J");
        this.addBaseProperty(SHOVEL_HARVEST_SPEED, 8.0, "x");
        this.addTradeoffProperty("Overclock", SHOVEL_ENERGY_CONSUMPTION, 950.0);
        this.addTradeoffProperty("Overclock", SHOVEL_HARVEST_SPEED, 22.0);
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getName() {
        return MODULE_SHOVEL;
    }

    @Override
    public String getDescription() {
        return "Shovels are good for soft materials like dirt and sand.";
    }

    @Override
    public String getTextureFile() {
        return "toolshovel";
    }

    @Override
    public boolean canHarvestBlock(wm stack, apa block, int meta, sq player) {
        return (ironShovel.b(block) || ForgeHooks.canToolHarvestBlock((apa)block, (int)meta, (wm)ironShovel)) && ElectricItemUtils.getPlayerEnergy(player) > ModuleManager.computeModularProperty(stack, SHOVEL_ENERGY_CONSUMPTION);
    }

    @Override
    public boolean onBlockDestroyed(wm stack, aab world, int blockID, int x2, int y, int z, sq player) {
        ElectricItemUtils.drainPlayerEnergy(player, ModuleManager.computeModularProperty(stack, SHOVEL_ENERGY_CONSUMPTION));
        return true;
    }

    @Override
    public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        event.newSpeed = (float)((double)event.newSpeed * ModuleManager.computeModularProperty(event.entityPlayer.cb(), SHOVEL_HARVEST_SPEED));
    }
}

