/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.api.electricity.ElectricItemUtils;
import net.machinemuse.api.moduletrigger.IBlockBreakingModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class PickaxeModule
extends PowerModuleBase
implements IBlockBreakingModule,
IToggleableModule {
    public static final String MODULE_PICKAXE = "Pickaxe";
    public static final wm ironPickaxe = new wm(wk.h);
    public static final String PICKAXE_HARVEST_SPEED = "Pickaxe Harvest Speed";
    public static final String PICKAXE_ENERGY_CONSUMPTION = "Pickaxe Energy Consumption";

    public PickaxeModule(List validItems) {
        super(validItems);
        this.addInstallCost(new wm(wk.p, 3));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.solenoid, 1));
        this.addBaseProperty(PICKAXE_ENERGY_CONSUMPTION, 50.0, "J");
        this.addBaseProperty(PICKAXE_HARVEST_SPEED, 8.0, "x");
        this.addTradeoffProperty("Overclock", PICKAXE_ENERGY_CONSUMPTION, 950.0);
        this.addTradeoffProperty("Overclock", PICKAXE_HARVEST_SPEED, 22.0);
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getName() {
        return MODULE_PICKAXE;
    }

    @Override
    public String getDescription() {
        return "Picks are good for harder materials like stone and ore.";
    }

    @Override
    public String getTextureFile() {
        return "toolpick";
    }

    @Override
    public boolean canHarvestBlock(wm stack, apa block, int meta, sq player) {
        return (ironPickaxe.b(block) || ForgeHooks.canToolHarvestBlock((apa)block, (int)meta, (wm)ironPickaxe)) && ElectricItemUtils.getPlayerEnergy(player) > ModuleManager.computeModularProperty(stack, PICKAXE_ENERGY_CONSUMPTION);
    }

    @Override
    public boolean onBlockDestroyed(wm stack, aab world, int blockID, int x2, int y, int z, sq player) {
        ElectricItemUtils.drainPlayerEnergy(player, ModuleManager.computeModularProperty(stack, PICKAXE_ENERGY_CONSUMPTION));
        return true;
    }

    @Override
    public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        event.newSpeed = (float)((double)event.newSpeed * ModuleManager.computeModularProperty(event.entityPlayer.cb(), PICKAXE_HARVEST_SPEED));
    }
}

