/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.List;
import net.machinemuse.api.moduletrigger.IRightClickModule;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.common.ModCompatability;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import universalelectricity.core.block.IConductor;
import universalelectricity.core.electricity.ElectricityDisplay;
import universalelectricity.core.electricity.ElectricityPack;

public class MultimeterModule
extends PowerModuleBase
implements IRightClickModule {
    public static final String MODULE_MULTIMETER = "Multimeter";

    public MultimeterModule(String name, List validItems) {
        super(name, validItems);
        this.addInstallCost(Config.copyAndResize(ItemComponent.wiring, 2)).addInstallCost(Config.copyAndResize(ItemComponent.solenoid, 1));
    }

    public MultimeterModule(List validItems) {
        super(validItems);
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getName() {
        return MODULE_MULTIMETER;
    }

    @Override
    public String getDescription() {
        return "A tool addon that reads the Universal Electricity power generation in a wire.";
    }

    @Override
    public String getTextureFile() {
        return "redplate";
    }

    @Override
    public boolean onItemUseFirst(wm itemStack, sq player, aab worldObj, int x2, int y, int z, int side, float hitX, float hitY, float hitZ) {
        aqp tileEntity;
        if (ModCompatability.isBasicComponentsLoaded() && !worldObj.I && (tileEntity = worldObj.r(x2, y, z)) instanceof IConductor) {
            IConductor wireTile = (IConductor)tileEntity;
            ElectricityPack getProduced = wireTile.getNetwork().getProduced(new aqp[0]);
            player.b("Reading: " + ElectricityDisplay.getDisplay(getProduced.amperes, ElectricityDisplay.ElectricUnit.AMPERE) + ", " + ElectricityDisplay.getDisplay(getProduced.voltage, ElectricityDisplay.ElectricUnit.VOLTAGE) + ", " + ElectricityDisplay.getDisplay(getProduced.getWatts() * 20.0, ElectricityDisplay.ElectricUnit.WATT));
            return true;
        }
        return false;
    }

    @Override
    public void onRightClick(sq playerClicking, aab world, wm item) {
    }

    @Override
    public void onItemUse(wm itemStack, sq player, aab world, int x2, int y, int z, int side, float hitX, float hitY, float hitZ) {
    }

    @Override
    public void onPlayerStoppedUsing(wm itemStack, aab world, sq player, int par4) {
    }
}

