/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.tool;

import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.api.electricity.ElectricItemUtils;
import net.machinemuse.api.moduletrigger.IBlockBreakingModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class AxeModule
extends PowerModuleBase
implements IBlockBreakingModule,
IToggleableModule {
    public static final String MODULE_AXE = "Axe";
    public static final wm ironAxe = new wm(wk.i);
    public static final String AXE_ENERGY_CONSUMPTION = "Axe Energy Consumption";
    public static final String AXE_HARVEST_SPEED = "Axe Harvest Speed";

    public AxeModule(List validItems) {
        super(validItems);
        this.addInstallCost(new wm(wk.p, 3));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.solenoid, 1));
        this.addBaseProperty(AXE_ENERGY_CONSUMPTION, 50.0, "J");
        this.addBaseProperty(AXE_HARVEST_SPEED, 8.0, "x");
        this.addTradeoffProperty("Overclock", AXE_ENERGY_CONSUMPTION, 950.0);
        this.addTradeoffProperty("Overclock", AXE_HARVEST_SPEED, 22.0);
    }

    @Override
    public String getCategory() {
        return "Tool";
    }

    @Override
    public String getName() {
        return MODULE_AXE;
    }

    @Override
    public String getDescription() {
        return "Axes are mostly for chopping trees.";
    }

    @Override
    public String getTextureFile() {
        return "toolaxe";
    }

    @Override
    public boolean canHarvestBlock(wm stack, apa block, int meta, sq player) {
        return (ironAxe.b(block) || ForgeHooks.canToolHarvestBlock((apa)block, (int)meta, (wm)ironAxe)) && ElectricItemUtils.getPlayerEnergy(player) > ModuleManager.computeModularProperty(stack, AXE_ENERGY_CONSUMPTION);
    }

    @Override
    public boolean onBlockDestroyed(wm stack, aab world, int blockID, int x2, int y, int z, sq player) {
        ElectricItemUtils.drainPlayerEnergy(player, ModuleManager.computeModularProperty(stack, AXE_ENERGY_CONSUMPTION));
        return true;
    }

    @Override
    public void handleBreakSpeed(PlayerEvent.BreakSpeed event) {
        event.newSpeed = (float)((double)event.newSpeed * ModuleManager.computeModularProperty(event.entityPlayer.cb(), AXE_HARVEST_SPEED));
    }
}

