/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.movement;

import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.api.electricity.ElectricItemUtils;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.common.PlayerInputMap;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;

public class SwimAssistModule
extends PowerModuleBase
implements IToggleableModule,
IPlayerTickModule {
    public static final String MODULE_SWIM_BOOST = "Swim Boost";
    public static final String SWIM_BOOST_AMOUNT = "Underwater Movement Boost";
    public static final String SWIM_BOOST_ENERGY_CONSUMPTION = "Swim Boost Energy Consumption";

    public SwimAssistModule(List validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.ionThruster, 1));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.solenoid, 2));
        this.addTradeoffProperty("Thrust", SWIM_BOOST_ENERGY_CONSUMPTION, 100.0, "J");
        this.addTradeoffProperty("Thrust", SWIM_BOOST_AMOUNT, 1.0, "m/s");
    }

    @Override
    public String getCategory() {
        return "Movement";
    }

    @Override
    public String getName() {
        return MODULE_SWIM_BOOST;
    }

    @Override
    public String getDescription() {
        return "By refitting an ion thruster for underwater use, you may be able to add extra forward (or backward) thrust when underwater.";
    }

    @Override
    public void onPlayerTickActive(sq player, wm item) {
        if (player.G()) {
            wm pants = player.q(1);
            PlayerInputMap movementInput = PlayerInputMap.getInputMapFor(player.bS);
            boolean jumpkey = movementInput.jumpKey;
            boolean sneakkey = movementInput.sneakKey;
            float forwardkey = movementInput.forwardKey;
            float strafekey = movementInput.strafeKey;
            if (forwardkey != 0.0f || strafekey != 0.0f || jumpkey || sneakkey) {
                double moveRatio = 0.0;
                if (forwardkey != 0.0f) {
                    moveRatio += (double)(forwardkey * forwardkey);
                }
                if (strafekey != 0.0f) {
                    moveRatio += (double)(strafekey * strafekey);
                }
                if (jumpkey || sneakkey) {
                    moveRatio += 0.04000000000000001;
                }
                double swimAssistRate = ModuleManager.computeModularProperty(pants, SWIM_BOOST_AMOUNT) * 0.05;
                double swimEnergyConsumption = ModuleManager.computeModularProperty(pants, SWIM_BOOST_ENERGY_CONSUMPTION);
                if (swimEnergyConsumption < ElectricItemUtils.getPlayerEnergy(player)) {
                    player.x += player.Y().c * swimAssistRate * (double)forwardkey / moveRatio;
                    player.y += player.Y().d * swimAssistRate * (double)forwardkey / moveRatio;
                    player.z += player.Y().e * swimAssistRate * (double)forwardkey / moveRatio;
                    if (jumpkey) {
                        player.y += swimAssistRate * 0.2 / moveRatio;
                    }
                    if (sneakkey) {
                        player.y -= swimAssistRate * 0.2 / moveRatio;
                    }
                    ElectricItemUtils.drainPlayerEnergy(player, swimEnergyConsumption);
                }
            }
        }
    }

    @Override
    public void onPlayerTickInactive(sq player, wm item) {
    }

    @Override
    public String getTextureFile() {
        return "swimboost";
    }
}

