/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.movement;

import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.electricity.ElectricItemUtils;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.common.Config;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;

public class SprintAssistModule
extends PowerModuleBase
implements IToggleableModule,
IPlayerTickModule {
    public static final String MODULE_SPRINT_ASSIST = "Sprint Assist";
    public static final String SPRINT_ENERGY_CONSUMPTION = "Sprint Energy Consumption";
    public static final String SPRINT_SPEED_MULTIPLIER = "Sprint Speed Multiplier";
    public static final String SPRINT_FOOD_COMPENSATION = "Sprint Exhaustion Compensation";
    public static final String WALKING_ENERGY_CONSUMPTION = "Walking Energy Consumption";
    public static final String WALKING_SPEED_MULTIPLIER = "Walking Speed Multiplier";

    public SprintAssistModule(List validItems) {
        super(validItems);
        this.addInstallCost(Config.copyAndResize(ItemComponent.servoMotor, 4));
        this.addSimpleTradeoff(this, "Power", SPRINT_ENERGY_CONSUMPTION, "J", 0.0, 10.0, SPRINT_SPEED_MULTIPLIER, "%", 1.0, 2.0);
        this.addSimpleTradeoff(this, "Compensation", SPRINT_ENERGY_CONSUMPTION, "J", 0.0, 2.0, SPRINT_FOOD_COMPENSATION, "%", 0.0, 1.0);
        this.addSimpleTradeoff(this, "Walking Assist", WALKING_ENERGY_CONSUMPTION, "J", 0.0, 10.0, WALKING_SPEED_MULTIPLIER, "%", 1.0, 1.0);
    }

    @Override
    public String getCategory() {
        return "Movement";
    }

    @Override
    public String getName() {
        return MODULE_SPRINT_ASSIST;
    }

    @Override
    public String getDescription() {
        return "A set of servo motors to help you sprint (double-tap forward) and walk faster.";
    }

    @Override
    public void onPlayerTickActive(sq player, wm item) {
        double horzMovement = Math.sqrt(player.x * player.x + player.z * player.z);
        double totalEnergy = ElectricItemUtils.getPlayerEnergy(player);
        if (player.ah()) {
            double exhaustion = (double)Math.round(horzMovement * 100.0) * 0.01;
            double sprintCost = ModuleManager.computeModularProperty(item, SPRINT_ENERGY_CONSUMPTION);
            if (sprintCost < totalEnergy) {
                double sprintMultiplier = ModuleManager.computeModularProperty(item, SPRINT_SPEED_MULTIPLIER);
                double exhaustionComp = ModuleManager.computeModularProperty(item, SPRINT_FOOD_COMPENSATION);
                ElectricItemUtils.drainPlayerEnergy(player, sprintCost * horzMovement * 5.0);
                player.aO = (float)((double)player.aO * sprintMultiplier);
                player.cl().a((float)(-0.01 * exhaustion * exhaustionComp));
                player.aP = player.aO * 0.5f;
            }
        } else {
            double cost = ModuleManager.computeModularProperty(item, WALKING_ENERGY_CONSUMPTION);
            if (cost < totalEnergy) {
                double walkMultiplier = ModuleManager.computeModularProperty(item, WALKING_SPEED_MULTIPLIER);
                ElectricItemUtils.drainPlayerEnergy(player, cost * horzMovement * 5.0);
                player.aO = (float)((double)player.aO * walkMultiplier);
                player.aP = player.aO * 0.5f;
            }
        }
    }

    @Override
    public void onPlayerTickInactive(sq player, wm item) {
    }

    @Override
    public String getTextureFile() {
        return "sprintassist";
    }
}

