/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.movement;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.common.PlayerInputMap;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.tick.PlayerTickHandler;

public class ParachuteModule
extends PowerModuleBase
implements IToggleableModule,
IPlayerTickModule {
    public static final String MODULE_PARACHUTE = "Parachute";

    public ParachuteModule(List validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.parachute, 2));
    }

    @Override
    public String getCategory() {
        return "Movement";
    }

    @Override
    public String getName() {
        return MODULE_PARACHUTE;
    }

    @Override
    public String getDescription() {
        return "Add a parachute to slow your descent. Activate by pressing sneak (defaults to Shift) in midair.";
    }

    @Override
    public void onPlayerTickActive(sq player, wm item) {
        double totalVelocity;
        PlayerInputMap movementInput = PlayerInputMap.getInputMapFor(player.bS);
        float forwardkey = movementInput.forwardKey;
        boolean sneakkey = movementInput.sneakKey;
        wm torso = player.q(2);
        boolean hasGlider = false;
        if (torso != null && torso.b() instanceof IModularItem) {
            hasGlider = MuseItemUtils.itemHasActiveModule(torso, "Glider");
        }
        if (sneakkey && player.y < -0.1 && (!hasGlider || forwardkey <= 0.0f) && (totalVelocity = Math.sqrt(player.x * player.x + player.z * player.z + player.y * player.y) * PlayerTickHandler.getWeightPenaltyRatio(MuseItemUtils.getPlayerWeight(player), 25000.0)) > 0.0) {
            player.x = player.x * 0.1 / totalVelocity;
            player.y = player.y * 0.1 / totalVelocity;
            player.z = player.z * 0.1 / totalVelocity;
        }
    }

    @Override
    public void onPlayerTickInactive(sq player, wm item) {
    }

    @Override
    public String getTextureFile() {
        return "parachute";
    }
}

