/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.movement;

import java.util.List;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.common.PlayerInputMap;
import net.machinemuse.powersuits.event.MovementManager;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.tick.PlayerTickHandler;

public class JumpAssistModule
extends PowerModuleBase
implements IToggleableModule,
IPlayerTickModule {
    public static final String MODULE_JUMP_ASSIST = "Jump Assist";
    public static final String JUMP_ENERGY_CONSUMPTION = "Jump Energy Consumption";
    public static final String JUMP_MULTIPLIER = "Jump Boost";
    public static final String JUMP_FOOD_COMPENSATION = "Jump Exhaustion Compensation";

    public JumpAssistModule(List validItems) {
        super(validItems);
        this.addSimpleTradeoff(this, "Power", JUMP_ENERGY_CONSUMPTION, "J", 0.0, 25.0, JUMP_MULTIPLIER, "%", 1.0, 4.0);
        this.addSimpleTradeoff(this, "Compensation", JUMP_ENERGY_CONSUMPTION, "J", 0.0, 5.0, JUMP_FOOD_COMPENSATION, "%", 0.0, 1.0);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.servoMotor, 4));
    }

    @Override
    public String getCategory() {
        return "Movement";
    }

    @Override
    public String getName() {
        return MODULE_JUMP_ASSIST;
    }

    @Override
    public String getDescription() {
        return "Another set of servo motors to help you jump higher.";
    }

    @Override
    public void onPlayerTickActive(sq player, wm item) {
        PlayerInputMap movementInput = PlayerInputMap.getInputMapFor(player.bS);
        boolean jumpkey = movementInput.jumpKey;
        if (jumpkey) {
            double multiplier = MovementManager.getPlayerJumpMultiplier(player);
            if (multiplier > 0.0) {
                player.y += 0.15 * Math.min(multiplier, 1.0) * PlayerTickHandler.getWeightPenaltyRatio(MuseItemUtils.getPlayerWeight(player), 25000.0);
                MovementManager.setPlayerJumpTicks(player, multiplier - 1.0);
            }
            player.aP = player.aO * 0.7f;
        } else {
            MovementManager.setPlayerJumpTicks(player, 0.0);
        }
    }

    @Override
    public void onPlayerTickInactive(sq player, wm item) {
    }

    @Override
    public String getTextureFile() {
        return "jumpassist";
    }
}

