/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.movement;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.api.electricity.ElectricItemUtils;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.common.PlayerInputMap;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;
import net.machinemuse.powersuits.tick.PlayerTickHandler;

public class JetPackModule
extends PowerModuleBase
implements IToggleableModule,
IPlayerTickModule {
    public static final String MODULE_JETPACK = "Jetpack";
    public static final String JET_ENERGY_CONSUMPTION = "Jet Energy Consumption";
    public static final String JET_THRUST = "Jet Thrust";

    public JetPackModule(List validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.ionThruster, 4));
        this.addBaseProperty(JET_ENERGY_CONSUMPTION, 0.0, "J/t");
        this.addBaseProperty(JET_THRUST, 0.0, "N");
        this.addTradeoffProperty("Thrust", JET_ENERGY_CONSUMPTION, 150.0);
        this.addTradeoffProperty("Thrust", JET_THRUST, 0.16);
    }

    @Override
    public String getCategory() {
        return "Movement";
    }

    @Override
    public String getName() {
        return MODULE_JETPACK;
    }

    @Override
    public String getDescription() {
        return "A jetpack should allow you to jump indefinitely, or at least until you run out of power.";
    }

    @Override
    public void onPlayerTickActive(sq player, wm item) {
        PlayerInputMap movementInput = PlayerInputMap.getInputMapFor(player.bS);
        boolean jumpkey = movementInput.jumpKey;
        wm helmet = player.q(3);
        wm torso = player.q(2);
        boolean hasFlightControl = false;
        if (helmet != null && helmet.b() instanceof IModularItem) {
            hasFlightControl = MuseItemUtils.itemHasActiveModule(helmet, "Flight Control");
        }
        double jetEnergy = 0.0;
        double thrust = 0.0;
        jetEnergy += ModuleManager.computeModularProperty(torso, JET_ENERGY_CONSUMPTION);
        thrust += ModuleManager.computeModularProperty(torso, JET_THRUST);
        if (jetEnergy < ElectricItemUtils.getPlayerEnergy(player)) {
            thrust *= PlayerTickHandler.getWeightPenaltyRatio(MuseItemUtils.getPlayerWeight(player), 25000.0);
            if (hasFlightControl && thrust > 0.0) {
                PlayerTickHandler.thrust(player, thrust, jetEnergy, true);
            } else if (jumpkey && player.y < 0.5) {
                PlayerTickHandler.thrust(player, thrust, jetEnergy, false);
            }
        }
    }

    @Override
    public void onPlayerTickInactive(sq player, wm item) {
    }

    @Override
    public String getTextureFile() {
        return "jetpack";
    }
}

