/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.movement;

import java.util.List;
import net.machinemuse.api.IModularItem;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.common.PlayerInputMap;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;

public class GliderModule
extends PowerModuleBase
implements IToggleableModule,
IPlayerTickModule {
    public static final String MODULE_GLIDER = "Glider";

    @Override
    public String getTextureFile() {
        return "glider";
    }

    public GliderModule(List validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.gliderWing, 2));
    }

    @Override
    public String getCategory() {
        return "Movement";
    }

    @Override
    public String getName() {
        return MODULE_GLIDER;
    }

    @Override
    public String getDescription() {
        return "Tack on some wings to turn downward into forward momentum. Press sneak+forward while falling to activate.";
    }

    @Override
    public void onPlayerTickActive(sq player, wm item) {
        arc playerHorzFacing = player.Y();
        playerHorzFacing.d = 0.0;
        playerHorzFacing.a();
        PlayerInputMap movementInput = PlayerInputMap.getInputMapFor(player.bS);
        boolean sneakkey = movementInput.sneakKey;
        float forwardkey = movementInput.forwardKey;
        wm torso = player.q(2);
        boolean hasParachute = false;
        if (torso != null && torso.b() instanceof IModularItem) {
            hasParachute = MuseItemUtils.itemHasActiveModule(torso, "Parachute");
        }
        if (sneakkey && player.y < -0.1 && (!hasParachute || forwardkey > 0.0f) && player.y < -0.1) {
            double motionYchange = Math.min(0.08, -0.1 - player.y);
            player.y += motionYchange;
            player.x += playerHorzFacing.c * motionYchange;
            player.z += playerHorzFacing.e * motionYchange;
            player.aP += 0.03f;
        }
    }

    @Override
    public void onPlayerTickInactive(sq player, wm item) {
    }
}

