/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.misc;

import java.util.List;
import net.machinemuse.api.ModuleManager;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.api.electricity.ElectricItemUtils;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;

public class WaterElectrolyzerModule
extends PowerModuleBase
implements IPlayerTickModule,
IToggleableModule {
    public static final String WATERBREATHING_ENERGY_CONSUMPTION = "Jolt Energy";
    public static final String MODULE_WATER_ELECTROLYZER = "Water Electrolyzer";

    public WaterElectrolyzerModule(List validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.lvcapacitor, 1));
        this.addBaseProperty(WATERBREATHING_ENERGY_CONSUMPTION, 1000.0, "J");
    }

    @Override
    public String getCategory() {
        return "Environment";
    }

    @Override
    public String getName() {
        return MODULE_WATER_ELECTROLYZER;
    }

    @Override
    public String getDescription() {
        return "When you run out of air, this module will jolt the water around you, electrolyzing a small bubble to breathe from.";
    }

    @Override
    public void onPlayerTickActive(sq player, wm item) {
        double energyConsumption;
        double energy = ElectricItemUtils.getPlayerEnergy(player);
        if (energy > (energyConsumption = ModuleManager.computeModularProperty(item, WATERBREATHING_ENERGY_CONSUMPTION)) && player.ak() < 10) {
            ElectricItemUtils.drainPlayerEnergy(player, energyConsumption);
            player.g(300);
        }
    }

    @Override
    public void onPlayerTickInactive(sq player, wm item) {
    }

    @Override
    public String getTextureFile() {
        return "waterelectrolyzer";
    }
}

