/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.powermodule.misc;

import java.util.Collection;
import java.util.List;
import net.machinemuse.api.MuseItemUtils;
import net.machinemuse.api.electricity.ElectricItemUtils;
import net.machinemuse.api.moduletrigger.IPlayerTickModule;
import net.machinemuse.api.moduletrigger.IToggleableModule;
import net.machinemuse.powersuits.item.ItemComponent;
import net.machinemuse.powersuits.powermodule.PowerModuleBase;

public class NightVisionModule
extends PowerModuleBase
implements IPlayerTickModule,
IToggleableModule {
    public static final String MODULE_NIGHT_VISION = "Night Vision";

    public NightVisionModule(List validItems) {
        super(validItems);
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.laserHologram, 1));
        this.addInstallCost(MuseItemUtils.copyAndResize(ItemComponent.controlCircuit, 1));
    }

    @Override
    public String getCategory() {
        return "Special";
    }

    @Override
    public String getName() {
        return MODULE_NIGHT_VISION;
    }

    @Override
    public String getDescription() {
        return "A pair of augmented vision goggles to help you see at night and underwater.";
    }

    @Override
    public void onPlayerTickActive(sq player, wm item) {
        double totalEnergy = ElectricItemUtils.getPlayerEnergy(player);
        ml nightVision = null;
        Collection effects = player.bC();
        for (ml effect : effects) {
            if (effect.c() != -337 || effect.a() != mk.r.H) continue;
            nightVision = effect;
            break;
        }
        if (5.0 < totalEnergy) {
            if (nightVision == null || nightVision.b() < 210) {
                player.d(new ml(mk.r.H, 500, -337));
                ElectricItemUtils.drainPlayerEnergy(player, 5.0);
            }
        } else if (nightVision != null) {
            player.o(mk.r.H);
        }
    }

    @Override
    public void onPlayerTickInactive(sq player, wm item) {
    }

    @Override
    public String getTextureFile() {
        return "nightvision";
    }
}

